<?php
/**
 * Two Column section
 *
 * This is the template for the content of two_column section
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */
if ( ! function_exists( 'corpopress_pro_add_two_column_section' ) ) :
    /**
    * Add two_column section
    *
    *@since Corpopress Pro 1.0.0
    */
    function corpopress_pro_add_two_column_section() {
    	$options = corpopress_pro_get_theme_options();
        // Check if two_column is enabled on frontpage
        $two_column_enable = apply_filters( 'corpopress_pro_section_status', true, 'two_column_section_enable' );

        if ( true !== $two_column_enable ) {
            return false;
        }
        // Get two_column section details
        $section_details = array();
        $section_details = apply_filters( 'corpopress_pro_filter_two_column_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render two_column section now.
        corpopress_pro_render_two_column_section( $section_details );
    }
endif;

if ( ! function_exists( 'corpopress_pro_get_two_column_section_details' ) ) :
    /**
    * two_column section details.
    *
    * @since Corpopress Pro 1.0.0
    * @param array $input two_column section details.
    */
    function corpopress_pro_get_two_column_section_details( $input ) {
        $options = corpopress_pro_get_theme_options();

        // Content type.
        $two_column_content_type  = $options['two_column_content_type'];
        $two_column_count = ! empty( $options['two_column_count'] ) ? $options['two_column_count'] : 4;
        
        $content = array();
        switch ( $two_column_content_type ) {
        	
            case 'page':
                $page_ids = array();

                for ( $i = 1; $i <= $two_column_count; $i++ ) {
                    if ( ! empty( $options['two_column_content_page_' . $i] ) )
                        $page_ids[] = $options['two_column_content_page_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $two_column_count ),
                    'orderby'           => 'post__in',
                    );                    
            break;

            case 'post':
                $post_ids = array();

                for ( $i = 1; $i <= $two_column_count; $i++ ) {
                    if ( ! empty( $options['two_column_content_post_' . $i] ) )
                        $post_ids[] = $options['two_column_content_post_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $two_column_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'category':
                $cat_id = ! empty( $options['two_column_content_category'] ) ? $options['two_column_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $two_column_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            default:
            break;
        }


        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['excerpt']   = corpopress_pro_trim_content( $options['two_column_excerpt'] );
                $page_post['image']  	= has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'post-thumbnail' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// two_column section content details.
add_filter( 'corpopress_pro_filter_two_column_section_details', 'corpopress_pro_get_two_column_section_details' );


if ( ! function_exists( 'corpopress_pro_render_two_column_section' ) ) :
  /**
   * Start two_column section
   *
   * @return string two_column content
   * @since Corpopress Pro 1.0.0
   *
   */
   function corpopress_pro_render_two_column_section( $content_details = array() ) {
        $options = corpopress_pro_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="corpopress_pro_two_column_section">

        <div id="magazine-two-column-posts" class="relative page-section same-background">
                <div class="wrapper">
                    <?php if( !empty( $options['two_column_title'] ) ): ?>
                    <div class="section-header">
                        <h2 class="section-title"><?php echo esc_html( $options['two_column_title'] ); ?></h2>
                    </div><!-- .section-header -->
                <?php endif; ?>

                    <div class="section-content clear">
                       
                    <?php foreach ($content_details as $content ): ?>

                         <article class="has-post-thumbnail">
                            <div class="featured-post-item">
                                <div class="featured-image">
                                    <img src="<?php echo esc_url( $content['image'] ); ?>">

                                    <?php corpopress_pro_posted_on( $content['id'] ); ?> 
                                </div><!-- .featured-image -->

                                <div class="entry-container">
                                    <?php the_category( '', '', $content['id'] ); ?>

                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                    </header>   

                                    <div class="entry-content">
                                        <p><?php echo esc_html( $content['excerpt'] ); ?></p>
                                    </div><!-- .entry-content -->
                                </div><!-- .entry-container -->
                            </div><!-- .featured-post-item -->
                        </article>
                        
                    <?php endforeach; ?>
                       
                    </div><!-- .section-content -->
                </div><!-- .wrapper -->
            </div>

            </div>

    <?php }
endif;