<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */

$options = corpopress_pro_get_theme_options();
$class = has_post_thumbnail() ? '' : 'has-post-thumbnail';
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( $class ); ?>>

    <div class="blog-wrapper">
        <?php if ( ! $options['hide_author'] ) : ?>
            <div class="header-meta">
                <?php echo corpopress_pro_blog_author(get_the_author_meta('ID')); ?>
            </div><!-- .header-meta -->
        <?php endif; ?>

        <div class="featured-image">
            <a href="<?php the_permalink(); ?>">
                <?php if ( has_post_thumbnail() ) : ?>                
                        <?php the_post_thumbnail( 'post-thumbnail', array( 'alt' => the_title_attribute( 'echo=0' ) ) ) ?>      
                    <?php else: ?>
                        <img src="<?php echo esc_url( get_template_directory_uri() ) . '/assets/uploads/no-featured-image-590x650.jpg';?>" alt="<?php the_title(); ?>">              
                <?php endif; ?>
            </a>
            <?php if ( ! $options['hide_date'] ) : ?>
                <div class="entry-meta">
                    <?php corpopress_pro_posted_on(); ?> 
                </div><!-- .entry-meta -->
            <?php endif; ?>
        </div><!-- .featured-image -->

        <div class="entry-container">
            <header class="entry-header">
                <h2 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
            </header>
            <div class="entry-content">
                <?php the_excerpt(); ?>
            </div><!-- .entry-content -->
        </div><!-- .entry-container -->
    </div><!-- .blog-wrapper -->

</article><!-- #post-## -->
