jQuery(document).ready(function($) {

/*------------------------------------------------
            DECLARATIONS
------------------------------------------------*/

    var loader = $('#loader');
    var loader_container = $('#preloader');
    var scroll              = $(window).scrollTop();  
    var scrollup            = $('.backtotop');
    var menu_toggle         = $('.menu-toggle');
    var dropdown_toggle     = $('button.dropdown-toggle');
    var nav_menu            = $('.main-navigation');
    var featured_profile    = $('.profile-slider');
    var working_experience_slider  = $('.working-experience-slider');
    var modern_testimonial_slider  = $('.modern-slider .testimonial-slider');
    var classic_testimonial_slider  = $('.classic-slider .testimonial-slider');
    var masonry_gallery = $('.grid');

/*------------------------------------------------
            PRELOADER
------------------------------------------------*/

    loader_container.delay(1000).fadeOut();
    loader.delay(1000).fadeOut("slow");

/*------------------------------------------------
            BACK TO TOP
------------------------------------------------*/

    $(window).scroll(function() {
        if ($(this).scrollTop() > 1) {
            scrollup.css({bottom:"25px"});
        } 
        else {
            scrollup.css({bottom:"-100px"});
        }
    });

    scrollup.click(function() {
        $('html, body').animate({scrollTop: '0px'}, 800);
        return false;
    });

/*------------------------------------------------
            MAIN NAVIGATION
------------------------------------------------*/

    menu_toggle.click(function(){
        nav_menu.slideToggle();
        $(this).toggleClass('active');
        $('.menu-overlay').toggleClass('active');
        $('.main-navigation').toggleClass('menu-open');
        $('body').toggleClass('main-navigation-active');
    });

    $(window).scroll(function() {
        if ($(this).scrollTop() > 1) {
            $('.menu-sticky #masthead').addClass('nav-shrink');
        }
        else {
            $('.menu-sticky #masthead').removeClass('nav-shrink');
        }
    });

    dropdown_toggle.click(function() {
        $(this).toggleClass('active');
       $(this).parent().find('.sub-menu').first().slideToggle();
       $('#primary-menu > li:last-child button.active').unbind('keydown');
    });

/*------------------------------------------------
            Sliders
------------------------------------------------*/

featured_profile.slick({
    responsive: [
    {
        breakpoint: 767,
        settings: {
            slidesToShow: 1
        }
    }
    ]
});

working_experience_slider.slick({
    responsive: [
    {
    breakpoint: 1200,
        settings: {
            slidesToShow: 3,
            arrows: false
        }
    },
    {
        breakpoint: 767,
            settings: {
            slidesToShow: 2,
            arrows: false
        }
    },
    {
        breakpoint: 567,
            settings: {
            slidesToShow: 1,
            arrows: false
        }
    }
    ]
});

modern_testimonial_slider.slick({
    slidesToShow: 3, 
    slidesToScroll: 1, 
    infinite: true, 
    speed: 1500, 
    dots: false, 
    arrows:true, 
    autoplay: true, 
    draggable: true, 
    centerMode: true, 
    focusOnSelect: true, 
    fade: false,
    responsive: [
    {
    breakpoint: 992,
        settings: {
            slidesToShow: 1,
            centerMode: false,
            arrows: false
        }
    }
    ]
});

classic_testimonial_slider.slick({
    slidesToShow: 1, 
    slidesToScroll: 1, 
    infinite: true, 
    speed: 1500, 
    dots: true, 
    arrows: false, 
    autoplay: true, 
    draggable: true, 
    centerMode: false, 
    focusOnSelect: false, 
    responsive: [
    {
    breakpoint: 992,
        settings: {
            slidesToShow: 1,
            centerMode: false,
            arrows: false
        }
    }
    ]
});

$('#business-slider').slick();


/*------------------------------------------------
                Tabs
------------------------------------------------*/

$('ul.tabs li').click(function(event) {
    event.preventDefault();

    var tab_id = $(this).attr('data-tab');

    $('ul.tabs li').removeClass('active');
    $('.tab-content').removeClass('active');
    $('.tab-content').fadeOut();
    $(this).addClass('active');
    $("#"+tab_id).fadeIn();

});

/*------------------------------------------------
            MASONRY GALLERY
------------------------------------------------*/

masonry_gallery.imagesLoaded( function() {
    masonry_gallery.packery({
        itemSelector: '.grid-item'
    });
});

/*------------------------------------------------
            SKILLS
------------------------------------------------*/
$('.skill-item').each(function(){
    $(this).find('.skillbar-inner').animate({
        width:$(this).attr('data-percent')
    },2000);
});

/*------------------------------------------------
            MATCH HEIGHT
------------------------------------------------*/
$('#latest-posts article').matchHeight();
$('.working-experience-slider .entry-container').matchHeight();


/*--------------------------------------------------------------
 Keyboard Navigation
----------------------------------------------------------------*/
if( $(window).width() < 1024 ) {
    $('#primary-menu').find("li").last().bind( 'keydown', function(e) {
        if( e.which === 9 ) {
            e.preventDefault();
            $('#masthead').find('.menu-toggle').focus();
        }
    });

    $('#primary-menu > li:last-child button:not(.active)').bind( 'keydown', function(e) {
        if( e.which === 9 ) {
            e.preventDefault();
            $('#masthead').find('.menu-toggle').focus();
        }
    });
}
else {
    $('#primary-menu').find("li").unbind('keydown');
}

$(window).resize(function() {
    if( $(window).width() < 1024 ) {
        $('#primary-menu').find("li").last().bind( 'keydown', function(e) {
            if( e.which === 9 ) {
                e.preventDefault();
                $('#masthead').find('.menu-toggle').focus();
            }
        });

        $('#primary-menu > li:last-child button:not(.active)').bind( 'keydown', function(e) {
            if( e.which === 9 ) {
                e.preventDefault();
                $('#masthead').find('.menu-toggle').focus();
            }
        });
    }
    else {
        $('#primary-menu').find("li").unbind('keydown');
    }
});

menu_toggle.on('keydown', function (e) {
    var tabKey    = e.keyCode === 9;
    var shiftKey  = e.shiftKey;

    if( menu_toggle.hasClass('active') ) {
        if ( shiftKey && tabKey ) {
            e.preventDefault();
            nav_menu.slideUp();
            $('.main-navigation').removeClass('menu-open');
            $('.menu-overlay').removeClass('active');
            menu_toggle.removeClass('active');
        };
    }
});


/*------------------------------------------------
                END JQUERY
------------------------------------------------*/

});