<?php
	/**
	 * The header for our theme.
	 *
	 * This is the template that displays all of the <head> section and everything up until <div id="content">
	 *
	 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
	 *
	 * @package Theme Palace
	 * @subpackage Myself Pro
	 * @since Myself Pro 1.0.0
	 */

	/**
	 * myself_pro_doctype hook
	 *
	 * @hooked myself_pro_doctype -  10
	 *
	 */
	do_action( 'myself_pro_doctype' );

?>
<head>
<?php
	/**
	 * myself_pro_before_wp_head hook
	 *
	 * @hooked myself_pro_head -  10
	 *
	 */
	do_action( 'myself_pro_before_wp_head' );

	wp_head(); 
?>
</head>

<body <?php body_class(); ?>>

<?php do_action( 'wp_body_open' ); ?>

<?php
	/**
	 * myself_pro_page_start_action hook
	 *
	 * @hooked myself_pro_page_start -  10
	 *
	 */
	do_action( 'myself_pro_page_start_action' ); 

	/**
	 * myself_pro_loader_action hook
	 *
	 * @hooked myself_pro_loader -  10
	 *
	 */
	do_action( 'myself_pro_before_header' );

	/**
	 * myself_pro_header_action hook
	 *
	 * @hooked myself_pro_header_start -  10
	 * @hooked myself_pro_site_branding -  20
	 * @hooked myself_pro_site_navigation -  30
	 * @hooked myself_pro_header_end -  50
	 *
	 */
	do_action( 'myself_pro_header_action' );

	/**
	 * myself_pro_content_start_action hook
	 *
	 * @hooked myself_pro_content_start -  10
	 *
	 */
	do_action( 'myself_pro_content_start_action' );

	/**
	 * myself_pro_header_image_action hook
	 *
	 * @hooked myself_pro_header_image -  10
	 *
	 */
	do_action( 'myself_pro_header_image_action' );

    if ( myself_pro_is_frontpage() ) {
		$options  = myself_pro_get_theme_options();
		$sections = myself_pro_sortable_sections();
		$sections = array( 'introduction', 'about', 'my_profile', 'service', 'experience', 'portfolio', 'video', 'clients', 'testimonial', 'skills', 'blog', 'contact', 'cta', 'instagram');

		if ( $options['home_layout'] == 'third-design' ) {
			$sections = array( 'introduction', 'about', 'popular_destination', 'counter', 'business_service', 'portfolio', 'video', 'popular_tours', 'subscription', 'blog');
		}elseif($options['home_layout'] == 'fourth-design'){
			$sections = array( 'introduction', 'about', 'helpus', 'business_service', 'portfolio', 'counter', 'testimonial', 'team', 'subscription', 'blog');
		}elseif($options['home_layout'] == 'fifth-design'){
			$sections = array( 'introduction', 'about', 'business_service', 'counter', 'course', 'subscription', 'team', 'testimonial', 'blog');
		}elseif($options['home_layout'] == 'sixth-design'){
			$sections = array( 'introduction', 'helpus', 'course', 'main_post', 'blog');
		}elseif($options['home_layout'] == 'seventh-design'){
			$sections = array( 'introduction', 'helpus', 'photography', 'course', 'blog');
		}elseif($options['home_layout'] == 'eight-design'){
			$sections = array( 'introduction', 'business_service', 'about', 'counter', 'team','subscription', 'blog');
		}

		if($options['home_layout'] == 'default-design'){
			$sections = myself_pro_sortable_sections();

			foreach ( $sections as $section => $value ) {
				add_action( 'myself_pro_primary_content', 'myself_pro_add_'. $section .'_section', myself_pro_sort( $section ) );
			}

		}else{

			foreach ( $sections as  $section ) {
				add_action( 'myself_pro_primary_content', 'myself_pro_add_'. $section .'_section');
			}
		}

		do_action( 'myself_pro_primary_content' );
	}