<?php
/**
 * Myself Pro: Color Patterns
 *
 * @package WordPress
 * @subpackage Myself Pro
 * @since 1.0
 */

/**
 * Generate the CSS for the current custom color scheme.
 */
function myself_pro_custom_colors_css() {
  	$options= myself_pro_get_theme_options();

	$color_value = $options['colorscheme_hue'];
	
	$css = '
	/*--------------------------------------------------------------
	## Background Color
	--------------------------------------------------------------*/
	.backtotop,
	#respond input[type="submit"],
	.pagination .page-numbers.current,
	.pagination .page-numbers:hover,
	.pagination .page-numbers:focus,
	.widget_search form.search-form .search-submit:hover,
	.widget_search form.search-form .search-submit:focus,
	input[type="submit"],
	.jetpack_subscription_widget input[type="submit"],
	.jetpack_subscription_widget input[type="submit"]:hover,
	.jetpack_subscription_widget input[type="submit"]:focus,
	#secondary .jetpack_subscription_widget input[type="submit"]:hover,
	#secondary .jetpack_subscription_widget input[type="submit"]:focus,
	.reply a,
	.btn,
	.more-link:hover, 
	.more-link:focus,
	.slick-dots li.slick-active button,
	.section-title:after,
	.separator,
	#colophon .widget-title:before,
	#colophon .widgettitle:before,
	.medical-read-more a,
	#medical-slider .slick-dots li.slick-active button,
	#medical-reasons,
	#medical-news .date,
	#medical-news .date:before {
	    background-color: '. esc_attr( $color_value ) .';
	}
	#my-video,
	#working-experience,
	#my-skills .overlay,
	#contact-me .overlay {
	    background: '. esc_attr( $color_value ) .';
	}

	/*--------------------------------------------------------------
	## Text Color
	--------------------------------------------------------------*/
	a,
	.site-title a:hover,
	.site-title a:focus,
	.main-navigation ul#primary-menu li.current-menu-item > a,
	.main-navigation ul#primary-menu li:hover > a,
	.main-navigation a:hover,
	.main-navigation ul.nav-menu > li > a:hover,
	.post-navigation a:hover, 
	.posts-navigation a:hover,
	.post-navigation a:focus, 
	.posts-navigation a:focus,
	.widget_popular_post h3 a:hover,
	.widget_popular_post h3 a:focus,
	.widget_popular_post a:hover time,
	.widget_popular_post a:focus time,
	.widget_latest_post h3 a:hover,
	.widget_latest_post h3 a:focus,
	.widget_latest_post a:hover time,
	.widget_latest_post a:focus time,
	.widget_featured_post h3 a:hover,
	.widget_featured_post h3 a:focus,
	.widget_featured_post a:hover time,
	.widget_featured_post a:focus time,
	.widget_popular_post a time,
	.widget_popular_post time,
	.widget_latest_post a time,
	.widget_latest_post time,
	.widget_featured_post a time,
	.widget_featured_post time,
	#secondary a:hover,
	#secondary a:focus,
	.comment-meta .url:hover,
	.comment-meta .url:focus,
	.comment-metadata a,
	.comment-metadata a time,
	.comment-metadata a:hover,
	.comment-metadata a:focus,
	.comment-metadata a:hover time,
	.comment-metadata a:focus time,
	.section-subtitle,
	#introduction-section .entry-title a:hover,
	#introduction-section .entry-title a:focus,
	.profile-slider article:hover .entry-title,
	.profile-slider article:hover .entry-header p,
	ul.tabs li.active a,
	ul.tabs li a:hover,
	ul.tabs li a:focus,
	#my-services .entry-title a:hover,
	#my-services .entry-title a:focus,
	.working-experience-slider .entry-title a:hover,
	.working-experience-slider .entry-title a:focus,
	.working-experience-slider .posted-on a:hover,
	.working-experience-slider .posted-on a:focus,
	.post-categories li a:hover,
	.post-categories li a:focus,
	.title-wrapper .entry-title a:hover,
	.title-wrapper .entry-title a:focus,
	.single .post-categories a:hover,
	.single .post-categories a:focus,
	.archive-blog-wrapper .entry-title a:hover,
	.archive-blog-wrapper .entry-title a:focus,
	.archive-blog-wrapper .byline a:hover,
	.archive-blog-wrapper .posted-on a:hover,
	.archive-blog-wrapper .byline a:focus,
	.archive-blog-wrapper .posted-on a:focus,
	.single .posted-on a,
	#colophon a:hover,
	#colophon a:focus,
	.working-experience-slider .posted-on a,
	.post-categories li:not(:last-child):after,
	.post-categories li a,
	#colophon .site-info a,
	#medical-slider .medical-read-more a,
	#medical-features .feature-icon a,
	#medical-news .entry-title a:hover,
	#medical-news .entry-title a:focus,
	#medical-about-us .entry-title a:hover,
	#medical-about-us .entry-title a:focus,
	#medical-services .entry-title a:hover,
	#medical-services .entry-title a:focus {
	    color: '. esc_attr( $color_value ) .';
	}

	.main-navigation ul#primary-menu li:hover > svg,
	.main-navigation li.menu-item-has-children:hover > a > svg,
	.main-navigation li.menu-item-has-children > a:hover > svg,
	.main-navigation ul#primary-menu > li.current-menu-item > a > svg,
	.main-navigation ul.nav-menu > li > a.search:hover svg.icon-search,
	.main-navigation ul.nav-menu > li > a.search:focus svg.icon-search,
	.main-navigation li.search-menu a:hover svg,
	.main-navigation li.search-menu a:focus svg,
	.main-navigation li.search-menu a.search-active svg,
	.widget svg,
	.navigation.posts-navigation a:hover svg, 
	.navigation.post-navigation a:hover svg,
	.navigation.posts-navigation a:focus svg, 
	.navigation.post-navigation a:focus svg {
	    fill: '. esc_attr( $color_value ) .';
	}

	/*--------------------------------------------------------------
	## Border Color
	--------------------------------------------------------------*/
	.profile-slider article:hover .entry-header p,
	ul.tabs li.active a {
	    border-bottom-color: '. esc_attr( $color_value ) .';
	}
	.more-link:hover, 
	.more-link:focus {
	    border-color: '. esc_attr( $color_value ) .';
	}


	/*--------------------------------------------------------------
	## Preloader
	--------------------------------------------------------------*/
	@keyframes preloader {
	    0% {height:5px;transform:translateY(0px);background: '. esc_attr( $color_value ) .';}
	    25% {height:30px;transform:translateY(15px);background: '. esc_attr( $color_value ) .';}
	    50% {height:5px;transform:translateY(0px);background: '. esc_attr( $color_value ) .';}
	    100% {height:5px;transform:translateY(0px);background: '. esc_attr( $color_value ) .';}
	}


	@media screen and (min-width: 1024px) {
	    .main-navigation li.menu-item-has-children:hover > a > svg, 
	    .main-navigation li.menu-item-has-children > a:hover > svg,
	    .main-navigation ul#primary-menu > li.current-menu-item > a > svg {
	        fill: '. esc_attr( $color_value ) .';
	    }
	    #masthead .main-navigation ul#primary-menu li.current-menu-item > a,
	    #masthead .main-navigation ul.nav-menu > li > a:hover,
	    .main-navigation ul#primary-menu li:hover > a {
	        color: '. esc_attr( $color_value ) .';
	    }
	    .main-navigation ul.sub-menu li:hover > a,
	    .main-navigation ul.sub-menu li:focus > a {
	        background-color: '. esc_attr( $color_value ) .';
	        color: #fff;
	    }
	}
	';

	/**
	 * Filters Myself Pro custom colors CSS.
	 *
	 * @since Myself Pro 1.0.0
	 *
	 * @param string $css        Base theme colors CSS.
	 */
	return apply_filters( 'myself_pro_custom_colors_css', $css );
}
