<?php
/**
 * Core file.
 *
 * This is the template that includes all the other files for core featured of Theme Palace
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */

/**
 * Load theme updater functions.
 * Action is used so that child themes can easily disable.
 */
function myself_pro_pro_theme_updater() {
    if( is_admin() ) {
        require get_template_directory() . '/inc/updater/theme-updater.php';
    }
}
add_action( 'after_setup_theme', 'myself_pro_pro_theme_updater' );

/**
 * Include options function.
 */
require get_template_directory() . '/inc/options.php';


// Load customizer defaults values
require get_template_directory() . '/inc/customizer/defaults.php';


/**
 * Merge values from default options array and values from customizer
 *
 * @return array Values returned from customizer
 * @since Myself Pro 1.0.0
 */
function myself_pro_get_theme_options() {
  $myself_pro_default_options = myself_pro_get_default_theme_options();

  return array_merge( $myself_pro_default_options , get_theme_mod( 'myself_pro_theme_options', $myself_pro_default_options ) ) ;
}

/**
 * Display custom color CSS.
 */
function myself_pro_colors_css_wrap() {
    $options= myself_pro_get_theme_options();
    if ( 'custom' !== $options['colorscheme'] ) {
        return;
    }

    require get_template_directory() . '/inc/color-pattern.php';
    $color = $options['colorscheme_hue'];
    ?>
    <style type="text/css" id="custom-theme-colors" <?php if ( is_customize_preview() ) { echo 'data-color="' . $color . '"'; } ?>>
        <?php echo myself_pro_custom_colors_css(); ?>

    </style>
<?php }
add_action( 'wp_head', 'myself_pro_colors_css_wrap' );

function myself_pro_indrocustion_title_padding_css_wrap() {
    $options= myself_pro_get_theme_options();
   
    ?>
    <style type="text/css">
        
        <?php if( $options['introduction_image_style'] == 'full' ){ ?>

            @media screen and (min-width: 992px){

            #introduction-section {
            padding: 300px 0 100px 0;
                }
            }

            @media screen and (min-width: 1900px){
                #introduction-section .entry-title {
                    font-size: 110px;
                    max-width: 600px;
                }

            }

            
        <?php } ?>

    </style>
<?php }
add_action( 'wp_head', 'myself_pro_indrocustion_title_padding_css_wrap' );

/**
 * Load admin custom styles
 * 
 */
function myself_pro_load_admin_style() {
    wp_register_style( 'myself_pro_admin_css', get_template_directory_uri() . '/assets/css/admin-style.css', false, '1.0.0' );
    wp_enqueue_style( 'myself_pro_admin_css' );
}
add_action( 'admin_enqueue_scripts', 'myself_pro_load_admin_style' );

/**
 * Add breadcrumb functions.
 */
require get_template_directory() . '/inc/breadcrumb-class.php';

/**
 * Add helper functions.
 */
require get_template_directory() . '/inc/helpers.php';

/**
 * Add structural hooks.
 */
require get_template_directory() . '/inc/structure.php';

/**
 * Add metabox
 */
require get_template_directory() . '/inc/metabox.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer/customizer.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/sections/sections.php';

/**
* Download webfonts locally.
*/
require get_template_directory() . '/inc/wptt-webfont-loader.php';

/**
* TGM plugin additions.
*/
require get_template_directory() . '/inc/tgm-plugin/tgm-hook.php';

if ( class_exists( 'CatchThemesDemoImportPlugin' ) ) {
    /**
    * OCDI plugin demo importer compatibility.
    */
    require get_template_directory() . '/inc/demo-import.php';
}