<?php
/**
 * Customizer active callbacks
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */

if ( ! function_exists( 'myself_pro_is_loader_enable' ) ) :
	/**
	 * Check if loader is enabled.
	 *
	 * @since Myself Pro 1.0.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function myself_pro_is_loader_enable( $control ) {
		return $control->manager->get_setting( 'myself_pro_theme_options[loader_enable]' )->value();
	}
endif;

if ( ! function_exists( 'myself_pro_is_breadcrumb_enable' ) ) :
	/**
	 * Check if breadcrumb is enabled.
	 *
	 * @since Myself Pro 1.0.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function myself_pro_is_breadcrumb_enable( $control ) {
		return $control->manager->get_setting( 'myself_pro_theme_options[breadcrumb_enable]' )->value();
	}
endif;

if ( ! function_exists( 'myself_pro_is_pagination_enable' ) ) :
	/**
	 * Check if pagination is enabled.
	 *
	 * @since Myself Pro 1.0.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function myself_pro_is_pagination_enable( $control ) {
		return $control->manager->get_setting( 'myself_pro_theme_options[pagination_enable]' )->value();
	}
endif;

/**
 * Front Page Active Callbacks
 */

/**
 * Check if introduction section is enabled.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_introduction_section_enable( $control ) {
	return ( $control->manager->get_setting( 'myself_pro_theme_options[introduction_section_enable]' )->value() );
}

/**
 * Check if introduction section content type is post.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_introduction_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[introduction_content_type]' )->value();
	return myself_pro_is_introduction_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if introduction section content type is page.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_introduction_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[introduction_content_type]' )->value();
	return myself_pro_is_introduction_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if introduction section content type is page.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_introduction_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[introduction_content_type]' )->value();
	return myself_pro_is_introduction_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if introduction section content type is custom.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_introduction_section_content_custom_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[introduction_content_type]' )->value();
	return myself_pro_is_introduction_section_enable( $control ) && ( 'custom' == $content_type );
}

/**
 * Check if about section is enabled.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_about_section_enable( $control ) {
	return ( $control->manager->get_setting( 'myself_pro_theme_options[about_section_enable]' )->value() );
}

/**
 * Check if about section content type is post.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_about_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[about_content_type]' )->value();
	return myself_pro_is_about_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if about section content type is page.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_about_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[about_content_type]' )->value();
	return myself_pro_is_about_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if about section content type is custom.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_about_section_content_custom_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[about_content_type]' )->value();
	return myself_pro_is_about_section_enable( $control ) && ( 'custom' == $content_type );
}

/**
 * Check if my_profile section is enabled.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_my_profile_section_enable( $control ) {
	return ( $control->manager->get_setting( 'myself_pro_theme_options[my_profile_section_enable]' )->value() );
}

/**
 * Check if my_profile section content type is category.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_my_profile_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[my_profile_content_type]' )->value();
	return myself_pro_is_my_profile_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if my_profile section content type is page.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_my_profile_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[my_profile_content_type]' )->value();
	return myself_pro_is_my_profile_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if my_profile section content type is post.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_my_profile_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[my_profile_content_type]' )->value();
	return myself_pro_is_my_profile_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if service section is enabled.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_service_section_enable( $control ) {
	return ( $control->manager->get_setting( 'myself_pro_theme_options[service_section_enable]' )->value() );
}

/**
 * Check if experience section is enabled.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_experience_section_enable( $control ) {
	return ( $control->manager->get_setting( 'myself_pro_theme_options[experience_section_enable]' )->value() );
}

/**
 * Check if experience section content type is custom.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_experience_section_content_custom_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[experience_content_type]' )->value();
	return myself_pro_is_experience_section_enable( $control ) && ( 'custom' == $content_type );
}

/**
 * Check if experience section content type is page.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_experience_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[experience_content_type]' )->value();
	return myself_pro_is_experience_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if experience section content type is post.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_experience_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[experience_content_type]' )->value();
	return myself_pro_is_experience_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if portfolio section is enabled.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_portfolio_section_enable( $control ) {
	return ( $control->manager->get_setting( 'myself_pro_theme_options[portfolio_section_enable]' )->value() );
}

/**
 * Check if portfolio section content type is category.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_portfolio_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[portfolio_content_type]' )->value();
	return myself_pro_is_portfolio_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if portfolio section content type is page.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_portfolio_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[portfolio_content_type]' )->value();
	return myself_pro_is_portfolio_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if portfolio section content type is post.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_portfolio_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[portfolio_content_type]' )->value();
	return myself_pro_is_portfolio_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if portfolio section content type is trip.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_portfolio_section_content_trip_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[portfolio_content_type]' )->value();
	return myself_pro_is_portfolio_section_enable( $control ) && ( 'trip' == $content_type );
}

/**
 * Check if portfolio section content type is trip types.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_portfolio_section_content_trip_types_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[portfolio_content_type]' )->value();
	return myself_pro_is_portfolio_section_enable( $control ) && ( 'trip-types' == $content_type );
}

/**
 * Check if portfolio section content type is destination.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_portfolio_section_content_destination_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[portfolio_content_type]' )->value();
	return myself_pro_is_portfolio_section_enable( $control ) && ( 'destination' == $content_type );
}

/**
 * Check if portfolio section content type is activity.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_portfolio_section_content_activity_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[portfolio_content_type]' )->value();
	return myself_pro_is_portfolio_section_enable( $control ) && ( 'activity' == $content_type );
}

/**
 * Check if video section is enabled.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_video_section_enable( $control ) {
	return ( $control->manager->get_setting( 'myself_pro_theme_options[video_section_enable]' )->value() );
}

/**
 * Check if clients section is enabled.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_clients_section_enable( $control ) {
	return ( $control->manager->get_setting( 'myself_pro_theme_options[clients_section_enable]' )->value() );
}

/**
 * Check if clients section content type is post.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_clients_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[clients_content_type]' )->value();
	return myself_pro_is_clients_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if clients section content type is page.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_clients_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[clients_content_type]' )->value();
	return myself_pro_is_clients_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if clients section content type is category.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_clients_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[clients_content_type]' )->value();
	return myself_pro_is_clients_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if clients section content type is custom.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_clients_section_content_custom_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[clients_content_type]' )->value();
	return myself_pro_is_clients_section_enable( $control ) && ( 'custom' == $content_type );
}

/**
 * Check if testimonial section is enabled.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_testimonial_section_enable( $control ) {
	return ( $control->manager->get_setting( 'myself_pro_theme_options[testimonial_section_enable]' )->value() );
}

/**
 * Check if testimonial section seperator.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_testimonial_section_content_seperator_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[testimonial_content_type]' )->value();
	return myself_pro_is_testimonial_section_enable( $control ) && ( 'category' !== $content_type );
}

/**
 * Check if testimonial section content type is post.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_testimonial_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[testimonial_content_type]' )->value();
	return myself_pro_is_testimonial_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if testimonial section content type is page.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_testimonial_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[testimonial_content_type]' )->value();
	return myself_pro_is_testimonial_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if testimonial section content type is category.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_testimonial_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[testimonial_content_type]' )->value();
	return myself_pro_is_testimonial_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if testimonial section content type is position.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_testimonial_section_content_position_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[testimonial_content_type]' )->value();
	return myself_pro_is_testimonial_section_enable( $control ) && ( 'category' !== $content_type );
}

/**
 * Check if testimonial section content type is custom.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_testimonial_section_content_custom_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[testimonial_content_type]' )->value();
	return myself_pro_is_testimonial_section_enable( $control ) && ( 'custom' == $content_type );
}

/**
 * Check if skills section is enabled.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_skills_section_enable( $control ) {
	return ( $control->manager->get_setting( 'myself_pro_theme_options[skills_section_enable]' )->value() );
}

/**
 * Check if skills section content type is post.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_skills_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[skills_content_type]' )->value();
	return myself_pro_is_skills_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if skills section content type is page.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_skills_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[skills_content_type]' )->value();
	return myself_pro_is_skills_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if skills section content type is custom.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_skills_section_content_custom_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[skills_content_type]' )->value();
	return myself_pro_is_skills_section_enable( $control ) && ( 'custom' == $content_type );
}

/**
 * Check if blog section is enabled.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_blog_section_enable( $control ) {
	return ( $control->manager->get_setting( 'myself_pro_theme_options[blog_section_enable]' )->value() );
}

/**
 * Check if blog section content type is post.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_blog_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[blog_content_type]' )->value();
	return myself_pro_is_blog_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if blog section content type is page.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_blog_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[blog_content_type]' )->value();
	return myself_pro_is_blog_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if blog section content type is category.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_blog_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[blog_content_type]' )->value();
	return myself_pro_is_blog_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if blog section content type is recent.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_blog_section_content_recent_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[blog_content_type]' )->value();
	return myself_pro_is_blog_section_enable( $control ) && ( 'recent' == $content_type );
}

/**
 * Check if contact section is enabled.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_contact_section_enable( $control ) {
	return ( $control->manager->get_setting( 'myself_pro_theme_options[contact_section_enable]' )->value() );
}

/**
 * Check if cta section is enabled.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_cta_section_enable( $control ) {
	return ( $control->manager->get_setting( 'myself_pro_theme_options[cta_section_enable]' )->value() );
}

/**
 * Check if cta section content type is post.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_cta_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[cta_content_type]' )->value();
	return myself_pro_is_cta_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if cta section content type is page.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_cta_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[cta_content_type]' )->value();
	return myself_pro_is_cta_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if cta section content type is custom.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_cta_section_content_custom_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[cta_content_type]' )->value();
	return myself_pro_is_cta_section_enable( $control ) && ( 'custom' == $content_type );
}

/*Popular Destination*/

/**
 * Check if popular destination section is enabled.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_popular_destination_section_enable( $control ) {
	return ( $control->manager->get_setting( 'myself_pro_theme_options[popular_destination_section_enable]' )->value() );
}

/**
 * Check if popular destination section content type is page.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_popular_destination_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[popular_destination_content_type]' )->value();
	return myself_pro_is_popular_destination_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if popular destination section content type is post.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_popular_destination_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[popular_destination_content_type]' )->value();
	return myself_pro_is_popular_destination_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if popular destination section content type is trip.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_popular_destination_section_content_trip_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[popular_destination_content_type]' )->value();
	return myself_pro_is_popular_destination_section_enable( $control ) && ( 'trip' == $content_type );
}

/**
 * Check if popular destination section content type is category.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_popular_destination_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[popular_destination_content_type]' )->value();
	return myself_pro_is_popular_destination_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if popular destination section content type is trip types.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_popular_destination_section_content_trip_types_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[popular_destination_content_type]' )->value();
	return myself_pro_is_popular_destination_section_enable( $control ) && ( 'trip-types' == $content_type );
}

/**
 * Check if popular destination section content type is destination.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_popular_destination_section_content_destination_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[popular_destination_content_type]' )->value();
	return myself_pro_is_popular_destination_section_enable( $control ) && ( 'destination' == $content_type );
}

/**
 * Check if popular destination section content type is activity.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_popular_destination_section_content_activity_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[popular_destination_content_type]' )->value();
	return myself_pro_is_popular_destination_section_enable( $control ) && ( 'activity' == $content_type );
}

/**
 * Check if counter section is enabled.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_counter_section_enable( $control ) {
	return ( $control->manager->get_setting( 'myself_pro_theme_options[counter_section_enable]' )->value() );
}

/*Popular Tour*/
/**
 * Check if popular tours section is enabled.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_popular_tours_section_enable( $control ) {
	return ( $control->manager->get_setting( 'myself_pro_theme_options[popular_tours_section_enable]' )->value() );
}

/**
 * Check if popular tours section content type is page.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_popular_tours_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[popular_tours_content_type]' )->value();
	return myself_pro_is_popular_tours_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if popular tours section content type is post.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_popular_tours_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[popular_tours_content_type]' )->value();
	return myself_pro_is_popular_tours_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if popular tours section content type is trip.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_popular_tours_section_content_trip_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[popular_tours_content_type]' )->value();
	return myself_pro_is_popular_tours_section_enable( $control ) && ( 'trip' == $content_type );
}

/**
 * Check if popular tours section content type is category.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_popular_tours_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[popular_tours_content_type]' )->value();
	return myself_pro_is_popular_tours_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if popular tours section content type is trip types.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_popular_tours_section_content_trip_types_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[popular_tours_content_type]' )->value();
	return myself_pro_is_popular_tours_section_enable( $control ) && ( 'trip-types' == $content_type );
}

/**
 * Check if popular tours section content type is tours.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_popular_tours_section_content_tours_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[popular_tours_content_type]' )->value();
	return myself_pro_is_popular_tours_section_enable( $control ) && ( 'tours' == $content_type );
}

/**
 * Check if popular tours section content type is activity.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_popular_tours_section_content_activity_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[popular_tours_content_type]' )->value();
	return myself_pro_is_popular_tours_section_enable( $control ) && ( 'activity' == $content_type );
}

function myself_pro_subscription_section_enable( $control ) {
	return ( $control->manager->get_setting( 'myself_pro_theme_options[subscription_section_enable]' )->value() );
}

	
/**
 * Check if business_service section is enabled.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_business_service_section_enable( $control ) {
	return ( $control->manager->get_setting( 'myself_pro_theme_options[business_service_section_enable]' )->value() );
}

/**
 * Check if business_service section content type is page.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_business_service_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[business_service_content_type]' )->value();
	return myself_pro_is_business_service_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if business_service section content type is post.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_business_service_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[business_service_content_type]' )->value();
	return myself_pro_is_business_service_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if business_service section content type is category.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_business_service_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[business_service_content_type]' )->value();
	return myself_pro_is_business_service_section_enable( $control ) && ( 'category' == $content_type );
}


/*Team section*/

/**
 * Check if team section is enabled.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_team_section_enable( $control ) {
	return ( $control->manager->get_setting( 'myself_pro_theme_options[team_section_enable]' )->value() );
}

/**
 * Check if team section content type is post.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_team_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[team_content_type]' )->value();
	return myself_pro_is_team_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if team section content type is custom.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_team_section_content_custom_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[team_content_type]' )->value();
	return myself_pro_is_team_section_enable( $control ) && ( 'custom' == $content_type );
}

/**
 * Check if team section seperator.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_team_section_content_seperator_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[team_content_type]' )->value();
	return myself_pro_is_team_section_enable( $control ) && ( in_array( $content_type, array( 'page', 'post' ) ) );
}

/**
 * Check if team section content type is page.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_team_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[team_content_type]' )->value();
	return myself_pro_is_team_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if team section content type is category.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_team_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[team_content_type]' )->value();
	return myself_pro_is_team_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if helpus section is enabled.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_helpus_section_enable( $control ) {
	return ( $control->manager->get_setting( 'myself_pro_theme_options[helpus_section_enable]' )->value() );
}

/**
 * Check if helpus section content type is post.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_helpus_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[helpus_content_type]' )->value();
	return myself_pro_is_helpus_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if helpus section content type is page.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_helpus_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[helpus_content_type]' )->value();
	return myself_pro_is_helpus_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if helpus section content type is category.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_helpus_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[helpus_content_type]' )->value();
	return myself_pro_is_helpus_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if helpus section content type is recent.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_helpus_section_content_recent_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[helpus_content_type]' )->value();
	return myself_pro_is_helpus_section_enable( $control ) && ( 'recent' == $content_type );
}

/*course section*/

/**
 * Check if course section is enabled.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_course_section_enable( $control ) {
	return ( $control->manager->get_setting( 'myself_pro_theme_options[course_section_enable]' )->value() );
}

/**
 * Check if course section content type is category.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_course_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[course_content_type]' )->value();
	return myself_pro_is_course_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if course section content type is page.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_course_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[course_content_type]' )->value();
	return myself_pro_is_course_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if course section content type is post.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_course_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[course_content_type]' )->value();
	return myself_pro_is_course_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if photography section is enabled.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_photography_section_enable( $control ) {
	return ( $control->manager->get_setting( 'myself_pro_theme_options[photography_section_enable]' )->value() );
}

/**
 * Check if photography section content type is post.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_photography_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[photography_content_type]' )->value();
	return myself_pro_is_photography_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if photography section content type is page.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_photography_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[photography_content_type]' )->value();
	return myself_pro_is_photography_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if photography section content type is category.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_photography_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[photography_content_type]' )->value();
	return myself_pro_is_photography_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if photography section content type is recent.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_photography_section_content_recent_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[photography_content_type]' )->value();
	return myself_pro_is_photography_section_enable( $control ) && ( 'recent' == $content_type );
}

/**
 * Check if most_viewed section is enabled.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_most_viewed_section_enable( $control ) {
	return ( $control->manager->get_setting( 'myself_pro_theme_options[most_viewed_section_enable]' )->value() );
}

/**
 * Check if most_viewed section content type is post.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_most_viewed_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[most_viewed_content_type]' )->value();
	return myself_pro_is_most_viewed_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if most_viewed section content type is page.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_most_viewed_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[most_viewed_content_type]' )->value();
	return myself_pro_is_most_viewed_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if most_viewed section content type is category.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_most_viewed_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[most_viewed_content_type]' )->value();
	return myself_pro_is_most_viewed_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if most_viewed section content type is recent.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_most_viewed_section_content_recent_enable( $control ) {
	$content_type = $control->manager->get_setting( 'myself_pro_theme_options[most_viewed_content_type]' )->value();
	return myself_pro_is_most_viewed_section_enable( $control ) && ( 'recent' == $content_type );
}

/**
 * Check if instagram section is enabled.
 *
 * @since Myself Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function myself_pro_is_instagram_section_enable( $control ) {
	return ( $control->manager->get_setting( 'myself_pro_theme_options[instagram_section_enable]' )->value() );
}