<?php
/**
 * Myself Pro Customizer.
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function myself_pro_customize_register( $wp_customize ) {
	$options = myself_pro_get_theme_options();

	// Load custom control functions.
	require get_template_directory() . '/inc/customizer/custom-controls.php';

	// Load customize active callback functions.
	require get_template_directory() . '/inc/customizer/active-callback.php';

	// Load partial callback functions.
	require get_template_directory() . '/inc/customizer/partial.php';

	// Load validation callback functions.
	require get_template_directory() . '/inc/customizer/validation.php';

	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport  = 'postMessage';

	// Remove the core header textcolor control, as it shares the main text color.
	$wp_customize->remove_control( 'header_textcolor' );

	// Header title color setting and control.
	$wp_customize->add_setting( 'myself_pro_theme_options[header_title_color]', array(
		'default'           => $options['header_title_color'],
		'sanitize_callback' => 'sanitize_hex_color',
		'transport'			=> 'postMessage'
	) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'myself_pro_theme_options[header_title_color]', array(
		'priority'			=> 5,
		'label'             => esc_html__( 'Header Title Color', 'myself-pro' ),
		'section'           => 'colors',
	) ) );

	// Header tagline color setting and control.
	$wp_customize->add_setting( 'myself_pro_theme_options[header_tagline_color]', array(
		'default'           => $options['header_tagline_color'],
		'sanitize_callback' => 'sanitize_hex_color',
		'transport'			=> 'postMessage'
	) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'myself_pro_theme_options[header_tagline_color]', array(
		'priority'			=> 6,
		'label'             => esc_html__( 'Header Tagline Color', 'myself-pro' ),
		'section'           => 'colors',
	) ) );

	// Site identity extra options.
	$wp_customize->add_setting( 'myself_pro_theme_options[header_txt_logo_extra]', array(
		'default'           => $options['header_txt_logo_extra'],
		'sanitize_callback' => 'myself_pro_sanitize_select',
		'transport'			=> 'refresh'
	) );

	$wp_customize->add_control( 'myself_pro_theme_options[header_txt_logo_extra]', array(
		'priority'			=> 50,
		'type'				=> 'radio',
		'label'             => esc_html__( 'Site Identity Extra Options', 'myself-pro' ),
		'section'           => 'title_tagline',
		'choices'				=> array( 
			'hide-all'     => esc_html__( 'Hide All', 'myself-pro' ),
			'show-all'     => esc_html__( 'Show All', 'myself-pro' ),
			'title-only'   => esc_html__( 'Title Only', 'myself-pro' ),
			'tagline-only' => esc_html__( 'Tagline Only', 'myself-pro' ),
			'logo-title'   => esc_html__( 'Logo + Title', 'myself-pro' ),
			'logo-tagline' => esc_html__( 'Logo + Tagline', 'myself-pro' ),
			)
	) );

	$wp_customize->add_setting( 'myself_pro_theme_options[theme_version]', array(
		'default'           => $options['theme_version'],
		'sanitize_callback' => 'myself_pro_sanitize_select',
	) );

	$wp_customize->add_control( 'myself_pro_theme_options[theme_version]', array(
		'type'    => 'radio',
		'label'    => esc_html__( 'Theme Version', 'myself-pro' ),
		'choices'  => array(
            'lite-version'   => esc_html__( 'Lite Version', 'myself-pro' ),
            'dark-version'   => esc_html__( 'Dark Version', 'myself-pro' ),
		),
		'section'  => 'colors',
	) );

	/**
	 * Custom colors.
	 */
	$wp_customize->add_setting( 'myself_pro_theme_options[colorscheme]', array(
		'default'           => $options['colorscheme'],
		'sanitize_callback' => 'myself_pro_sanitize_select',
	) );

	$wp_customize->add_control( 'myself_pro_theme_options[colorscheme]', array(
		'type'    => 'radio',
		'label'    => esc_html__( 'Color Scheme', 'myself-pro' ),
		'choices'  => array(
            'default'   => esc_html__( 'Default', 'myself-pro' ),
            'blue'      => esc_html__( 'Blue', 'myself-pro' ),
            'green'     => esc_html__( 'Green', 'myself-pro' ),
            'red'       => esc_html__( 'Red', 'myself-pro' ),
            'yellow'    => esc_html__( 'Yellow', 'myself-pro' ),
            'custom'    => esc_html__( 'Custom', 'myself-pro' ),
		),
		'section'  => 'colors',
	) );

	$wp_customize->add_setting( 'myself_pro_theme_options[colorscheme_hue]', array(
		'default'           => $options['colorscheme_hue'],
		'sanitize_callback' => 'sanitize_hex_color', // The hue is stored as a positive integer.
	) );


	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'myself_pro_theme_options[colorscheme_hue]', array(
		'section'  => 'colors',
	) ) );

	// Add panel for common theme options
	$wp_customize->add_panel( 'myself_pro_theme_options_panel' , array(
	    'title'      => esc_html__( 'Theme Options','myself-pro' ),
	    'description'=> esc_html__( 'Myself Pro Theme Options.', 'myself-pro' ),
	    'priority'   => 150,
	) );

	// homepage sortable
	require get_template_directory() . '/inc/customizer/theme-options/sortable.php';

	// loader
	require get_template_directory() . '/inc/customizer/theme-options/loader.php';

	// breadcrumb
	require get_template_directory() . '/inc/customizer/theme-options/breadcrumb.php';

	// typography
	require get_template_directory() . '/inc/customizer/theme-options/typography.php';

	// load layout
	require get_template_directory() . '/inc/customizer/theme-options/layout.php';

	// load menu
	require get_template_directory() . '/inc/customizer/theme-options/menu.php';

	// load static homepage option
	require get_template_directory() . '/inc/customizer/theme-options/homepage-static.php';

	// load archive option
	require get_template_directory() . '/inc/customizer/theme-options/excerpt.php';

	// load archive option
	require get_template_directory() . '/inc/customizer/theme-options/archive.php';
	
	// load single post option
	require get_template_directory() . '/inc/customizer/theme-options/single-posts.php';

	// load pagination option
	require get_template_directory() . '/inc/customizer/theme-options/pagination.php';

	// load footer option
	require get_template_directory() . '/inc/customizer/theme-options/footer.php';

	// load reset option
	require get_template_directory() . '/inc/customizer/theme-options/reset.php';

	// Add panel for front page theme options.
	$wp_customize->add_panel( 'myself_pro_front_page_panel' , array(
	    'title'      => esc_html__( 'Front Page','myself-pro' ),
	    'description'=> esc_html__( 'Front Page Theme Options.', 'myself-pro' ),
	    'priority'   => 140,
	) );

	// load Home page option
	require get_template_directory() . '/inc/customizer/sections/home-layout.php';

	if($options['home_layout'] == 'default-design'){

		// load topbar option
		require get_template_directory() . '/inc/customizer/sections/topbar.php';

		// load introduction option
		require get_template_directory() . '/inc/customizer/sections/introduction.php';

		// load about option
		require get_template_directory() . '/inc/customizer/sections/about.php';

		// load my profile option
		require get_template_directory() . '/inc/customizer/sections/my-profile.php';

		// load service option
		require get_template_directory() . '/inc/customizer/sections/service.php';

		// load experience option
		require get_template_directory() . '/inc/customizer/sections/experience.php';

		// load portfolio option
		require get_template_directory() . '/inc/customizer/sections/portfolio.php';

		// load video option
		require get_template_directory() . '/inc/customizer/sections/video.php';

		// load clients option
		require get_template_directory() . '/inc/customizer/sections/clients.php';

		// load testimonial option
		require get_template_directory() . '/inc/customizer/sections/testimonial.php';

		// load skills option
		require get_template_directory() . '/inc/customizer/sections/skills.php';
		
		// load blog option
		require get_template_directory() . '/inc/customizer/sections/blog.php';

		// load contact option
		require get_template_directory() . '/inc/customizer/sections/contact.php';

		// load cta option
		require get_template_directory() . '/inc/customizer/sections/cta.php';

		// load instagram option
		require get_template_directory() . '/inc/customizer/sections/instagram.php';

	} elseif($options['home_layout'] == 'third-design'){

		// load topbar option
		require get_template_directory() . '/inc/customizer/sections/topbar.php';

		// load introduction option
		require get_template_directory() . '/inc/customizer/sections/introduction.php';
		
		// load about option
		require get_template_directory() . '/inc/customizer/sections/about.php';
		
		// load popular-destination option
		require get_template_directory() . '/inc/customizer/sections/popular-destination.php';
		
		// load counter option
		require get_template_directory() . '/inc/customizer/sections/counter.php';
		
		// load business service option
		require get_template_directory() . '/inc/customizer/sections/business-service.php';
		
		// load portfolio option
		require get_template_directory() . '/inc/customizer/sections/portfolio.php';
		
		// load Video option
		require get_template_directory() . '/inc/customizer/sections/video.php';
		
		// load popular-tours option
		require get_template_directory() . '/inc/customizer/sections/popular-tours.php';
		
		// load popular-tours option
		require get_template_directory() . '/inc/customizer/sections/subscription.php';
		
		// load blog option
		require get_template_directory() . '/inc/customizer/sections/blog.php';

	} elseif($options['home_layout'] == 'fourth-design'){

		// load topbar option
		require get_template_directory() . '/inc/customizer/sections/topbar.php';

		// load introduction option
		require get_template_directory() . '/inc/customizer/sections/introduction.php';
		
		// load about option
		require get_template_directory() . '/inc/customizer/sections/about.php';
		
		// load helpus option
		require get_template_directory() . '/inc/customizer/sections/helpus.php';
		
		// load business service option
		require get_template_directory() . '/inc/customizer/sections/business-service.php';
		
		// load portfolio option
		require get_template_directory() . '/inc/customizer/sections/portfolio.php';
		
		// load counter option
		require get_template_directory() . '/inc/customizer/sections/counter.php';
		
		// load testimonial option
		require get_template_directory() . '/inc/customizer/sections/testimonial.php';
		
		// load team option
		require get_template_directory() . '/inc/customizer/sections/team.php';

		// load subscription option
		require get_template_directory() . '/inc/customizer/sections/subscription.php';
		
		// load blog option
		require get_template_directory() . '/inc/customizer/sections/blog.php';

	} elseif($options['home_layout'] == 'fifth-design'){

		// load topbar option
		require get_template_directory() . '/inc/customizer/sections/topbar.php';

		// load introduction option
		require get_template_directory() . '/inc/customizer/sections/introduction.php';
		
		// load about option
		require get_template_directory() . '/inc/customizer/sections/about.php';
		
		// load business service option
		require get_template_directory() . '/inc/customizer/sections/business-service.php';
		
		// load counter option
		require get_template_directory() . '/inc/customizer/sections/counter.php';
		
		// load course option
		require get_template_directory() . '/inc/customizer/sections/course.php';
		
		// load subscription option
		require get_template_directory() . '/inc/customizer/sections/subscription.php';
		
		// load team option
		require get_template_directory() . '/inc/customizer/sections/team.php';
		
		// load testimonial option
		require get_template_directory() . '/inc/customizer/sections/testimonial.php';
		
		// load blog option
		require get_template_directory() . '/inc/customizer/sections/blog.php';

	} elseif($options['home_layout'] == 'sixth-design'){

		// load topbar option
		require get_template_directory() . '/inc/customizer/sections/topbar.php';

		// load introduction option
		require get_template_directory() . '/inc/customizer/sections/introduction.php';
		
		// load helpus option
		require get_template_directory() . '/inc/customizer/sections/helpus.php';
		
		// load course option
		require get_template_directory() . '/inc/customizer/sections/course.php';
		
		// load photography option
		require get_template_directory() . '/inc/customizer/sections/photography.php';
		
		// load most-viewed option
		require get_template_directory() . '/inc/customizer/sections/most-viewed.php';
		
		// load blog option
		require get_template_directory() . '/inc/customizer/sections/blog.php';

	} elseif($options['home_layout'] == 'seventh-design'){

		// load topbar option
		require get_template_directory() . '/inc/customizer/sections/topbar.php';

		// load introduction option
		require get_template_directory() . '/inc/customizer/sections/introduction.php';
		
		// load helpus option
		require get_template_directory() . '/inc/customizer/sections/helpus.php';
		
		// load photography option
		require get_template_directory() . '/inc/customizer/sections/photography.php';
		
		// load course option
		require get_template_directory() . '/inc/customizer/sections/course.php';
		
		// load blog option
		require get_template_directory() . '/inc/customizer/sections/blog.php';

	} elseif($options['home_layout'] == 'eight-design'){

		// load topbar option
		require get_template_directory() . '/inc/customizer/sections/topbar.php';

		// load introduction option
		require get_template_directory() . '/inc/customizer/sections/introduction.php';

		// load business-service option
		require get_template_directory() . '/inc/customizer/sections/business-service.php';
		
		// load about option
		require get_template_directory() . '/inc/customizer/sections/about.php';
		
		// load counter option
		require get_template_directory() . '/inc/customizer/sections/counter.php';
		
		// load team option
		require get_template_directory() . '/inc/customizer/sections/team.php';
		
		// load subscription option
		require get_template_directory() . '/inc/customizer/sections/subscription.php';
		
		// load blog option
		require get_template_directory() . '/inc/customizer/sections/blog.php';
	}

}
add_action( 'customize_register', 'myself_pro_customize_register' );

/*
 * Load customizer sanitization functions.
 */
require get_template_directory() . '/inc/customizer/sanitize.php';

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function myself_pro_customize_preview_js() {
	wp_enqueue_script( 'myself-pro-customizer', get_template_directory_uri() . '/assets/js/customizer.js', array( 'jquery','customize-preview'), '20151215', true );
}
add_action( 'customize_preview_init', 'myself_pro_customize_preview_js' );


/**
 * Load dynamic logic for the customizer controls area.
 */
function myself_pro_customize_control_js() {
	// fontawesome
	wp_enqueue_style( 'font-awesome-css', get_template_directory_uri() . '/assets/css/font-awesome' . myself_pro_min() . '.css' );
	
	// Choose from select jquery.
	wp_enqueue_style( 'chosen-css', get_template_directory_uri() . '/assets/css/chosen' . myself_pro_min() . '.css' );
	wp_enqueue_script( 'jquery-chosen', get_template_directory_uri() . '/assets/js/chosen.jquery' . myself_pro_min() . '.js', array( 'jquery' ), '1.4.2', true );

	// simple icon picker
	wp_enqueue_style( 'simple-iconpicker-css', get_template_directory_uri() . '/assets/css/simple-iconpicker' . myself_pro_min() . '.css' );
	wp_enqueue_script( 'jquery-simple-iconpicker', get_template_directory_uri() . '/assets/js/simple-iconpicker' . myself_pro_min() . '.js', array( 'jquery' ), '', true );

	wp_enqueue_style( 'myself-pro-customize-controls-css', get_template_directory_uri() . '/assets/css/customize-controls' . myself_pro_min() . '.css' );
	wp_enqueue_script( 'myself-pro-customize-controls', get_template_directory_uri() . '/assets/js/customize-controls'. myself_pro_min() . '.js', array( 'customize-controls', 'jquery' ), '1.0', true );

	$myself_pro_reset_data = array(
		'reset_message' => esc_html__( 'Refresh the customizer page after saving to view reset effects', 'myself-pro' )
	);
	// Send list of color variables as object to custom customizer js
	wp_localize_script( 'myself-pro-customize-controls', 'myself_pro_reset_data', $myself_pro_reset_data );
}
add_action( 'customize_controls_enqueue_scripts', 'myself_pro_customize_control_js' );

if ( !function_exists( 'myself_pro_reset_options' ) ) :
	/**
	 * Reset all options
	 *
	 * @since Myself Pro 1.0.0
	 *
	 * @param bool $checked Whether the reset is checked.
	 * @return bool Whether the reset is checked.
	 */
	function myself_pro_reset_options() {
		$options = myself_pro_get_theme_options();
		if ( true === $options['reset_options'] ) {
			// Reset custom theme options.
			set_theme_mod( 'myself_pro_theme_options', array() );
			// Reset custom header and backgrounds.
			remove_theme_mod( 'header_image' );
			remove_theme_mod( 'header_image_data' );
			remove_theme_mod( 'background_image' );
			remove_theme_mod( 'background_color' );
			remove_theme_mod( 'header_textcolor' );
	    }
	  	else {
		    return false;
	  	}
	}
endif;
add_action( 'customize_save_after', 'myself_pro_reset_options' );
