<?php
/**
 * Customizer default options
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 * @return array An array of default values
 */

function myself_pro_get_default_theme_options() {
	$theme_data = wp_get_theme();
	$myself_pro_default_options = array(
		// Color Options
		'header_title_color'			=> '#152944',
		'header_tagline_color'			=> '#152944',
		'header_txt_logo_extra'			=> 'show-all',
		'colorscheme_hue'				=> '#0bb3e4',
		'colorscheme'					=> 'default',
		'theme_version'					=> 'lite-version',
		'home_layout'					=> 'default-design',
		
		// typography Options
		'theme_typography' 				=> 'default',
		'body_theme_typography' 		=> 'default',
		
		// loader
		'loader_enable'         		=> false,
		'loader_icon'         			=> 'default',

		// breadcrumb
		'breadcrumb_enable'				=> true,
		'breadcrumb_separator'			=> '/',
		
		// layout 
		'site_layout'         			=> 'wide',
		'sidebar_position'         		=> 'right-sidebar',
		'post_sidebar_position' 		=> 'right-sidebar',
		'page_sidebar_position' 		=> 'right-sidebar',
		'menu_sticky'					=> true,

		// excerpt options
		'long_excerpt_length'           => 25,
		
		// pagination options
		'pagination_enable'         	=> true,
		'pagination_type'         		=> 'default',

		// footer options
		'copyright_text'           		=> sprintf( esc_html_x( 'Copyright &copy; %1$s %2$s. ', '1: Year, 2: Site Title with home URL', 'myself-pro' ), '[the-year]', '[site-link]' ) . esc_html__( 'All Rights Reserved | ', 'myself-pro' ) . esc_html( $theme_data->get( 'Name') ) . '&nbsp;' . esc_html__( 'by', 'myself-pro' ). '&nbsp;<a target="_blank" href="'. esc_url( $theme_data->get( 'AuthorURI' ) ) .'">'. esc_html( ucwords( $theme_data->get( 'Author' ) ) ) .'</a>',
		'scroll_top_visible'        	=> true,

		// reset options
		'reset_options'      			=> false,
		
		// homepage options
		'enable_frontpage_content' 		=> false,

		// homepage sections sortable
		'sortable' 						=> 'Introduction,About Me,My Profile,Services,Work Experience,Portfolio,Video,Clients,Testimonial,Skills,Blog,Contact,Call to Action,Instagram',

		// blog/archive options
		'your_latest_posts_title' 		=> esc_html__( 'Blogs', 'myself-pro' ),
		'hide_date' 					=> false,
		'hide_author'					=> false,
		'hide_category'					=> false,
		'archive_column'				=> 'col-2',

		// single post theme options
		'single_post_hide_date' 		=> false,
		'single_post_hide_category'		=> false,
		'single_post_hide_tags'			=> false,

		/* Front Page */

		// topbar
		'topbar_social_enable'			=> false,

		// Introduction
		'introduction_section_enable'	=> true,
		'introduction_count'	=> 1,
		'introduction_image_style'		=> 'small',
		'introduction_content_type'		=> 'page',
		'introduction_title'			=> esc_html__( 'Lucie Anderson', 'myself-pro' ),
		'introduction_description'		=> esc_html__( 'We shape and activate brands through insight, vision and execution.', 'myself-pro' ),
		'introduction_btn_title'		=> esc_html__( 'Hire Me', 'myself-pro' ),
		'introduction_alt_btn_title'	=> esc_html__( 'Profile', 'myself-pro' ),

		// About
		'about_section_enable'			=> true,
		'about_content_type'			=> 'page',
		'about_title'					=> esc_html__( 'Hello, I’m Freelancer Web Designer & Developer', 'myself-pro' ),
		'about_description'				=> esc_html__( 'Hello! I’m Lucie Anderson. Senior Web Designer & Developer. Experienced with all stages of the development cycle for dynamic web projects. Well-versed in numerous programming languages including JavaScript, SQL, and C. Stng background in project management and customer relations.', 'myself-pro' ),
		'about_btn_title'				=> esc_html__( 'Download CV', 'myself-pro' ),

		// My Profile
		'my_profile_section_enable'		=> true,
		'my_profile_content_type'		=> 'category',
		'my_profile_count'				=> 4,

		// service
		'service_section_enable'		=> true,
		'service_count'					=> 4,
		'service_title'					=> esc_html__( 'Experience my effective customer services', 'myself-pro' ),

		// Work Experience
		'experience_section_enable'		=> true,
		'experience_content_type'		=> 'page',
		'experience_count'				=> 5,
		'experience_column_type'		=> 4,
		'experience_title'				=> esc_html__( 'My working experiences tell more about me', 'myself-pro' ),
		'experience_description'		=> esc_html__( 'Hello! I&#39;m Lucie Anderson. Senior Web Designer &#38; Developer. Experienced with all stages of the development cycle for dynamic web projects. Well-versed in numerous programming languages including JavaScript, SQL, and C. Stng background in project management and customer relations.', 'myself-pro' ),

		// Portfolio
		'portfolio_section_enable'		=> true,
		'portfolio_content_type'		=> 'category',
		'portfolio_count'				=> 4,
		'portfolio_title'				=> esc_html__( 'Hello, I&#39;m Freelancer Web Designer &#38; Developer', 'myself-pro' ),
		'portfolio_btn_label'			=> esc_html__( 'View My All Work', 'myself-pro' ),
		'portfolio_description'			=> esc_html__( 'Hello! I&#39;m Lucie Anderson. Senior Web Designer &#38; Developer. Experienced with all stages of the development cycle for dynamic web projects. Well-versed in numerous programming languages including JavaScript, SQL, and C. Stng background in project management and customer relations.', 'myself-pro' ),

		// Video
		'video_section_enable'			=> true,
		'video_title'					=> esc_html__( 'Myself pro. Perfect for Bio-graphy Theme', 'myself-pro' ),
		'video_description'				=> esc_html__( 'Hello! I&#39;m Lucie Anderson. Senior Web Designer &#38; Developer. Experienced with all stages of the development cycle for dynamic web projects. Well-versed in numerous programming languages including JavaScript, SQL, and C. Stng background in project management and customer relations.', 'myself-pro' ),
		

		// Clients
		'clients_section_enable'		=> true,
		'clients_content_type'			=> 'page',
		'clients_count'					=> 6,
		'clients_title'					=> esc_html__( 'I build digital products, from idea to design. Happy clients!', 'myself-pro' ),
		'clients_description'			=> esc_html__( 'Hello! I&#39;m Lucie Anderson. Senior Web Designer &#38; Developer. Experienced with all stages of the development cycle for dynamic web projects. Well-versed in numerous programming languages including JavaScript, SQL, and C. Stng background in project management and customer relations.', 'myself-pro' ),
		'clients_btn_label'				=> esc_html__( 'Join Me Now', 'myself-pro' ),

		// testimonial
		'testimonial_section_enable'	=> true,
		'testimonial_content_type'		=> 'category',
		'testimonial_count'				=> 4,
		'testimonial_title'				=> esc_html__( 'Why Lucie Anderson is the best freelancer in town', 'myself-pro' ),

		// Skills
		'skills_section_enable'			=> true,
		'skills_content_type'			=> 'page',
		'skills_title'					=> esc_html__( 'Why choose me? Because skills matters!!', 'myself-pro' ),
		'skills_description'			=> esc_html__( 'Hello! I&#39;m Lucie Anderson. Senior Web Designer &#38; Developer. Experienced with all stages of the development cycle for dynamic web projects.', 'myself-pro' ),
		'skills_btn_title'				=> esc_html__( 'Hire Me Now', 'myself-pro' ),

		// blog
		'blog_section_enable'			=> true,
		'blog_content_type'				=> 'recent',
		'blog_count'					=> 4,
		'blog_column'					=> 'col-4',
		'blog_title'					=> esc_html__( 'From The Blog', 'myself-pro' ),
		'blog_btn_title'				=> esc_html__( 'View All', 'myself-pro' ),
		'blog_description'				=> esc_html__( 'Quisque non tellus orci ac auctor augue. Sapien pellentesque habitant morbi tristique senectus et netus et. Sed euismod nisi porta lorem mollis.', 'myself-pro' ),
		
		
		// contact
		'contact_section_enable'		=> true,
		'contact_title'					=> esc_html__( 'View All', 'myself-pro' ),

		// call to action
		'cta_section_enable'			=> true,
		'cta_content_type'				=> 'page',
		'cta_title'						=> esc_html__( 'Ready to get started? It&#39;s fast, free and very easy!', 'myself-pro' ),
		'cta_btn_title'					=> esc_html__( 'Get a free Estimate', 'myself-pro' ),
		
		
		// popular destination
		'popular_destination_section_enable'	=> true,
		'popular_destination_content_type'		=> 'category',
		'popular_destination_count'				=> 5,
		'popular_destination_title'				=> esc_html__( 'Popular Destinations', 'myself-pro' ),
		'popular_destination_description'		=> esc_html__( 'Our Popular Destinations', 'myself-pro' ),
		'popular_destination_read_more'			=> esc_html__( 'Read More', 'myself-pro' ),
		
		// counter
		'counter_section_enable'		=> true,
		'counter_count'					=> 4,
		
		// popular tours
		'popular_tours_section_enable'		=> true,
		'popular_tours_content_type'		=> 'category',
		'popular_tours_count'				=> 3,
		'popular_tours_title'				=> esc_html__( 'Popular Tours', 'myself-pro' ),
		
		
		//subscription
		'subscription_section_enable'			=> false,
		'subscription_sub_title'				=> esc_html__( 'Newsletter', 'myself-pro' ),
		'subscription_title'					=> esc_html__( 'Get In Touch', 'myself-pro' ),
		'subscription_btn_title'				=> esc_html__( 'Subscribe Now', 'myself-pro' ),
		
		//business service
		'business_service_subtitle'				=> esc_html__( 'Dignissim enim sit amet venenatis urna cursus eget nunc. Diam donec adipiscing tristique risus nec feugiat in. Aliquet nec ullamcorper sit amet risus.', 'myself-pro' ),
		'business_service_title'				=> esc_html__( 'Our College Features', 'myself-pro' ),
		'business_service_section_enable'		=> true,
		'business_service_count'				=> 3,
		'business_service_posts_column'			=> 3,
		'business_service_content_type'			=> 'category',
		
		// team
		'team_section_enable'		=> true,
		'team_content_type'			=> 'category',
		'team_count'				=> 4,
		'team_title'				=> esc_html__( 'Our Volunteer.', 'myself-pro' ),
		'team_sub_title'			=> esc_html__( 'Quisque non tellus orci ac auctor augue. Sapien pellentesque habitant morbi tristique senectus et netus et. Sed euismod nisi porta lorem mollis.', 'myself-pro' ),
		'team_column'				=> 'col-4',
		
		// helpus_
		'helpus_section_enable'			=> true,
		'helpus_content_type'			=> 'category',
		'helpus_count'					=> 3,
		'helpus_column'					=> 'col-3',
		'helpus_title'					=> esc_html__( 'Latest campaign', 'myself-pro' ),
		'helpus_btn_title'				=> esc_html__( 'Donate Now', 'myself-pro' ),
		
		// Course
		'course_title'					=> esc_html__( 'TOP COURSES', 'myself-pro' ),
		'course_subtitle'				=> esc_html__( 'Our Featured Course', 'myself-pro' ),
		'course_section_enable'			=> true,
		'course_column'					=> 'col-3',
		'course_content_type'			=> 'category',
		'course_count'					=> 3,
		
		// photography
		'photography_section_enable'		=> true,
		'photography_content_type'			=> 'recent',
		'photography_btn_title'				=> esc_html__( 'Read More', 'myself-pro' ),
		'photography_count'					=> 4,
		'photography_title'					=> esc_html__( 'Photography', 'myself-pro' ),

		// most_viewed
		'most_viewed_section_enable'		=> true,
		'most_viewed_content_type'			=> 'recent',
		'most_viewed_count'					=> 4,
		'most_viewed_title'					=> esc_html__( 'Most Viewed News', 'myself-pro' ),

		// instagram
		'instagram_section_enable'		=> false,
		
	);

	$output = apply_filters( 'myself_pro_default_theme_options', $myself_pro_default_options );
	
	// Sort array in ascending order, according to the key:
	if ( ! empty( $output ) ) {
		ksort( $output );
	}
	
	return $output;
}