<?php
/**
 * About Section options
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */

// Add About section
$wp_customize->add_section( 'myself_pro_about_section', array(
	'title'             => esc_html__( 'About Me','myself-pro' ),
	'description'       => esc_html__( 'About Section options.', 'myself-pro' ),
	'panel'             => 'myself_pro_front_page_panel',
) );

// About content enable control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[about_section_enable]', array(
	'default'			=> 	$options['about_section_enable'],
	'sanitize_callback' => 'myself_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Myself_Pro_Switch_Control( $wp_customize, 'myself_pro_theme_options[about_section_enable]', array(
	'label'             => esc_html__( 'About Section Enable', 'myself-pro' ),
	'section'           => 'myself_pro_about_section',
	'on_off_label' 		=> myself_pro_switch_options(),
) ) );

// About content type control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[about_content_type]', array(
	'default'          	=> $options['about_content_type'],
	'sanitize_callback' => 'myself_pro_sanitize_select',
) );

$wp_customize->add_control( 'myself_pro_theme_options[about_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'myself-pro' ),
	'section'           => 'myself_pro_about_section',
	'type'				=> 'select',
	'active_callback' 	=> 'myself_pro_is_about_section_enable',
	'choices'			=> array( 
		'page' 		=> esc_html__( 'Page', 'myself-pro' ),
		'post' 		=> esc_html__( 'Post', 'myself-pro' ),
		'custom' 	=> esc_html__( 'Custom', 'myself-pro' ),
	),
) );

// about pages drop down chooser control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[about_content_page]', array(
	'sanitize_callback' => 'myself_pro_sanitize_page',
) );

$wp_customize->add_control( new Myself_Pro_Dropdown_Chooser( $wp_customize, 'myself_pro_theme_options[about_content_page]', array(
	'label'             => esc_html__( 'Select Page', 'myself-pro' ),
	'section'           => 'myself_pro_about_section',
	'choices'			=> myself_pro_page_choices(),
	'active_callback'	=> 'myself_pro_is_about_section_content_page_enable',
) ) );

// about posts drop down chooser control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[about_content_post]', array(
	'sanitize_callback' => 'myself_pro_sanitize_page',
) );

$wp_customize->add_control( new Myself_Pro_Dropdown_Chooser( $wp_customize, 'myself_pro_theme_options[about_content_post]', array(
	'label'             => esc_html__( 'Select Post', 'myself-pro' ),
	'section'           => 'myself_pro_about_section',
	'choices'			=> myself_pro_post_choices(),
	'active_callback'	=> 'myself_pro_is_about_section_content_post_enable',
) ) );

// about title setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[about_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['about_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'myself_pro_theme_options[about_title]', array(
	'label'           	=> esc_html__( 'Title', 'myself-pro' ),
	'section'        	=> 'myself_pro_about_section',
	'active_callback' 	=> 'myself_pro_is_about_section_content_custom_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[about_title]', array(
		'selector'            => '#about-me .entry-container .section-header h2.section-title',
		'settings'            => 'myself_pro_theme_options[about_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'myself_pro_about_title_partial',
    ) );
}

// about description setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[about_description]', array(
	'sanitize_callback' => 'wp_kses_post',
	'default'			=> $options['about_description'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'myself_pro_theme_options[about_description]', array(
	'label'           	=> esc_html__( 'Description', 'myself-pro' ),
	'section'        	=> 'myself_pro_about_section',
	'active_callback' 	=> 'myself_pro_is_about_section_content_custom_enable',
	'type'				=> 'textarea',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[about_description]', array(
		'selector'            => '#about-me .section-content .entry-content p',
		'settings'            => 'myself_pro_theme_options[about_description]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'myself_pro_about_description_partial',
    ) );
}

// about image setting and control.
$wp_customize->add_setting( 'myself_pro_theme_options[about_image]', array(
	'sanitize_callback' => 'myself_pro_sanitize_image'
) );

$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'myself_pro_theme_options[about_image]',
		array(
		'label'       		=> esc_html__( 'Image', 'myself-pro' ),
		'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'myself-pro' ), 1280, 854 ),
		'section'     		=> 'myself_pro_about_section',
		'active_callback'	=> 'myself_pro_is_about_section_content_custom_enable',
) ) );

// about btn title setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[about_btn_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['about_btn_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'myself_pro_theme_options[about_btn_title]', array(
	'label'           	=> esc_html__( 'Button Label', 'myself-pro' ),
	'section'        	=> 'myself_pro_about_section',
	'active_callback' 	=> 'myself_pro_is_about_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[about_btn_title]', array(
		'selector'            => '#about-me a.btn',
		'settings'            => 'myself_pro_theme_options[about_btn_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'myself_pro_about_btn_title_partial',
    ) );
}

// about btn link setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[about_btn_link]', array(
	'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( 'myself_pro_theme_options[about_btn_link]', array(
	'label'           	=> esc_html__( 'Button Link', 'myself-pro' ),
	'section'        	=> 'myself_pro_about_section',
	'active_callback' 	=> 'myself_pro_is_about_section_content_custom_enable',
	'type'				=> 'url',
) );