<?php
/**
 * Service Section options
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */

// Add Service section
$wp_customize->add_section( 'myself_pro_business_service_section', array(
	'title'             => esc_html__( 'Services','myself-pro' ),
	'description'       => esc_html__( 'Services Section options.', 'myself-pro' ),
	'panel'             => 'myself_pro_front_page_panel',
) );

// Service content enable control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[business_service_section_enable]', array(
	'default'			=> 	$options['business_service_section_enable'],
	'sanitize_callback' => 'myself_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Myself_Pro_Switch_Control( $wp_customize, 'myself_pro_theme_options[business_service_section_enable]', array(
	'label'             => esc_html__( 'Service Section Enable', 'myself-pro' ),
	'section'           => 'myself_pro_business_service_section',
	'on_off_label' 		=> myself_pro_switch_options(),
) ) );

if($options['home_layout'] == 'fifth-design'){

	// service title setting and control
	$wp_customize->add_setting( 'myself_pro_theme_options[business_service_title]', array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'			=> $options['business_service_title'],
		'transport'			=> 'postMessage',
	) );
	
	$wp_customize->add_control( 'myself_pro_theme_options[business_service_title]', array(
		'label'           	=> esc_html__( 'Title', 'myself-pro' ),
		'section'        	=> 'myself_pro_business_service_section',
		'active_callback' 	=> 'myself_pro_is_business_service_section_enable',
		'type'				=> 'text',
	) );
	
	// Abort if selective refresh is not available.
	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[business_service_title]', array(
			'selector'            => '#business-services h2.business-section-title',
			'settings'            => 'myself_pro_theme_options[business_service_title]',
			'container_inclusive' => false,
			'fallback_refresh'    => true,
			'render_callback'     => 'myself_pro_business_service_title_partial',
		) );
	}
	
	// service subtitle setting and control
	$wp_customize->add_setting( 'myself_pro_theme_options[business_service_subtitle]', array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'			=> $options['business_service_subtitle'],
		'transport'			=> 'postMessage',
	) );
	
	$wp_customize->add_control( 'myself_pro_theme_options[business_service_subtitle]', array(
		'label'           	=> esc_html__( 'Sub Title', 'myself-pro' ),
		'section'        	=> 'myself_pro_business_service_section',
		'active_callback' 	=> 'myself_pro_is_business_service_section_enable',
		'type'				=> 'textarea',
	) );
	
	// Abort if selective refresh is not available.
	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[business_service_subtitle]', array(
			'selector'            => '#business-services p.business-section-subtitle',
			'settings'            => 'myself_pro_theme_options[business_service_subtitle]',
			'container_inclusive' => false,
			'fallback_refresh'    => true,
			'render_callback'     => 'myself_pro_business_service_subtitle_partial',
		) );
	}
}

// Must Read Posts column control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[business_service_posts_column]', array(
	'default'          	=> $options['business_service_posts_column'],
	'sanitize_callback' => 'myself_pro_sanitize_select',
) );

$wp_customize->add_control( 'myself_pro_theme_options[business_service_posts_column]', array(
	'label'             => esc_html__( 'Column Number', 'myself-pro' ),
	'section'           => 'myself_pro_business_service_section',
	'type'				=> 'select',
	'active_callback' 	=> 'myself_pro_is_business_service_section_enable',
	'choices'			=> array( 
		3 		=> esc_html__( 'Three Column', 'myself-pro' ),
		4 		=> esc_html__( 'Four Column', 'myself-pro' ),
	),
) );

// Event social icons number control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[business_service_count]', array(
	'default'          	=> $options['business_service_count'],
	'sanitize_callback' => 'myself_pro_sanitize_number_range',
	'validate_callback' => 'myself_pro_validate_business_service_count',
	'transport'			=> 'refresh'
) );

$wp_customize->add_control( 'myself_pro_theme_options[business_service_count]', array(
	'label'             => esc_html__( 'Number of Services', 'myself-pro' ),
	'description'       => esc_html__( 'Note: Min 3 & Max 12. Please input the valid number and save. Then refresh the page to see the change.', 'myself-pro' ),
	'section'           => 'myself_pro_business_service_section',
	'active_callback'   => 'myself_pro_is_business_service_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 3,
		'max'	=> 12,
		'style' => 'width: 100px;'
		),
) );


// Service content type control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[business_service_content_type]', array(
	'default'          	=> $options['business_service_content_type'],
	'sanitize_callback' => 'myself_pro_sanitize_select',
) );

$wp_customize->add_control( 'myself_pro_theme_options[business_service_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'myself-pro' ),
	'section'           => 'myself_pro_business_service_section',
	'type'				=> 'select',
	'active_callback' 	=> 'myself_pro_is_business_service_section_enable',
	'choices'			=> array( 
		'page' 		=> esc_html__( 'Page', 'myself-pro' ),
		'post' 		=> esc_html__( 'Post', 'myself-pro' ),
		'category' 	=> esc_html__( 'Category', 'myself-pro' ),
	),
) );


for ( $i = 1; $i <= $options['business_service_count']; $i++ ) :

	// service note control and setting
	$wp_customize->add_setting( 'myself_pro_theme_options[business_service_content_icon_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( new Myself_Pro_Icon_Picker( $wp_customize, 'myself_pro_theme_options[business_service_content_icon_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Icon %d', 'myself-pro' ), $i ),
		'section'           => 'myself_pro_business_service_section',
		'active_callback'	=> 'myself_pro_is_business_service_section_enable',
	) ) );


	// service pages drop down chooser control and setting
	$wp_customize->add_setting( 'myself_pro_theme_options[business_service_content_page_' . $i . ']', array(
		'sanitize_callback' => 'myself_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Myself_Pro_Dropdown_Chooser( $wp_customize, 'myself_pro_theme_options[business_service_content_page_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Page %d', 'myself-pro' ), $i ),
		'section'           => 'myself_pro_business_service_section',
		'choices'			=> myself_pro_page_choices(),
		'active_callback'	=> 'myself_pro_is_business_service_section_content_page_enable',
	) ) );

	// service posts drop down chooser control and setting
	$wp_customize->add_setting( 'myself_pro_theme_options[business_service_content_post_' . $i . ']', array(
		'sanitize_callback' => 'myself_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Myself_Pro_Dropdown_Chooser( $wp_customize, 'myself_pro_theme_options[business_service_content_post_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Post %d', 'myself-pro' ), $i ),
		'section'           => 'myself_pro_business_service_section',
		'choices'			=> myself_pro_post_choices(),
		'active_callback'	=> 'myself_pro_is_business_service_section_content_post_enable',
	) ) );
	
endfor;

// Add dropdown category setting and control.
$wp_customize->add_setting(  'myself_pro_theme_options[business_service_content_category]', array(
	'sanitize_callback' => 'myself_pro_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Myself_Pro_Dropdown_Taxonomies_Control( $wp_customize,'myself_pro_theme_options[business_service_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'myself-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'myself-pro' ),
	'section'           => 'myself_pro_business_service_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'myself_pro_is_business_service_section_content_category_enable'
) ) );
