<?php
/**
 * Clients Section options
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */

// Add Clients section
$wp_customize->add_section( 'myself_pro_clients_section', array(
	'title'             => esc_html__( 'Clients','myself-pro' ),
	'description'       => esc_html__( 'Clients Section options.', 'myself-pro' ),
	'panel'             => 'myself_pro_front_page_panel',
) );

// Clients content enable control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[clients_section_enable]', array(
	'default'			=> 	$options['clients_section_enable'],
	'sanitize_callback' => 'myself_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Myself_Pro_Switch_Control( $wp_customize, 'myself_pro_theme_options[clients_section_enable]', array(
	'label'             => esc_html__( 'Clients Section Enable', 'myself-pro' ),
	'section'           => 'myself_pro_clients_section',
	'on_off_label' 		=> myself_pro_switch_options(),
) ) );

// Clients title setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[clients_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['clients_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'myself_pro_theme_options[clients_title]', array(
	'label'           	=> esc_html__( 'Clients Title', 'myself-pro' ),
	'section'        	=> 'myself_pro_clients_section',
	'active_callback' 	=> 'myself_pro_is_clients_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[clients_title]', array(
		'selector'            => '#my-clients .section-header h2.section-title',
		'settings'            => 'myself_pro_theme_options[clients_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'myself_pro_clients_title_partial',
    ) );
}

// Clients description setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[clients_description]', array(
	'sanitize_callback' => 'wp_kses_post',
	'default'			=> $options['clients_description'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'myself_pro_theme_options[clients_description]', array(
	'label'           	=> esc_html__( 'Clients Description', 'myself-pro' ),
	'section'        	=> 'myself_pro_clients_section',
	'active_callback' 	=> 'myself_pro_is_clients_section_enable',
	'type'				=> 'textarea',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[clients_description]', array(
		'selector'            => '#my-clients .section-content p',
		'settings'            => 'myself_pro_theme_options[clients_description]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'myself_pro_clients_description_partial',
    ) );
}

// Clients btn label setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[clients_btn_label]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['clients_btn_label'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'myself_pro_theme_options[clients_btn_label]', array(
	'label'           	=> esc_html__( 'Clients Btn Label', 'myself-pro' ),
	'section'        	=> 'myself_pro_clients_section',
	'active_callback' 	=> 'myself_pro_is_clients_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[clients_btn_label]', array(
		'selector'            => '#my-clients .section-content .read-more a.btn',
		'settings'            => 'myself_pro_theme_options[clients_btn_label]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'myself_pro_clients_btn_label_partial',
    ) );
}

// Clients btn url setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[clients_btn_url]', array(
	'sanitize_callback' => 'esc_url_raw',
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'myself_pro_theme_options[clients_btn_url]', array(
	'label'           	=> esc_html__( 'Clients Btn Url', 'myself-pro' ),
	'section'        	=> 'myself_pro_clients_section',
	'active_callback' 	=> 'myself_pro_is_clients_section_enable',
	'type'				=> 'url',
) );

// Event social icons number control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[clients_count]', array(
	'default'          	=> $options['clients_count'],
	'sanitize_callback' => 'myself_pro_sanitize_number_range',
	'validate_callback' => 'myself_pro_validate_clients_count',
) );

$wp_customize->add_control( 'myself_pro_theme_options[clients_count]', array(
	'label'             => esc_html__( 'Number of Posts', 'myself-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 8. Please input the valid number and save. Then refresh the page to see the change.', 'myself-pro' ),
	'section'           => 'myself_pro_clients_section',
	'active_callback'   => 'myself_pro_is_clients_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'max'	=> 8,
		'style' => 'width: 100px;'
		),
) );

// Clients image setting and control.
$wp_customize->add_setting( 'myself_pro_theme_options[clients_separator_image]', array(
	'sanitize_callback' => 'myself_pro_sanitize_image',
) );

$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'myself_pro_theme_options[clients_separator_image]',
		array(
		'label'       		=> esc_html__( 'Background Image', 'myself-pro' ),
		'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'myself-pro' ), 850, 800 ),
		'section'     		=> 'myself_pro_clients_section',
		'active_callback'	=> 'myself_pro_is_clients_section_enable',
) ) );

// Clients content type control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[clients_content_type]', array(
	'default'          	=> $options['clients_content_type'],
	'sanitize_callback' => 'myself_pro_sanitize_select',
) );

$wp_customize->add_control( 'myself_pro_theme_options[clients_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'myself-pro' ),
	'section'           => 'myself_pro_clients_section',
	'type'				=> 'select',
	'active_callback' 	=> 'myself_pro_is_clients_section_enable',
	'choices'			=> array( 
		'page' 		=> esc_html__( 'Page', 'myself-pro' ),
		'post' 		=> esc_html__( 'Post', 'myself-pro' ),
		'category' 	=> esc_html__( 'Category', 'myself-pro' ),
		'custom' 	=> esc_html__( 'Custom', 'myself-pro' ),
	),
) );

for ( $i = 1; $i <= $options['clients_count']; $i++ ) :
	// clients pages drop down chooser control and setting
	$wp_customize->add_setting( 'myself_pro_theme_options[clients_content_page_' . $i . ']', array(
		'sanitize_callback' => 'myself_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Myself_Pro_Dropdown_Chooser( $wp_customize, 'myself_pro_theme_options[clients_content_page_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Page %d', 'myself-pro' ), $i ),
		'section'           => 'myself_pro_clients_section',
		'choices'			=> myself_pro_page_choices(),
		'active_callback'	=> 'myself_pro_is_clients_section_content_page_enable',
	) ) );

	// clients posts drop down chooser control and setting
	$wp_customize->add_setting( 'myself_pro_theme_options[clients_content_post_' . $i . ']', array(
		'sanitize_callback' => 'myself_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Myself_Pro_Dropdown_Chooser( $wp_customize, 'myself_pro_theme_options[clients_content_post_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Post %d', 'myself-pro' ), $i ),
		'section'           => 'myself_pro_clients_section',
		'choices'			=> myself_pro_post_choices(),
		'active_callback'	=> 'myself_pro_is_clients_section_content_post_enable',
	) ) );

	// Clients title setting and control
	$wp_customize->add_setting( 'myself_pro_theme_options[clients_title_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'myself_pro_theme_options[clients_title_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Clients Title %d', 'myself-pro' ), $i),
		'section'        	=> 'myself_pro_clients_section',
		'active_callback' 	=> 'myself_pro_is_clients_section_content_custom_enable',
		'type'				=> 'text',
	) );

	// Clients description setting and control
	$wp_customize->add_setting( 'myself_pro_theme_options[clients_description_' . $i . ']', array(
		'sanitize_callback' => 'wp_kses_post',
	) );

	$wp_customize->add_control( 'myself_pro_theme_options[clients_description_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Clients Description %d', 'myself-pro' ), $i),
		'section'        	=> 'myself_pro_clients_section',
		'active_callback' 	=> 'myself_pro_is_clients_section_content_custom_enable',
		'type'				=> 'textarea',
	) );

	// Clients url setting and control
	$wp_customize->add_setting( 'myself_pro_theme_options[clients_url_' . $i . ']', array(
		'sanitize_callback' => 'esc_url_raw',
	) );

	$wp_customize->add_control( 'myself_pro_theme_options[clients_url_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Clients Url %d', 'myself-pro' ), $i),
		'section'        	=> 'myself_pro_clients_section',
		'active_callback' 	=> 'myself_pro_is_clients_section_content_custom_enable',
		'type'				=> 'url',
	) );

	// Clients image setting and control.
	$wp_customize->add_setting( 'myself_pro_theme_options[clients_image_' . $i . ']', array(
		'sanitize_callback' => 'myself_pro_sanitize_image',
	) );

	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'myself_pro_theme_options[clients_image_' . $i . ']',
			array(
			'label'       		=> sprintf( esc_html__( 'Image %d', 'myself-pro' ), $i),
			'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'myself-pro' ), 150, 150 ),
			'section'     		=> 'myself_pro_clients_section',
			'active_callback'	=> 'myself_pro_is_clients_section_content_custom_enable',
	) ) );

	// clients hr setting and control
	$wp_customize->add_setting( 'myself_pro_theme_options[clients_hr_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new Myself_Pro_Customize_Horizontal_Line( $wp_customize, 'myself_pro_theme_options[clients_hr_'. $i .']',
		array(
			'section'         => 'myself_pro_clients_section',
			'active_callback' => 'myself_pro_is_clients_section_content_custom_enable',
			'type'			  => 'hr'
	) ) );

endfor;

// Add dropdown category setting and control.
$wp_customize->add_setting(  'myself_pro_theme_options[clients_content_category]', array(
	'sanitize_callback' => 'myself_pro_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Myself_Pro_Dropdown_Taxonomies_Control( $wp_customize,'myself_pro_theme_options[clients_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'myself-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'myself-pro' ),
	'section'           => 'myself_pro_clients_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'myself_pro_is_clients_section_content_category_enable'
) ) );