<?php
/**
 * Contact Section options
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */

// Add Contact section
$wp_customize->add_section( 'myself_pro_contact_section', array(
	'title'             => esc_html__( 'Contact','myself-pro' ),
	'description'       => esc_html__( 'Contact Section options.', 'myself-pro' ),
	'panel'             => 'myself_pro_front_page_panel',
) );

// Contact content enable control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[contact_section_enable]', array(
	'default'			=> 	$options['contact_section_enable'],
	'sanitize_callback' => 'myself_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Myself_Pro_Switch_Control( $wp_customize, 'myself_pro_theme_options[contact_section_enable]', array(
	'label'             => esc_html__( 'Contact Section Enable', 'myself-pro' ),
	'section'           => 'myself_pro_contact_section',
	'on_off_label' 		=> myself_pro_switch_options(),
) ) );

// contact title setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[contact_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['contact_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'myself_pro_theme_options[contact_title]', array(
	'label'           	=> esc_html__( 'Title', 'myself-pro' ),
	'section'        	=> 'myself_pro_contact_section',
	'active_callback' 	=> 'myself_pro_is_contact_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[contact_title]', array(
		'selector'            => '#contact-me .section-header h2.section-title',
		'settings'            => 'myself_pro_theme_options[contact_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'myself_pro_contact_title_partial',
    ) );
}

// contact image setting and control.
$wp_customize->add_setting( 'myself_pro_theme_options[contact_image]', array(
	'sanitize_callback' => 'myself_pro_sanitize_image'
) );

$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'myself_pro_theme_options[contact_image]',
		array(
		'label'       		=> esc_html__( 'Background Image', 'myself-pro' ),
		'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'myself-pro' ), 1920, 1200 ),
		'section'     		=> 'myself_pro_contact_section',
		'active_callback'	=> 'myself_pro_is_contact_section_enable',
) ) );

// contact description setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[contact_address]', array(
	'sanitize_callback' => 'wp_kses_post',
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'myself_pro_theme_options[contact_address]', array(
	'label'           	=> esc_html__( 'Address', 'myself-pro' ),
	'section'        	=> 'myself_pro_contact_section',
	'active_callback' 	=> 'myself_pro_is_contact_section_enable',
	'type'				=> 'textarea',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[contact_address]', array(
		'selector'            => '#contact-me .section-content p',
		'settings'            => 'myself_pro_theme_options[contact_address]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'myself_pro_contact_address_partial',
    ) );
}

// contact phone setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[contact_phone]', array(
	'sanitize_callback' => 'sanitize_text_field'
) );

$wp_customize->add_control( new Myself_Pro_Multi_Input_Custom_Control( $wp_customize, 'myself_pro_theme_options[contact_phone]',
	array(
		'label'       	  => esc_html__( 'Phone No', 'myself-pro' ),
		'button_text'     => esc_html__( 'Add More', 'myself-pro' ),
		'section'         => 'myself_pro_contact_section',
		'type'			  => 'multi-input',
		'active_callback' 	=> 'myself_pro_is_contact_section_enable',
) ) );

// contact email id setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[contact_email]', array(
	'sanitize_callback' => 'myself_pro_sanitize_email'
) );

$wp_customize->add_control( new Myself_Pro_Multi_Input_Custom_Control( $wp_customize, 'myself_pro_theme_options[contact_email]',
	array(
		'label'       	  => esc_html__( 'Email ID', 'myself-pro' ),
		'button_text'     => esc_html__( 'Add More', 'myself-pro' ),
		'section'         => 'myself_pro_contact_section',
		'type'			  => 'multi-input',
		'active_callback' 	=> 'myself_pro_is_contact_section_enable',
) ) );

// contact social links setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[contact_social]', array(
	'sanitize_callback' => 'myself_pro_sanitize_links'
) );

$wp_customize->add_control( new Myself_Pro_Multi_Input_Custom_Control( $wp_customize, 'myself_pro_theme_options[contact_social]',
	array(
		'label'       	  => esc_html__( 'Social Links', 'myself-pro' ),
		'button_text'     => esc_html__( 'Add More', 'myself-pro' ),
		'section'         => 'myself_pro_contact_section',
		'type'			  => 'multi-input',
		'active_callback' 	=> 'myself_pro_is_contact_section_enable',
) ) );

// contact bar shortcode setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[contact_shortcode]', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'myself_pro_theme_options[contact_shortcode]', array(
	'label'           	=> esc_html__( 'Shortcode', 'myself-pro' ),
	'description'       => esc_html__( 'Note: Please install Contact Form 7 and use the contact form shortcode.', 'myself-pro' ),
	'section'        	=> 'myself_pro_contact_section',
	'active_callback' 	=> 'myself_pro_is_contact_section_enable',
	'type'				=> 'text',
) );
