<?php
/**
 * Counter Section options
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */

// Add Counter section
$wp_customize->add_section( 'myself_pro_counter_section', array(
	'title'             => esc_html__( 'Counters','myself-pro' ),
	'description'       => esc_html__( 'Counters Section options.', 'myself-pro' ),
	'panel'             => 'myself_pro_front_page_panel',
) );

// Counter content enable control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[counter_section_enable]', array(
	'default'			=> 	$options['counter_section_enable'],
	'sanitize_callback' => 'myself_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Myself_Pro_Switch_Control( $wp_customize, 'myself_pro_theme_options[counter_section_enable]', array(
	'label'             => esc_html__( 'Counter Section Enable', 'myself-pro' ),
	'section'           => 'myself_pro_counter_section',
	'on_off_label' 		=> myself_pro_switch_options(),
) ) );

$wp_customize->add_setting( 'myself_pro_theme_options[counter_image]', array(
	'sanitize_callback' => 'myself_pro_sanitize_image',
) );

$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'myself_pro_theme_options[counter_image]',
		array(
		'label'       		=> esc_html__( 'Image', 'myself-pro' ),
		'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'myself-pro' ), 1350, 385 ),
		'section'     		=> 'myself_pro_counter_section',
		'active_callback'	=> 'myself_pro_is_counter_section_enable',
) ) );

// counter number control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[counter_count]', array(
	'default'          	=> $options['counter_count'],
	'sanitize_callback' => 'myself_pro_sanitize_number_range',
	'validate_callback' => 'myself_pro_validate_counter_count',
) );

$wp_customize->add_control( 'myself_pro_theme_options[counter_count]', array(
	'label'             => esc_html__( 'Number of Counters', 'myself-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 12. Please input the valid number and save. Then refresh the page to see the change.', 'myself-pro' ),
	'section'           => 'myself_pro_counter_section',
	'active_callback'   => 'myself_pro_is_counter_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'max'	=> 12,
		'style' => 'width: 100px;'
		),
) );

for ( $i = 1; $i <= $options['counter_count']; $i++ ) :

	// counter note control and setting
	$wp_customize->add_setting( 'myself_pro_theme_options[counter_content_icon_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( new Myself_Pro_Icon_Picker( $wp_customize, 'myself_pro_theme_options[counter_content_icon_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Icon %d', 'myself-pro' ), $i ),
		'section'           => 'myself_pro_counter_section',
		'active_callback'	=> 'myself_pro_is_counter_section_enable',
	) ) );

	// counter title setting and control
	$wp_customize->add_setting( 'myself_pro_theme_options[counter_title_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'myself_pro_theme_options[counter_title_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Counter Title %d', 'myself-pro' ), $i ),
		'section'        	=> 'myself_pro_counter_section',
		'active_callback' 	=> 'myself_pro_is_counter_section_enable',
		'type'				=> 'text',
	) );

	// counter title setting and control
	$wp_customize->add_setting( 'myself_pro_theme_options[counter_number_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'myself_pro_theme_options[counter_number_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Counter Count %d', 'myself-pro' ), $i ),
		'section'        	=> 'myself_pro_counter_section',
		'active_callback' 	=> 'myself_pro_is_counter_section_enable',
		'type'				=> 'text',
	) );

	// counter hr setting and control
	$wp_customize->add_setting( 'myself_pro_theme_options[counter_hr_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new Myself_Pro_Customize_Horizontal_Line( $wp_customize, 'myself_pro_theme_options[counter_hr_'. $i .']',
		array(
			'section'         => 'myself_pro_counter_section',
			'active_callback' => 'myself_pro_is_counter_section_enable',
			'type'			  => 'hr'
	) ) );
endfor;



