<?php
/**
 * Course Section options
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */

// Add Course section
$wp_customize->add_section( 'myself_pro_course_section', array(
	'title'             => esc_html__( 'Course/Must Read','myself-pro' ),
	'description'       => esc_html__( 'Course/Must Read Section options.', 'myself-pro' ),
	'panel'             => 'myself_pro_front_page_panel',
	) );

// Course content enable control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[course_section_enable]', array(
	'default'			=> 	$options['course_section_enable'],
	'sanitize_callback' => 'myself_pro_sanitize_switch_control',
	) );

$wp_customize->add_control( new Myself_Pro_Switch_Control( $wp_customize, 'myself_pro_theme_options[course_section_enable]', array(
	'label'             => esc_html__( 'Course/Must Read Section Enable', 'myself-pro' ),
	'section'           => 'myself_pro_course_section',
	'on_off_label' 		=> myself_pro_switch_options(),
	) ) );

// course title setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[course_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['course_title'],
	'transport'			=> 'postMessage',
	) );

$wp_customize->add_control( 'myself_pro_theme_options[course_title]', array(
	'label'           	=> esc_html__( 'Title', 'myself-pro' ),
	'section'        	=> 'myself_pro_course_section',
	'active_callback' 	=> 'myself_pro_is_course_section_enable',
	'type'				=> 'text',
	) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[course_title]', array(
		'selector'            => '#courses-section h2.business-section-title',
		'settings'            => 'myself_pro_theme_options[course_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'myself_pro_course_title_partial',
		) );
}

if($options['home_layout'] != 'sixth-design'){

	// course subtitle setting and control
	$wp_customize->add_setting( 'myself_pro_theme_options[course_subtitle]', array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'			=> $options['course_subtitle'],
		'transport'			=> 'postMessage',
	) );
	
	$wp_customize->add_control( 'myself_pro_theme_options[course_subtitle]', array(
		'label'           	=> esc_html__( 'Sub Title', 'myself-pro' ),
		'section'        	=> 'myself_pro_course_section',
		'active_callback' 	=> 'myself_pro_is_course_section_enable',
		'type'				=> 'textarea',
	) );
	
	// Abort if selective refresh is not available.
	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[course_subtitle]', array(
			'selector'            => '#courses-section p.business-section-subtitle',
			'settings'            => 'myself_pro_theme_options[course_subtitle]',
			'container_inclusive' => false,
			'fallback_refresh'    => true,
			'render_callback'     => 'myself_pro_course_subtitle_partial',
		) );
	}
}


// Course content type control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[course_column]', array(
	'default'          	=> $options['course_column'],
	'sanitize_callback' => 'myself_pro_sanitize_select',
) );

$wp_customize->add_control( 'myself_pro_theme_options[course_column]', array(
	'label'             => esc_html__( 'Column Layout', 'myself-pro' ),
	'section'           => 'myself_pro_course_section',
	'type'				=> 'select',
	'active_callback' 	=> 'myself_pro_is_course_section_enable',
	'choices'			=> array( 
		'col-2' 	=> esc_html__( 'Two Column', 'myself-pro' ),
		'col-3' 	=> esc_html__( 'Three Column', 'myself-pro' ),
		'col-4' 	=> esc_html__( 'Four Column', 'myself-pro' ),
	),
) );

// Event social icons number control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[course_count]', array(
	'default'          	=> $options['course_count'],
	'sanitize_callback' => 'myself_pro_sanitize_number_range',
	'validate_callback' => 'myself_pro_validate_course_count',
	) );

$wp_customize->add_control( 'myself_pro_theme_options[course_count]', array(
	'label'             => esc_html__( 'Number of Slides', 'myself-pro' ),
	'description'       => esc_html__( 'Note: Min 3 & Max 12. Please input the valid number and save. Then refresh the page to see the change.', 'myself-pro' ),
	'section'           => 'myself_pro_course_section',
	'active_callback'   => 'myself_pro_is_course_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 3,
		'max'	=> 12,
		'style' => 'width: 100px;'
		),
	) );

// Course content type control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[course_content_type]', array(
	'default'          	=> $options['course_content_type'],
	'sanitize_callback' => 'myself_pro_sanitize_select',
	) );

$wp_customize->add_control( 'myself_pro_theme_options[course_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'myself-pro' ),
	'section'           => 'myself_pro_course_section',
	'type'				=> 'select',
	'active_callback' 	=> 'myself_pro_is_course_section_enable',
	'choices'			=> array( 
		'page' 		=> esc_html__( 'Page', 'myself-pro' ),
		'post' 		=> esc_html__( 'Post', 'myself-pro' ),
		'category' 	=> esc_html__( 'Category', 'myself-pro' ),
		),
	) );

for ( $i = 1; $i <= $options['course_count']; $i++ ) :
	// course pages drop down chooser control and setting
	$wp_customize->add_setting( 'myself_pro_theme_options[course_content_page_' . $i . ']', array(
		'sanitize_callback' => 'myself_pro_sanitize_page',
		) );

$wp_customize->add_control( new Myself_Pro_Dropdown_Chooser( $wp_customize, 'myself_pro_theme_options[course_content_page_' . $i . ']', array(
	'label'             => sprintf( esc_html__( 'Select Page %d', 'myself-pro' ), $i ),
	'section'           => 'myself_pro_course_section',
	'choices'			=> myself_pro_page_choices(),
	'active_callback'	=> 'myself_pro_is_course_section_content_page_enable',
	) ) );

	// course posts drop down chooser control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[course_content_post_' . $i . ']', array(
	'sanitize_callback' => 'myself_pro_sanitize_page',
	) );

$wp_customize->add_control( new Myself_Pro_Dropdown_Chooser( $wp_customize, 'myself_pro_theme_options[course_content_post_' . $i . ']', array(
	'label'             => sprintf( esc_html__( 'Select Post %d', 'myself-pro' ), $i ),
	'section'           => 'myself_pro_course_section',
	'choices'			=> myself_pro_post_choices(),
	'active_callback'	=> 'myself_pro_is_course_section_content_post_enable',
	) ) );

endfor;

// Add dropdown category setting and control.
$wp_customize->add_setting(  'myself_pro_theme_options[course_content_category]', array(
	'sanitize_callback' => 'myself_pro_sanitize_single_category',
	) ) ;

$wp_customize->add_control( new Myself_Pro_Dropdown_Taxonomies_Control( $wp_customize,'myself_pro_theme_options[course_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'myself-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'myself-pro' ),
	'section'           => 'myself_pro_course_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'myself_pro_is_course_section_content_category_enable'
	) ) );