<?php
/**
 * Call to Action Section options
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */

// Add Call to Action section
$wp_customize->add_section( 'myself_pro_cta_section', array(
	'title'             => esc_html__( 'Call to Action','myself-pro' ),
	'description'       => esc_html__( 'Call to Action Section options.', 'myself-pro' ),
	'panel'             => 'myself_pro_front_page_panel',
) );

// Call to Action content enable control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[cta_section_enable]', array(
	'default'			=> 	$options['cta_section_enable'],
	'sanitize_callback' => 'myself_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Myself_Pro_Switch_Control( $wp_customize, 'myself_pro_theme_options[cta_section_enable]', array(
	'label'             => esc_html__( 'Call to Action Section Enable', 'myself-pro' ),
	'section'           => 'myself_pro_cta_section',
	'on_off_label' 		=> myself_pro_switch_options(),
) ) );

// Call to Action content type control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[cta_content_type]', array(
	'default'          	=> $options['cta_content_type'],
	'sanitize_callback' => 'myself_pro_sanitize_select',
) );

$wp_customize->add_control( 'myself_pro_theme_options[cta_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'myself-pro' ),
	'section'           => 'myself_pro_cta_section',
	'type'				=> 'select',
	'active_callback' 	=> 'myself_pro_is_cta_section_enable',
	'choices'			=> array( 
		'page' 		=> esc_html__( 'Page', 'myself-pro' ),
		'post' 		=> esc_html__( 'Post', 'myself-pro' ),
		'custom' 	=> esc_html__( 'Custom', 'myself-pro' ),
	),
) );

// cta pages drop down chooser control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[cta_content_page]', array(
	'sanitize_callback' => 'myself_pro_sanitize_page',
) );

$wp_customize->add_control( new Myself_Pro_Dropdown_Chooser( $wp_customize, 'myself_pro_theme_options[cta_content_page]', array(
	'label'             => esc_html__( 'Select Page', 'myself-pro' ),
	'section'           => 'myself_pro_cta_section',
	'choices'			=> myself_pro_page_choices(),
	'active_callback'	=> 'myself_pro_is_cta_section_content_page_enable',
) ) );

// cta posts drop down chooser control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[cta_content_post]', array(
	'sanitize_callback' => 'myself_pro_sanitize_page',
) );

$wp_customize->add_control( new Myself_Pro_Dropdown_Chooser( $wp_customize, 'myself_pro_theme_options[cta_content_post]', array(
	'label'             => esc_html__( 'Select Post', 'myself-pro' ),
	'section'           => 'myself_pro_cta_section',
	'choices'			=> myself_pro_post_choices(),
	'active_callback'	=> 'myself_pro_is_cta_section_content_post_enable',
) ) );

// cta title setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[cta_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['cta_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'myself_pro_theme_options[cta_title]', array(
	'label'           	=> esc_html__( 'Title', 'myself-pro' ),
	'section'        	=> 'myself_pro_cta_section',
	'active_callback' 	=> 'myself_pro_is_cta_section_content_custom_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[cta_title]', array(
		'selector'            => '#call-to-action .wrapper .section-header h2.section-title',
		'settings'            => 'myself_pro_theme_options[cta_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'myself_pro_cta_title_partial',
    ) );
}

// cta btn title setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[cta_btn_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['cta_btn_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'myself_pro_theme_options[cta_btn_title]', array(
	'label'           	=> esc_html__( 'Button Label', 'myself-pro' ),
	'section'        	=> 'myself_pro_cta_section',
	'active_callback' 	=> 'myself_pro_is_cta_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[cta_btn_title]', array(
		'selector'            => '#call-to-action .wrapper a.btn',
		'settings'            => 'myself_pro_theme_options[cta_btn_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'myself_pro_cta_btn_title_partial',
    ) );
}

// cta btn link setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[cta_btn_link]', array(
	'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( 'myself_pro_theme_options[cta_btn_link]', array(
	'label'           	=> esc_html__( 'Button Link', 'myself-pro' ),
	'section'        	=> 'myself_pro_cta_section',
	'active_callback' 	=> 'myself_pro_is_cta_section_content_custom_enable',
	'type'				=> 'url',
) );