<?php
/**
 * Experience Section options
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */

// Add Experience section
$wp_customize->add_section( 'myself_pro_experience_section', array(
	'title'             => esc_html__( 'Work Experience','myself-pro' ),
	'description'       => esc_html__( 'Experience Section options.', 'myself-pro' ),
	'panel'             => 'myself_pro_front_page_panel',
) );

// Experience content enable control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[experience_section_enable]', array(
	'default'			=> 	$options['experience_section_enable'],
	'sanitize_callback' => 'myself_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Myself_Pro_Switch_Control( $wp_customize, 'myself_pro_theme_options[experience_section_enable]', array(
	'label'             => esc_html__( 'Experience Section Enable', 'myself-pro' ),
	'section'           => 'myself_pro_experience_section',
	'on_off_label' 		=> myself_pro_switch_options(),
) ) );

// Experience title setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[experience_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['experience_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'myself_pro_theme_options[experience_title]', array(
	'label'           	=> esc_html__( 'Experience Title', 'myself-pro' ),
	'section'        	=> 'myself_pro_experience_section',
	'active_callback' 	=> 'myself_pro_is_experience_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[experience_title]', array(
		'selector'            => '#working-experience .section-header h2.section-title',
		'settings'            => 'myself_pro_theme_options[experience_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'myself_pro_experience_title_partial',
    ) );
}

// Experience description setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[experience_description]', array(
	'sanitize_callback' => 'wp_kses_post',
	'default'			=> $options['experience_description'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'myself_pro_theme_options[experience_description]', array(
	'label'           	=> esc_html__( 'Experience Description', 'myself-pro' ),
	'section'        	=> 'myself_pro_experience_section',
	'active_callback' 	=> 'myself_pro_is_experience_section_enable',
	'type'				=> 'textarea',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[experience_description]', array(
		'selector'            => '#working-experience .section-content p',
		'settings'            => 'myself_pro_theme_options[experience_description]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'myself_pro_experience_description_partial',
    ) );
}

// Experience column type control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[experience_column_type]', array(
	'default'          	=> $options['experience_column_type'],
	'sanitize_callback' => 'myself_pro_sanitize_select',
) );

$wp_customize->add_control( 'myself_pro_theme_options[experience_column_type]', array(
	'label'             => esc_html__( 'Column Type', 'myself-pro' ),
	'section'           => 'myself_pro_experience_section',
	'type'				=> 'select',
	'active_callback' 	=> 'myself_pro_is_experience_section_enable',
	'choices'			=> array( 
		3 		=> esc_html__( 'Three Column', 'myself-pro' ),
		4 		=> esc_html__( 'Four Column', 'myself-pro' ),
	),
) );

// Event social icons number control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[experience_count]', array(
	'default'          	=> $options['experience_count'],
	'sanitize_callback' => 'myself_pro_sanitize_number_range',
	'validate_callback' => 'myself_pro_validate_experience_count',
) );

$wp_customize->add_control( 'myself_pro_theme_options[experience_count]', array(
	'label'             => esc_html__( 'Number of Slides', 'myself-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 10. Please input the valid number and save. Then refresh the page to see the change.', 'myself-pro' ),
	'section'           => 'myself_pro_experience_section',
	'active_callback'   => 'myself_pro_is_experience_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'max'	=> 10,
		'style' => 'width: 100px;'
		),
) );

// Experience content type control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[experience_content_type]', array(
	'default'          	=> $options['experience_content_type'],
	'sanitize_callback' => 'myself_pro_sanitize_select',
) );

$wp_customize->add_control( 'myself_pro_theme_options[experience_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'myself-pro' ),
	'section'           => 'myself_pro_experience_section',
	'type'				=> 'select',
	'active_callback' 	=> 'myself_pro_is_experience_section_enable',
	'choices'			=> array( 
		'page' 		=> esc_html__( 'Page', 'myself-pro' ),
		'post' 		=> esc_html__( 'Post', 'myself-pro' ),
		'custom' 	=> esc_html__( 'Custom', 'myself-pro' ),
	),
) );

for ( $i = 1; $i <= $options['experience_count']; $i++ ) :
	// experience pages drop down chooser control and setting
	$wp_customize->add_setting( 'myself_pro_theme_options[experience_content_page_' . $i . ']', array(
		'sanitize_callback' => 'myself_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Myself_Pro_Dropdown_Chooser( $wp_customize, 'myself_pro_theme_options[experience_content_page_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Page %d', 'myself-pro' ), $i ),
		'section'           => 'myself_pro_experience_section',
		'choices'			=> myself_pro_page_choices(),
		'active_callback'	=> 'myself_pro_is_experience_section_content_page_enable',
	) ) );

	// experience posts drop down chooser control and setting
	$wp_customize->add_setting( 'myself_pro_theme_options[experience_content_post_' . $i . ']', array(
		'sanitize_callback' => 'myself_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Myself_Pro_Dropdown_Chooser( $wp_customize, 'myself_pro_theme_options[experience_content_post_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Post %d', 'myself-pro' ), $i ),
		'section'           => 'myself_pro_experience_section',
		'choices'			=> myself_pro_post_choices(),
		'active_callback'	=> 'myself_pro_is_experience_section_content_post_enable',
	) ) );

	// Experience title setting and control
	$wp_customize->add_setting( 'myself_pro_theme_options[experience_title_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'myself_pro_theme_options[experience_title_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Experience Title %d', 'myself-pro' ), $i),
		'section'        	=> 'myself_pro_experience_section',
		'active_callback' 	=> 'myself_pro_is_experience_section_content_custom_enable',
		'type'				=> 'text',
	) );

	// Experience description setting and control
	$wp_customize->add_setting( 'myself_pro_theme_options[experience_description_' . $i . ']', array(
		'sanitize_callback' => 'wp_kses_post',
	) );

	$wp_customize->add_control( 'myself_pro_theme_options[experience_description_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Experience Description %d', 'myself-pro' ), $i),
		'section'        	=> 'myself_pro_experience_section',
		'active_callback' 	=> 'myself_pro_is_experience_section_content_custom_enable',
		'type'				=> 'textarea',
	) );

	// Experience url setting and control
	$wp_customize->add_setting( 'myself_pro_theme_options[experience_url_' . $i . ']', array(
		'sanitize_callback' => 'esc_url_raw',
	) );

	$wp_customize->add_control( 'myself_pro_theme_options[experience_url_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Experience Url %d', 'myself-pro' ), $i),
		'section'        	=> 'myself_pro_experience_section',
		'active_callback' 	=> 'myself_pro_is_experience_section_content_custom_enable',
		'type'				=> 'url',
	) );

	// Experience image setting and control.
	$wp_customize->add_setting( 'myself_pro_theme_options[experience_image_' . $i . ']', array(
		'sanitize_callback' => 'myself_pro_sanitize_image',
	) );

	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'myself_pro_theme_options[experience_image_' . $i . ']',
			array(
			'label'       		=> sprintf( esc_html__( 'Image %d', 'myself-pro' ), $i),
			'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'myself-pro' ), 600, 450 ),
			'section'     		=> 'myself_pro_experience_section',
			'active_callback'	=> 'myself_pro_is_experience_section_content_custom_enable',
	) ) );

	// Experience from date setting and control
	$wp_customize->add_setting( 'myself_pro_theme_options[experience_duration_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'myself_pro_theme_options[experience_duration_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Duration ( From - To ) %d', 'myself-pro' ), $i),
		'section'        	=> 'myself_pro_experience_section',
		'active_callback' 	=> 'myself_pro_is_experience_section_enable',
		'type'				=> 'text',
	) );

	// experience hr setting and control
	$wp_customize->add_setting( 'myself_pro_theme_options[experience_hr_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new Myself_Pro_Customize_Horizontal_Line( $wp_customize, 'myself_pro_theme_options[experience_hr_'. $i .']',
		array(
			'section'         => 'myself_pro_experience_section',
			'active_callback' => 'myself_pro_is_experience_section_enable',
			'type'			  => 'hr'
	) ) );

endfor;
