<?php
/**
 * Help Us  Section options
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */

// Add Help Us  section
$wp_customize->add_section( 'myself_pro_helpus_section', array(
	'title'             => esc_html__( 'Help Us/Thumbnail ','myself-pro' ),
	'description'       => esc_html__( 'Help Us/Thumbnail Section options.', 'myself-pro' ),
	'panel'             => 'myself_pro_front_page_panel',
) );

// Help Us  content enable control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[helpus_section_enable]', array(
	'default'			=> 	$options['helpus_section_enable'],
	'sanitize_callback' => 'myself_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Myself_Pro_Switch_Control( $wp_customize, 'myself_pro_theme_options[helpus_section_enable]', array(
	'label'             => esc_html__( 'Help Us/Thumbnail Section Enable', 'myself-pro' ),
	'section'           => 'myself_pro_helpus_section',
	'on_off_label' 		=> myself_pro_switch_options(),
) ) );


// Blog content type control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[helpus_column]', array(
	'default'          	=> $options['helpus_column'],
	'sanitize_callback' => 'myself_pro_sanitize_select',
) );

$wp_customize->add_control( 'myself_pro_theme_options[helpus_column]', array(
	'label'             => esc_html__( 'Column Layout', 'myself-pro' ),
	'section'           => 'myself_pro_helpus_section',
	'type'				=> 'select',
	'active_callback' 	=> 'myself_pro_is_helpus_section_enable',
	'choices'			=> array( 
		'col-2' 	=> esc_html__( 'Two Column', 'myself-pro' ),
		'col-3' 	=> esc_html__( 'Three Column', 'myself-pro' ),
		'col-4' 	=> esc_html__( 'Four Column', 'myself-pro' ),
	),
) );

if($options['home_layout'] != 'sixth-design'){

	// blog title setting and control
	$wp_customize->add_setting( 'myself_pro_theme_options[helpus_title]', array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'			=> $options['helpus_title'],
		'transport'			=> 'postMessage',
	) );
	
	$wp_customize->add_control( 'myself_pro_theme_options[helpus_title]', array(
		'label'           	=> esc_html__( 'Title', 'myself-pro' ),
		'section'        	=> 'myself_pro_helpus_section',
		'active_callback' 	=> 'myself_pro_is_helpus_section_enable',
		'type'				=> 'text',
	) );
	
	// Abort if selective refresh is not available.
	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[helpus_title]', array(
			'selector'            => '#latest-posts .section-header h2.section-title',
			'settings'            => 'myself_pro_theme_options[helpus_title]',
			'container_inclusive' => false,
			'fallback_refresh'    => true,
			'render_callback'     => 'myself_pro_helpus_title_partial',
		) );
	}
}

// Event social icons number control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[helpus_count]', array(
	'default'          	=> $options['helpus_count'],
	'sanitize_callback' => 'myself_pro_sanitize_number_range',
	'validate_callback' => 'myself_pro_validate_helpus_count',
) );

$wp_customize->add_control( 'myself_pro_theme_options[helpus_count]', array(
	'label'             => esc_html__( 'Number of Posts', 'myself-pro' ),
	'description'       => esc_html__( 'Note: Min 3 & Max 12. Please input the valid number and save. Then refresh the page to see the change.', 'myself-pro' ),
	'section'           => 'myself_pro_helpus_section',
	'active_callback'   => 'myself_pro_is_helpus_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 3,
		'max'	=> 12,
		'style' => 'width: 100px;'
		),
) );

// Help Us  content type control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[helpus_content_type]', array(
	'default'          	=> $options['helpus_content_type'],
	'sanitize_callback' => 'myself_pro_sanitize_select',
) );

$wp_customize->add_control( 'myself_pro_theme_options[helpus_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'myself-pro' ),
	'section'           => 'myself_pro_helpus_section',
	'type'				=> 'select',
	'active_callback' 	=> 'myself_pro_is_helpus_section_enable',
	'choices'			=> array( 
		'page' 		=> esc_html__( 'Page', 'myself-pro' ),
		'post' 		=> esc_html__( 'Post', 'myself-pro' ),
		'category' 	=> esc_html__( 'Category', 'myself-pro' ),
		'recent' 	=> esc_html__( 'Recent', 'myself-pro' ),
	),
) );

for ( $i = 1; $i <= $options['helpus_count']; $i++ ) :
	// blog pages drop down chooser control and setting
	$wp_customize->add_setting( 'myself_pro_theme_options[helpus_content_page_' . $i . ']', array(
		'sanitize_callback' => 'myself_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Myself_Pro_Dropdown_Chooser( $wp_customize, 'myself_pro_theme_options[helpus_content_page_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Page %d', 'myself-pro' ), $i ),
		'section'           => 'myself_pro_helpus_section',
		'choices'			=> myself_pro_page_choices(),
		'active_callback'	=> 'myself_pro_is_helpus_section_content_page_enable',
	) ) );

	// blog posts drop down chooser control and setting
	$wp_customize->add_setting( 'myself_pro_theme_options[helpus_content_post_' . $i . ']', array(
		'sanitize_callback' => 'myself_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Myself_Pro_Dropdown_Chooser( $wp_customize, 'myself_pro_theme_options[helpus_content_post_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Post %d', 'myself-pro' ), $i ),
		'section'           => 'myself_pro_helpus_section',
		'choices'			=> myself_pro_post_choices(),
		'active_callback'	=> 'myself_pro_is_helpus_section_content_post_enable',
	) ) );
endfor;

// Add dropdown category setting and control.
$wp_customize->add_setting(  'myself_pro_theme_options[helpus_content_category]', array(
	'sanitize_callback' => 'myself_pro_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Myself_Pro_Dropdown_Taxonomies_Control( $wp_customize,'myself_pro_theme_options[helpus_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'myself-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'myself-pro' ),
	'section'           => 'myself_pro_helpus_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'myself_pro_is_helpus_section_content_category_enable'
) ) );

// Add dropdown categories setting and control.
$wp_customize->add_setting( 'myself_pro_theme_options[helpus_category_exclude]', array(
	'sanitize_callback' => 'myself_pro_sanitize_category_list',
) ) ;

$wp_customize->add_control( new Myself_Pro_Dropdown_Category_Control( $wp_customize,'myself_pro_theme_options[helpus_category_exclude]', array(
	'label'             => esc_html__( 'Select Excluding Categories', 'myself-pro' ),
	'description'      	=> esc_html__( 'Note: Select categories to exclude. Press CTRL key select multilple categories.', 'myself-pro' ),
	'section'           => 'myself_pro_helpus_section',
	'type'              => 'dropdown-categories',
	'active_callback'	=> 'myself_pro_is_helpus_section_content_recent_enable'
) ) );

if($options['home_layout'] != 'sixth-design'){
	
	// blog btn title setting and control
	$wp_customize->add_setting( 'myself_pro_theme_options[helpus_btn_title]', array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'			=> $options['helpus_btn_title'],
		'transport'			=> 'postMessage',
	) );
	
	$wp_customize->add_control( 'myself_pro_theme_options[helpus_btn_title]', array(
		'label'           	=> esc_html__( 'Btn Label', 'myself-pro' ),
		'section'        	=> 'myself_pro_helpus_section',
		'active_callback' 	=> 'myself_pro_is_helpus_section_enable',
		'type'				=> 'text',
	) );
	
	// Abort if selective refresh is not available.
	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[helpus_btn_title]', array(
			'selector'            => '#help-us .section-content .entry-container .business-read-more a',
			'settings'            => 'myself_pro_theme_options[helpus_btn_title]',
			'container_inclusive' => false,
			'fallback_refresh'    => true,
			'render_callback'     => 'myself_pro_helpus_btn_title_partial',
		) );
	}

}
