<?php
/**
 * Instagram Section options
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */

// Add Instagram section
$wp_customize->add_section( 'myself_pro_instagram_section', array(
	'title'             => esc_html__( 'Instagram','myself-pro' ),
	'description'       => sprintf( myself_pro_santize_allow_tag('Instagram Section options. First you need to install and active <a href="https://wordpress.org/plugins/instagram-feed/" target="_blank">Instagram Feed</a> Plugin and then <a href="%1$s" target="_blank">click here </a> to link instagram account', 'myself-pro'), admin_url( $paths = '?page=sb-instagram-feed', $scheme = 'admin' ) ),
	'panel'             => 'myself_pro_front_page_panel',
) );

// Instagram content enable control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[instagram_section_enable]', array(
	'default'			=> 	$options['instagram_section_enable'],
	'sanitize_callback' => 'myself_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Myself_Pro_Switch_Control( $wp_customize, 'myself_pro_theme_options[instagram_section_enable]', array(
	'label'             => esc_html__( 'Instagram Section Enable', 'myself-pro' ),
	'section'           => 'myself_pro_instagram_section',
	'on_off_label' 		=> myself_pro_switch_options(),
) ) );

// blog title setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[instagram_shortcode]', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'myself_pro_theme_options[instagram_shortcode]', array(
	'label'           	=> esc_html__( 'Enter ShortCode', 'myself-pro' ),
	'section'        	=> 'myself_pro_instagram_section',
	'active_callback' 	=> 'myself_pro_is_instagram_section_enable',
	'type'				=> 'text',
) );