<?php
/**
 * Introduction Section options
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */

// Add Introduction section
$wp_customize->add_section( 'myself_pro_introduction_section', array(
	'title'             => esc_html__( 'Introduction','myself-pro' ),
	'description'       => esc_html__( 'Introduction Section options.', 'myself-pro' ),
	'panel'             => 'myself_pro_front_page_panel',
) );

// Introduction content enable control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[introduction_section_enable]', array(
	'default'			=> 	$options['introduction_section_enable'],
	'sanitize_callback' => 'myself_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Myself_Pro_Switch_Control( $wp_customize, 'myself_pro_theme_options[introduction_section_enable]', array(
	'label'             => esc_html__( 'Introduction Section Enable', 'myself-pro' ),
	'section'           => 'myself_pro_introduction_section',
	'on_off_label' 		=> myself_pro_switch_options(),
) ) );

if($options['home_layout'] == 'default-design'){

// Introduction content type control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[introduction_image_style]', array(
	'default'          	=> $options['introduction_image_style'],
	'sanitize_callback' => 'myself_pro_sanitize_select',
) );

$wp_customize->add_control( 'myself_pro_theme_options[introduction_image_style]', array(
	'label'             => esc_html__( 'Image Style', 'myself-pro' ),
	'section'           => 'myself_pro_introduction_section',
	'type'				=> 'select',
	'active_callback' 	=> 'myself_pro_is_introduction_section_enable',
	'choices'			=> array( 
		'full' 		=> esc_html__( 'Full Background Image', 'myself-pro' ),
		'small' 	=> esc_html__( 'Small Image', 'myself-pro' ),
	),
) );

}

// Introduction content type control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[introduction_content_type]', array(
	'default'          	=> $options['introduction_content_type'],
	'sanitize_callback' => 'myself_pro_sanitize_select',
) );

$wp_customize->add_control( 'myself_pro_theme_options[introduction_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'myself-pro' ),
	'section'           => 'myself_pro_introduction_section',
	'type'				=> 'select',
	'active_callback' 	=> 'myself_pro_is_introduction_section_enable',
	'choices'			=> array( 
		'page' 		=> esc_html__( 'Page', 'myself-pro' ),
		'post' 		=> esc_html__( 'Post', 'myself-pro' ),
		'custom' 	=> esc_html__( 'Custom', 'myself-pro' ),
	),
) );

if($options['home_layout'] == 'default-design'){

	// introduction title setting and control
	$wp_customize->add_setting( 'myself_pro_theme_options[introduction_title]', array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'			=> $options['introduction_title'],
		'transport'			=> 'postMessage',
	) );
	
	$wp_customize->add_control( 'myself_pro_theme_options[introduction_title]', array(
		'label'           	=> esc_html__( 'Title', 'myself-pro' ),
		'section'        	=> 'myself_pro_introduction_section',
		'active_callback' 	=> 'myself_pro_is_introduction_section_content_custom_enable',
		'type'				=> 'text',
	) );
	
	// Abort if selective refresh is not available.
	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[introduction_title]', array(
			'selector'            => '#introduction-section .entry-container .entry-header h2.entry-title',
			'settings'            => 'myself_pro_theme_options[introduction_title]',
			'container_inclusive' => false,
			'fallback_refresh'    => true,
			'render_callback'     => 'myself_pro_introduction_title_partial',
		) );
	}
	
	// introduction description setting and control
	$wp_customize->add_setting( 'myself_pro_theme_options[introduction_description]', array(
		'sanitize_callback' => 'wp_kses_post',
		'default'			=> $options['introduction_description'],
		'transport'			=> 'postMessage',
	) );
	
	$wp_customize->add_control( 'myself_pro_theme_options[introduction_description]', array(
		'label'           	=> esc_html__( 'Description', 'myself-pro' ),
		'section'        	=> 'myself_pro_introduction_section',
		'active_callback' 	=> 'myself_pro_is_introduction_section_content_custom_enable',
		'type'				=> 'textarea',
	) );
	
	// Abort if selective refresh is not available.
	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[introduction_description]', array(
			'selector'            => '#introduction-section .entry-container .entry-content p',
			'settings'            => 'myself_pro_theme_options[introduction_description]',
			'container_inclusive' => false,
			'fallback_refresh'    => true,
			'render_callback'     => 'myself_pro_introduction_description_partial',
		) );
	}
	
	// introduction image setting and control.
	$wp_customize->add_setting( 'myself_pro_theme_options[introduction_image]', array(
		'sanitize_callback' => 'myself_pro_sanitize_image'
	) );
	
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'myself_pro_theme_options[introduction_image]',
			array(
			'label'       		=> esc_html__( 'Image', 'myself-pro' ),
			'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'myself-pro' ), 1280, 854 ),
			'section'     		=> 'myself_pro_introduction_section',
			'active_callback'	=> 'myself_pro_is_introduction_section_content_custom_enable',
	) ) );
	
}

if($options['home_layout'] != 'default-design'){

	// Event social icons number control and setting
	$wp_customize->add_setting( 'myself_pro_theme_options[introduction_count]', array(
		'default'          	=> $options['introduction_count'],
		'sanitize_callback' => 'myself_pro_sanitize_number_range',
		'validate_callback' => 'myself_pro_validate_introduction_count',
	) );
	
	$wp_customize->add_control( 'myself_pro_theme_options[introduction_count]', array(
		'label'             => esc_html__( 'Number of Posts', 'myself-pro' ),
		'description'       => esc_html__( 'Note: Min 1 & Max 6. Please input the valid number and save. Then refresh the page to see the change.', 'myself-pro' ),
		'section'           => 'myself_pro_introduction_section',
		'active_callback'   => 'myself_pro_is_introduction_section_enable',
		'type'				=> 'number',
		'input_attrs'		=> array(
			'min'	=> 1,
			'max'	=> 6,
			'style' => 'width: 100px;'
			),
	) );
}

$options['introduction_count'] = ($options['home_layout'] == 'default-design') ? 1 : 2;


for ( $i = 1; $i <= $options['introduction_count']; $i++ ) :
	// introduction pages drop down chooser control and setting
	$wp_customize->add_setting( 'myself_pro_theme_options[introduction_content_page_' . $i . ']', array(
		'sanitize_callback' => 'myself_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Myself_Pro_Dropdown_Chooser( $wp_customize, 'myself_pro_theme_options[introduction_content_page_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Page %d', 'myself-pro' ), $i ),
		'section'           => 'myself_pro_introduction_section',
		'choices'			=> myself_pro_page_choices(),
		'active_callback'	=> 'myself_pro_is_introduction_section_content_page_enable',
	) ) );

	// introduction posts drop down chooser control and setting
	$wp_customize->add_setting( 'myself_pro_theme_options[introduction_content_post_' . $i . ']', array(
		'sanitize_callback' => 'myself_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Myself_Pro_Dropdown_Chooser( $wp_customize, 'myself_pro_theme_options[introduction_content_post_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Post %d', 'myself-pro' ), $i ),
		'section'           => 'myself_pro_introduction_section',
		'choices'			=> myself_pro_post_choices(),
		'active_callback'	=> 'myself_pro_is_introduction_section_content_post_enable',
	) ) );
endfor;


// Add dropdown category setting and control.
$wp_customize->add_setting(  'myself_pro_theme_options[introduction_content_category]', array(
	'sanitize_callback' => 'myself_pro_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Myself_Pro_Dropdown_Taxonomies_Control( $wp_customize,'myself_pro_theme_options[introduction_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'myself-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'myself-pro' ),
	'section'           => 'myself_pro_introduction_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'myself_pro_is_introduction_section_content_category_enable'
) ) );

// introduction btn title setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[introduction_btn_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['introduction_btn_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'myself_pro_theme_options[introduction_btn_title]', array(
	'label'           	=> esc_html__( 'Button Label', 'myself-pro' ),
	'section'        	=> 'myself_pro_introduction_section',
	'active_callback' 	=> 'myself_pro_is_introduction_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[introduction_btn_title]', array(
		'selector'            => '#introduction-section a.btn-1',
		'settings'            => 'myself_pro_theme_options[introduction_btn_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'myself_pro_introduction_btn_title_partial',
    ) );
}

// introduction btn link setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[introduction_btn_link]', array(
	'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( 'myself_pro_theme_options[introduction_btn_link]', array(
	'label'           	=> esc_html__( 'Button Link', 'myself-pro' ),
	'section'        	=> 'myself_pro_introduction_section',
	'active_callback' 	=> 'myself_pro_is_introduction_section_content_custom_enable',
	'type'				=> 'url',
) );

if($options['home_layout'] == 'default-design') {

	// introduction alt btn title setting and control
	$wp_customize->add_setting( 'myself_pro_theme_options[introduction_alt_btn_title]', array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'			=> $options['introduction_alt_btn_title'],
		'transport'			=> 'postMessage',
	) );
	
	$wp_customize->add_control( 'myself_pro_theme_options[introduction_alt_btn_title]', array(
		'label'           	=> esc_html__( 'Alt Button Label', 'myself-pro' ),
		'section'        	=> 'myself_pro_introduction_section',
		'active_callback' 	=> 'myself_pro_is_introduction_section_enable',
		'type'				=> 'text',
	) );
	
	// Abort if selective refresh is not available.
	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[introduction_alt_btn_title]', array(
			'selector'            => '#introduction-section a.btn-2',
			'settings'            => 'myself_pro_theme_options[introduction_alt_btn_title]',
			'container_inclusive' => false,
			'fallback_refresh'    => true,
			'render_callback'     => 'myself_pro_introduction_alt_btn_title_partial',
		) );
	}
	
	// introduction alt btn link setting and control
	$wp_customize->add_setting( 'myself_pro_theme_options[introduction_alt_btn_link]', array(
		'sanitize_callback' => 'esc_url_raw',
	) );
	
	$wp_customize->add_control( 'myself_pro_theme_options[introduction_alt_btn_link]', array(
		'label'           	=> esc_html__( 'Alt Button Link', 'myself-pro' ),
		'section'        	=> 'myself_pro_introduction_section',
		'active_callback' 	=> 'myself_pro_is_introduction_section_enable',
		'type'				=> 'url',
	) );
}