<?php
/**
 * My Profile Section options
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */

// Add My Profile section
$wp_customize->add_section( 'myself_pro_my_profile_section', array(
	'title'             => esc_html__( 'My Profile','myself-pro' ),
	'description'       => esc_html__( 'My Profile Section options.', 'myself-pro' ),
	'panel'             => 'myself_pro_front_page_panel',
) );

// My Profile content enable control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[my_profile_section_enable]', array(
	'default'			=> 	$options['my_profile_section_enable'],
	'sanitize_callback' => 'myself_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Myself_Pro_Switch_Control( $wp_customize, 'myself_pro_theme_options[my_profile_section_enable]', array(
	'label'             => esc_html__( 'My Profile Section Enable', 'myself-pro' ),
	'section'           => 'myself_pro_my_profile_section',
	'on_off_label' 		=> myself_pro_switch_options(),
) ) );

// Event social icons number control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[my_profile_count]', array(
	'default'          	=> $options['my_profile_count'],
	'sanitize_callback' => 'myself_pro_sanitize_number_range',
	'validate_callback' => 'myself_pro_validate_my_profile_count',
) );

$wp_customize->add_control( 'myself_pro_theme_options[my_profile_count]', array(
	'label'             => esc_html__( 'Number of Slides', 'myself-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 10. Please input the valid number and save. Then refresh the page to see the change.', 'myself-pro' ),
	'section'           => 'myself_pro_my_profile_section',
	'active_callback'   => 'myself_pro_is_my_profile_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'max'	=> 10,
		'style' => 'width: 100px;'
		),
) );

// My Profile content type control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[my_profile_content_type]', array(
	'default'          	=> $options['my_profile_content_type'],
	'sanitize_callback' => 'myself_pro_sanitize_select',
) );

$wp_customize->add_control( 'myself_pro_theme_options[my_profile_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'myself-pro' ),
	'section'           => 'myself_pro_my_profile_section',
	'type'				=> 'select',
	'active_callback' 	=> 'myself_pro_is_my_profile_section_enable',
	'choices'			=> array( 
		'page' 		=> esc_html__( 'Page', 'myself-pro' ),
		'post' 		=> esc_html__( 'Post', 'myself-pro' ),
		'category' 	=> esc_html__( 'Category', 'myself-pro' ),
	),
) );

for ( $i = 1; $i <= $options['my_profile_count']; $i++ ) :
	// my_profile pages drop down chooser control and setting
	$wp_customize->add_setting( 'myself_pro_theme_options[my_profile_content_page_' . $i . ']', array(
		'sanitize_callback' => 'myself_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Myself_Pro_Dropdown_Chooser( $wp_customize, 'myself_pro_theme_options[my_profile_content_page_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Page %d', 'myself-pro' ), $i ),
		'section'           => 'myself_pro_my_profile_section',
		'choices'			=> myself_pro_page_choices(),
		'active_callback'	=> 'myself_pro_is_my_profile_section_content_page_enable',
	) ) );

	// my_profile posts drop down chooser control and setting
	$wp_customize->add_setting( 'myself_pro_theme_options[my_profile_content_post_' . $i . ']', array(
		'sanitize_callback' => 'myself_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Myself_Pro_Dropdown_Chooser( $wp_customize, 'myself_pro_theme_options[my_profile_content_post_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Post %d', 'myself-pro' ), $i ),
		'section'           => 'myself_pro_my_profile_section',
		'choices'			=> myself_pro_post_choices(),
		'active_callback'	=> 'myself_pro_is_my_profile_section_content_post_enable',
	) ) );
endfor;

// Add dropdown category setting and control.
$wp_customize->add_setting(  'myself_pro_theme_options[my_profile_content_category]', array(
	'sanitize_callback' => 'myself_pro_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Myself_Pro_Dropdown_Taxonomies_Control( $wp_customize,'myself_pro_theme_options[my_profile_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'myself-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'myself-pro' ),
	'section'           => 'myself_pro_my_profile_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'myself_pro_is_my_profile_section_content_category_enable'
) ) );
