<?php
/**
 * Photography Section options
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */

// Add Photography section
$wp_customize->add_section( 'myself_pro_photography_section', array(
	'title'             => esc_html__( 'Photography','myself-pro' ),
	'description'       => esc_html__( 'Photography Section options.', 'myself-pro' ),
	'panel'             => 'myself_pro_front_page_panel',
) );

// Photography content enable control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[photography_section_enable]', array(
	'default'			=> 	$options['photography_section_enable'],
	'sanitize_callback' => 'myself_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Myself_Pro_Switch_Control( $wp_customize, 'myself_pro_theme_options[photography_section_enable]', array(
	'label'             => esc_html__( 'Photography Section Enable', 'myself-pro' ),
	'section'           => 'myself_pro_photography_section',
	'on_off_label' 		=> myself_pro_switch_options(),
) ) );

// photography title setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[photography_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['photography_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'myself_pro_theme_options[photography_title]', array(
	'label'           	=> esc_html__( 'Title', 'myself-pro' ),
	'section'        	=> 'myself_pro_photography_section',
	'active_callback' 	=> 'myself_pro_is_photography_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[photography_title]', array(
		'selector'            => '#latest-posts .section-header h2.section-title',
		'settings'            => 'myself_pro_theme_options[photography_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'myself_pro_photography_title_partial',
    ) );
}

// Event social icons number control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[photography_count]', array(
	'default'          	=> $options['photography_count'],
	'sanitize_callback' => 'myself_pro_sanitize_number_range',
	'validate_callback' => 'myself_pro_validate_photography_count',
) );

$wp_customize->add_control( 'myself_pro_theme_options[photography_count]', array(
	'label'             => esc_html__( 'Number of Posts', 'myself-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 6. Please input the valid number and save. Then refresh the page to see the change.', 'myself-pro' ),
	'section'           => 'myself_pro_photography_section',
	'active_callback'   => 'myself_pro_is_photography_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'max'	=> 6,
		'style' => 'width: 100px;'
		),
) );

// Photography content type control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[photography_content_type]', array(
	'default'          	=> $options['photography_content_type'],
	'sanitize_callback' => 'myself_pro_sanitize_select',
) );

$wp_customize->add_control( 'myself_pro_theme_options[photography_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'myself-pro' ),
	'section'           => 'myself_pro_photography_section',
	'type'				=> 'select',
	'active_callback' 	=> 'myself_pro_is_photography_section_enable',
	'choices'			=> array( 
		'page' 		=> esc_html__( 'Page', 'myself-pro' ),
		'post' 		=> esc_html__( 'Post', 'myself-pro' ),
		'category' 	=> esc_html__( 'Category', 'myself-pro' ),
		'recent' 	=> esc_html__( 'Recent', 'myself-pro' ),
	),
) );

for ( $i = 1; $i <= $options['photography_count']; $i++ ) :
	// photography pages drop down chooser control and setting
	$wp_customize->add_setting( 'myself_pro_theme_options[photography_content_page_' . $i . ']', array(
		'sanitize_callback' => 'myself_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Myself_Pro_Dropdown_Chooser( $wp_customize, 'myself_pro_theme_options[photography_content_page_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Page %d', 'myself-pro' ), $i ),
		'section'           => 'myself_pro_photography_section',
		'choices'			=> myself_pro_page_choices(),
		'active_callback'	=> 'myself_pro_is_photography_section_content_page_enable',
	) ) );

	// photography posts drop down chooser control and setting
	$wp_customize->add_setting( 'myself_pro_theme_options[photography_content_post_' . $i . ']', array(
		'sanitize_callback' => 'myself_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Myself_Pro_Dropdown_Chooser( $wp_customize, 'myself_pro_theme_options[photography_content_post_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Post %d', 'myself-pro' ), $i ),
		'section'           => 'myself_pro_photography_section',
		'choices'			=> myself_pro_post_choices(),
		'active_callback'	=> 'myself_pro_is_photography_section_content_post_enable',
	) ) );
endfor;

// Add dropdown category setting and control.
$wp_customize->add_setting(  'myself_pro_theme_options[photography_content_category]', array(
	'sanitize_callback' => 'myself_pro_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Myself_Pro_Dropdown_Taxonomies_Control( $wp_customize,'myself_pro_theme_options[photography_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'myself-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'myself-pro' ),
	'section'           => 'myself_pro_photography_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'myself_pro_is_photography_section_content_category_enable'
) ) );

// Add dropdown categories setting and control.
$wp_customize->add_setting( 'myself_pro_theme_options[photography_category_exclude]', array(
	'sanitize_callback' => 'myself_pro_sanitize_category_list',
) ) ;

$wp_customize->add_control( new Myself_Pro_Dropdown_Category_Control( $wp_customize,'myself_pro_theme_options[photography_category_exclude]', array(
	'label'             => esc_html__( 'Select Excluding Categories', 'myself-pro' ),
	'description'      	=> esc_html__( 'Note: Select categories to exclude. Press CTRL key select multilple categories.', 'myself-pro' ),
	'section'           => 'myself_pro_photography_section',
	'type'              => 'dropdown-categories',
	'active_callback'	=> 'myself_pro_is_photography_section_content_recent_enable'
) ) );

if($options['home_layout'] == 'sixth-design'){

	// photography  background image setting and control.
	$wp_customize->add_setting( 'myself_pro_theme_options[photography_advertisement_image]', array(
		'sanitize_callback' => 'myself_pro_sanitize_image'
	  ) );
	  
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'myself_pro_theme_options[photography_advertisement_image]',
		array(
		'label'           => esc_html__( 'Advertisement Image', 'myself-pro'),
		'description'     => sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'myself-pro' ), 900, 100 ),
		'section'         => 'myself_pro_photography_section',
		'active_callback' => 'myself_pro_is_photography_section_enable',
	) ) );
	
	
	// photography btn title setting and control
	$wp_customize->add_setting( 'myself_pro_theme_options[photography_advertisement_url]', array(
		'sanitize_callback' => 'esc_url_raw',
		'transport'			=> 'refresh',
	) );
	
	$wp_customize->add_control( 'myself_pro_theme_options[photography_advertisement_url]', array(
		'label'           	=> esc_html__( 'Advertisement Url', 'myself-pro' ),
		'section'        	=> 'myself_pro_photography_section',
		'active_callback' 	=> 'myself_pro_is_photography_section_enable',
		'type'				=> 'url',
	) );

}else{
	
	// about btn title setting and control
	$wp_customize->add_setting( 'myself_pro_theme_options[photography_btn_title]', array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'			=> $options['photography_btn_title'],
		'transport'			=> 'postMessage',
	) );
	
	$wp_customize->add_control( 'myself_pro_theme_options[photography_btn_title]', array(
		'label'           	=> esc_html__( 'Button Label', 'myself-pro' ),
		'section'        	=> 'myself_pro_photography_section',
		'active_callback' 	=> 'myself_pro_is_photography_section_enable',
		'type'				=> 'text',
	) );
	
	// Abort if selective refresh is not available.
	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[photography_btn_title]', array(
			'selector'            => '#blog-popular-posts article div.read-more',
			'settings'            => 'myself_pro_theme_options[photography_btn_title]',
			'container_inclusive' => false,
			'fallback_refresh'    => true,
			'render_callback'     => 'myself_pro_photography_btn_title_partial',
		) );
	}
}