<?php
/**
 * Popular Destination Section options
 *
 * @popular_destination Theme Palace
 * @subpopular_destination Myself Pro
 * @since Myself Pro 1.0.0
 */

// Add Popular Destination section
$wp_customize->add_section( 'myself_pro_popular_destination_section', array(
	'title'             => esc_html__( 'Popular Destination','myself-pro' ),
	'description'       => esc_html__( 'Popular Destination Section options.', 'myself-pro' ),
	'panel'             => 'myself_pro_front_page_panel',
) );

// Popular Destination content enable control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[popular_destination_section_enable]', array(
	'default'			=> 	$options['popular_destination_section_enable'],
	'sanitize_callback' => 'myself_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Myself_Pro_Switch_Control( $wp_customize, 'myself_pro_theme_options[popular_destination_section_enable]', array(
	'label'             => esc_html__( 'Popular Destination Section Enable', 'myself-pro' ),
	'section'           => 'myself_pro_popular_destination_section',
	'on_off_label' 		=> myself_pro_switch_options(),
) ) );

// popular destination title setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[popular_destination_title]', array(
	'default'			=> $options['popular_destination_title'],
	'sanitize_callback' => 'sanitize_text_field',
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'myself_pro_theme_options[popular_destination_title]', array(
	'label'           	=> esc_html__( 'Title', 'myself-pro' ),
	'section'        	=> 'myself_pro_popular_destination_section',
	'active_callback' 	=> 'myself_pro_is_popular_destination_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[popular_destination_title]', array(
		'selector'            => '#travel-destination-section h2.business-section-title',
		'settings'            => 'myself_pro_theme_options[popular_destination_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'myself_pro_popular_destination_title_partial',
    ) );
}

// popular destination title setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[popular_destination_description]', array(
	'default'			=> $options['popular_destination_description'],
	'sanitize_callback' => 'sanitize_text_field',
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'myself_pro_theme_options[popular_destination_description]', array(
	'label'           	=> esc_html__( 'Description', 'myself-pro' ),
	'section'        	=> 'myself_pro_popular_destination_section',
	'active_callback' 	=> 'myself_pro_is_popular_destination_section_enable',
	'type'				=> 'textarea',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[popular_destination_description]', array(
		'selector'            => '#travel-destination-section p.business-section-subtitle',
		'settings'            => 'myself_pro_theme_options[popular_destination_description]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'myself_pro_popular_destination_description_partial',
    ) );
}

// Popular Destination content type control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[popular_destination_content_type]', array(
	'default'          	=> $options['popular_destination_content_type'],
	'sanitize_callback' => 'myself_pro_sanitize_select',
) );

$wp_customize->add_control( 'myself_pro_theme_options[popular_destination_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'myself-pro' ),
	'section'           => 'myself_pro_popular_destination_section',
	'type'				=> 'select',
	'active_callback' 	=> 'myself_pro_is_popular_destination_section_enable',
	'choices'			=> myself_pro_popular_destination_content_type(),
) );

// Event social icons number control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[popular_destination_count]', array(
	'default'          	=> $options['popular_destination_count'],
	'sanitize_callback' => 'myself_pro_sanitize_number_range',
	'validate_callback' => 'myself_pro_validate_popular_destination_count',
) );

$wp_customize->add_control( 'myself_pro_theme_options[popular_destination_count]', array(
	'label'             => esc_html__( 'Number of Posts', 'myself-pro' ),
	'description'       => esc_html__( 'Note: Min 3 & Max 9. Please input the valid number and save. Then refresh the page to see the change.', 'myself-pro' ),
	'section'           => 'myself_pro_popular_destination_section',
	'active_callback'   => 'myself_pro_is_popular_destination_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 3,
		'max'	=> 9,
		'style' => 'width: 100px;'
		),
) );

for ( $i=1; $i <= $options['popular_destination_count']; $i++ ) { 
	// popular_destination pages drop down chooser control and setting
	$wp_customize->add_setting( 'myself_pro_theme_options[popular_destination_content_page_' . $i . ']', array(
		'sanitize_callback' => 'myself_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Myself_Pro_Dropdown_Chooser( $wp_customize, 'myself_pro_theme_options[popular_destination_content_page_' . $i . ']', array(
		'label'             => sprintf ( esc_html__( 'Select Page %d', 'myself-pro' ), $i ),
		'section'           => 'myself_pro_popular_destination_section',
		'choices'			=> myself_pro_page_choices(),
		'active_callback'	=> 'myself_pro_is_popular_destination_section_content_page_enable',
	) ) );

	// popular_destination posts drop down chooser control and setting
	$wp_customize->add_setting( 'myself_pro_theme_options[popular_destination_content_post_' . $i . ']', array(
		'sanitize_callback' => 'myself_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Myself_Pro_Dropdown_Chooser( $wp_customize, 'myself_pro_theme_options[popular_destination_content_post_' . $i . ']', array(
		'label'             => sprintf ( esc_html__( 'Select posts %d', 'myself-pro' ), $i ),
		'section'           => 'myself_pro_popular_destination_section',
		'choices'			=> myself_pro_post_choices(),
		'active_callback'	=> 'myself_pro_is_popular_destination_section_content_post_enable',
	) ) );

	// popular_destination trips drop down chooser control and setting
	$wp_customize->add_setting( 'myself_pro_theme_options[popular_destination_content_trip_' . $i . ']', array(
		'sanitize_callback' => 'myself_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Myself_Pro_Dropdown_Chooser( $wp_customize, 'myself_pro_theme_options[popular_destination_content_trip_' . $i . ']', array(
		'label'             => sprintf ( esc_html__( 'Select Trip %d', 'myself-pro' ), $i ),
		'section'           => 'myself_pro_popular_destination_section',
		'choices'			=> myself_pro_trip_choices(),
		'active_callback'	=> 'myself_pro_is_popular_destination_section_content_trip_enable',
	) ) );
}

// Add dropdown category setting and control.
$wp_customize->add_setting(  'myself_pro_theme_options[popular_destination_content_category]', array(
	'sanitize_callback' => 'myself_pro_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Myself_Pro_Dropdown_Taxonomies_Control( $wp_customize,'myself_pro_theme_options[popular_destination_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'myself-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'myself-pro' ),
	'section'           => 'myself_pro_popular_destination_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'myself_pro_is_popular_destination_section_content_category_enable'
) ) );

// Add dropdown category setting and control.
$wp_customize->add_setting(  'myself_pro_theme_options[popular_destination_content_trip_types]', array(
	'sanitize_callback' => 'absint',
) ) ;

$wp_customize->add_control( new Myself_Pro_Dropdown_Taxonomies_Control( $wp_customize,'myself_pro_theme_options[popular_destination_content_trip_types]', array(
	'label'             => esc_html__( 'Select Trip Types', 'myself-pro' ),
	'section'           => 'myself_pro_popular_destination_section',
	'taxonomy'			=> 'itinerary_types',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'myself_pro_is_popular_destination_section_content_trip_types_enable'
) ) );

// Add dropdown category setting and control.
$wp_customize->add_setting(  'myself_pro_theme_options[popular_destination_content_activity]', array(
	'sanitize_callback' => 'absint',
) ) ;

$wp_customize->add_control( new Myself_Pro_Dropdown_Taxonomies_Control( $wp_customize,'myself_pro_theme_options[popular_destination_content_activity]', array(
	'label'             => esc_html__( 'Select Activities', 'myself-pro' ),
	'section'           => 'myself_pro_popular_destination_section',
	'taxonomy'			=> 'activity',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'myself_pro_is_popular_destination_section_content_activity_enable'
) ) );

// Add dropdown category setting and control.
$wp_customize->add_setting(  'myself_pro_theme_options[popular_destination_content_destination]', array(
	'sanitize_callback' => 'absint',
) ) ;

$wp_customize->add_control( new Myself_Pro_Dropdown_Taxonomies_Control( $wp_customize,'myself_pro_theme_options[popular_destination_content_destination]', array(
	'label'             => esc_html__( 'Select Destinations', 'myself-pro' ),
	'section'           => 'myself_pro_popular_destination_section',
	'taxonomy'			=> 'travel_locations',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'myself_pro_is_popular_destination_section_content_destination_enable'
) ) );

// popular destination read more setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[popular_destination_read_more]', array(
	'default'			=> $options['popular_destination_read_more'],
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'myself_pro_theme_options[popular_destination_read_more]', array(
	'label'           	=> esc_html__( 'Read More Text', 'myself-pro' ),
	'section'        	=> 'myself_pro_popular_destination_section',
	'active_callback' 	=> 'myself_pro_is_popular_destination_section_enable',
	'type'				=> 'text',
) );