<?php
/**
 * Popular Tours Section options
 *
 * @popular_tours Theme Palace
 * @subpopular_tours Myself Pro
 * @since Myself Pro 1.0.0
 */

// Add Popular Tours section
$wp_customize->add_section( 'myself_pro_popular_tours_section', array(
    'title'             => esc_html__( 'Popular Tours','myself-pro' ),
    'description'       => esc_html__( 'Popular Tours Section options.', 'myself-pro' ),
    'panel'             => 'myself_pro_front_page_panel',
) );

// Popular Tours content enable control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[popular_tours_section_enable]', array(
    'default'           =>  $options['popular_tours_section_enable'],
    'sanitize_callback' => 'myself_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Myself_Pro_Switch_Control( $wp_customize, 'myself_pro_theme_options[popular_tours_section_enable]', array(
    'label'             => esc_html__( 'Popular Tours Section Enable', 'myself-pro' ),
    'section'           => 'myself_pro_popular_tours_section',
    'on_off_label'      => myself_pro_switch_options(),
) ) );

// popular tour title setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[popular_tours_title]', array(
    'default'           => $options['popular_tours_title'],
    'sanitize_callback' => 'sanitize_text_field',
    'transport'         => 'postMessage',
) );

$wp_customize->add_control( 'myself_pro_theme_options[popular_tours_title]', array(
    'label'             => esc_html__( 'Title', 'myself-pro' ),
    'section'           => 'myself_pro_popular_tours_section',
    'active_callback'   => 'myself_pro_is_popular_tours_section_enable',
    'type'              => 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[popular_tours_title]', array(
        'selector'            => '#travel-tours-section h2.business-section-title',
        'settings'            => 'myself_pro_theme_options[popular_tours_title]',
        'container_inclusive' => false,
        'fallback_refresh'    => true,
        'render_callback'     => 'myself_pro_popular_tours_title_partial',
    ) );
}

// Popular Tours content type control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[popular_tours_content_type]', array(
    'default'           => $options['popular_tours_content_type'],
    'sanitize_callback' => 'myself_pro_sanitize_select',
) );

$wp_customize->add_control( 'myself_pro_theme_options[popular_tours_content_type]', array(
    'label'             => esc_html__( 'Content Type', 'myself-pro' ),
    'section'           => 'myself_pro_popular_tours_section',
    'type'              => 'select',
    'active_callback'   => 'myself_pro_is_popular_tours_section_enable',
    'choices'           => myself_pro_popular_tours_content_type(),
) );

// Event social icons number control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[popular_tours_count]', array(
    'default'           => $options['popular_tours_count'],
    'sanitize_callback' => 'myself_pro_sanitize_number_range',
    'validate_callback' => 'myself_pro_validate_popular_tours_count',
) );

$wp_customize->add_control( 'myself_pro_theme_options[popular_tours_count]', array(
    'label'             => esc_html__( 'Number of Posts', 'myself-pro' ),
    'description'       => esc_html__( 'Note: Min 3 & Max 9. Please input the valid number and save. Then refresh the page to see the change.', 'myself-pro' ),
    'section'           => 'myself_pro_popular_tours_section',
    'active_callback'   => 'myself_pro_is_popular_tours_section_enable',
    'type'              => 'number',
    'input_attrs'       => array(
        'min'   => 3,
        'max'   => 9,
        'style' => 'width: 100px;'
        ),
) );

for ( $i=1; $i <= $options['popular_tours_count']; $i++ ) { 
    // popular_tours pages drop down chooser control and setting
    $wp_customize->add_setting( 'myself_pro_theme_options[popular_tours_content_page_' . $i . ']', array(
        'sanitize_callback' => 'myself_pro_sanitize_page',
    ) );

    $wp_customize->add_control( new Myself_Pro_Dropdown_Chooser( $wp_customize, 'myself_pro_theme_options[popular_tours_content_page_' . $i . ']', array(
        'label'             => sprintf ( esc_html__( 'Select Page %d', 'myself-pro' ), $i ),
        'section'           => 'myself_pro_popular_tours_section',
        'choices'           => myself_pro_page_choices(),
        'active_callback'   => 'myself_pro_is_popular_tours_section_content_page_enable',
    ) ) );

    // popular_tours posts drop down chooser control and setting
    $wp_customize->add_setting( 'myself_pro_theme_options[popular_tours_content_post_' . $i . ']', array(
        'sanitize_callback' => 'myself_pro_sanitize_page',
    ) );

    $wp_customize->add_control( new Myself_Pro_Dropdown_Chooser( $wp_customize, 'myself_pro_theme_options[popular_tours_content_post_' . $i . ']', array(
        'label'             => sprintf ( esc_html__( 'Select posts %d', 'myself-pro' ), $i ),
        'section'           => 'myself_pro_popular_tours_section',
        'choices'           => myself_pro_post_choices(),
        'active_callback'   => 'myself_pro_is_popular_tours_section_content_post_enable',
    ) ) );

    // popular_tours trips drop down chooser control and setting
    $wp_customize->add_setting( 'myself_pro_theme_options[popular_tours_content_trip_' . $i . ']', array(
        'sanitize_callback' => 'myself_pro_sanitize_page',
    ) );

    $wp_customize->add_control( new Myself_Pro_Dropdown_Chooser( $wp_customize, 'myself_pro_theme_options[popular_tours_content_trip_' . $i . ']', array(
        'label'             => sprintf ( esc_html__( 'Select Trip %d', 'myself-pro' ), $i ),
        'section'           => 'myself_pro_popular_tours_section',
        'choices'           => myself_pro_trip_choices(),
        'active_callback'   => 'myself_pro_is_popular_tours_section_content_trip_enable',
    ) ) );
}

// Add dropdown category setting and control.
$wp_customize->add_setting(  'myself_pro_theme_options[popular_tours_content_category]', array(
    'sanitize_callback' => 'myself_pro_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Myself_Pro_Dropdown_Taxonomies_Control( $wp_customize,'myself_pro_theme_options[popular_tours_content_category]', array(
    'label'             => esc_html__( 'Select Category', 'myself-pro' ),
    'description'       => esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'myself-pro' ),
    'section'           => 'myself_pro_popular_tours_section',
    'type'              => 'dropdown-taxonomies',
    'active_callback'   => 'myself_pro_is_popular_tours_section_content_category_enable'
) ) );

// Add dropdown category setting and control.
$wp_customize->add_setting(  'myself_pro_theme_options[popular_tours_content_trip_types]', array(
    'sanitize_callback' => 'absint',
) ) ;

$wp_customize->add_control( new Myself_Pro_Dropdown_Taxonomies_Control( $wp_customize,'myself_pro_theme_options[popular_tours_content_trip_types]', array(
    'label'             => esc_html__( 'Select Trip Types', 'myself-pro' ),
    'section'           => 'myself_pro_popular_tours_section',
    'taxonomy'          => 'itinerary_types',
    'type'              => 'dropdown-taxonomies',
    'active_callback'   => 'myself_pro_is_popular_tours_section_content_trip_types_enable'
) ) );

// Add dropdown category setting and control.
$wp_customize->add_setting(  'myself_pro_theme_options[popular_tours_content_activity]', array(
    'sanitize_callback' => 'absint',
) ) ;

$wp_customize->add_control( new Myself_Pro_Dropdown_Taxonomies_Control( $wp_customize,'myself_pro_theme_options[popular_tours_content_activity]', array(
    'label'             => esc_html__( 'Select Activities', 'myself-pro' ),
    'section'           => 'myself_pro_popular_tours_section',
    'taxonomy'          => 'activity',
    'type'              => 'dropdown-taxonomies',
    'active_callback'   => 'myself_pro_is_popular_tours_section_content_activity_enable'
) ) );

// Add dropdown category setting and control.
$wp_customize->add_setting(  'myself_pro_theme_options[popular_tours_content_tours]', array(
    'sanitize_callback' => 'absint',
) ) ;

$wp_customize->add_control( new Myself_Pro_Dropdown_Taxonomies_Control( $wp_customize,'myself_pro_theme_options[popular_tours_content_tours]', array(
    'label'             => esc_html__( 'Select Tourss', 'myself-pro' ),
    'section'           => 'myself_pro_popular_tours_section',
    'taxonomy'          => 'travel_locations',
    'type'              => 'dropdown-taxonomies',
    'active_callback'   => 'myself_pro_is_popular_tours_section_content_tours_enable'
) ) );
