<?php
/**
 * Portfolio Section options
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */

// Add Portfolio section
$wp_customize->add_section( 'myself_pro_portfolio_section', array(
	'title'             => esc_html__( 'Main Portfolio','myself-pro' ),
	'description'       => esc_html__( 'Portfolio Section options.', 'myself-pro' ),
	'panel'             => 'myself_pro_front_page_panel',
) );

// Portfolio content enable control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[portfolio_section_enable]', array(
	'default'			=> 	$options['portfolio_section_enable'],
	'sanitize_callback' => 'myself_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Myself_Pro_Switch_Control( $wp_customize, 'myself_pro_theme_options[portfolio_section_enable]', array(
	'label'             => esc_html__( 'Portfolio Section Enable', 'myself-pro' ),
	'section'           => 'myself_pro_portfolio_section',
	'on_off_label' 		=> myself_pro_switch_options(),
) ) );

// Portfolio title setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[portfolio_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['portfolio_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'myself_pro_theme_options[portfolio_title]', array(
	'label'           	=> esc_html__( 'Portfolio Title', 'myself-pro' ),
	'section'        	=> 'myself_pro_portfolio_section',
	'active_callback' 	=> 'myself_pro_is_portfolio_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[portfolio_title]', array(
		'selector'            => '#my-portfolio .section-header h2.section-title',
		'settings'            => 'myself_pro_theme_options[portfolio_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'myself_pro_portfolio_title_partial',
    ) );
}

if($options['home_layout'] == 'third-design'){
			
	// portfolio description setting and control
	$wp_customize->add_setting( 'myself_pro_theme_options[portfolio_description]', array(
		'sanitize_callback' => 'wp_kses_post',
		'default'			=> $options['portfolio_description'],
		'transport'			=> 'postMessage',
	) );

	$wp_customize->add_control( 'myself_pro_theme_options[portfolio_description]', array(
		'label'           	=> esc_html__( 'Description', 'myself-pro' ),
		'section'        	=> 'myself_pro_portfolio_section',
		'active_callback' 	=> 'myself_pro_is_portfolio_section_enable',
		'type'				=> 'textarea',
	) );

	// Abort if selective refresh is not available.
	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[portfolio_description]', array(
			'selector'            => '#my-portfolio .business-section-header p',
			'settings'            => 'myself_pro_theme_options[portfolio_description]',
			'container_inclusive' => false,
			'fallback_refresh'    => true,
			'render_callback'     => 'myself_pro_portfolio_description_partial',
		) );
	}
}
// Event social icons number control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[portfolio_count]', array(
	'default'          	=> $options['portfolio_count'],
	'sanitize_callback' => 'myself_pro_sanitize_number_range',
	'validate_callback' => 'myself_pro_validate_portfolio_count',
) );

$wp_customize->add_control( 'myself_pro_theme_options[portfolio_count]', array(
	'label'             => esc_html__( 'Number of Portfolio', 'myself-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 12. Please input the valid number and save. Then refresh the page to see the change.', 'myself-pro' ),
	'section'           => 'myself_pro_portfolio_section',
	'active_callback'   => 'myself_pro_is_portfolio_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'max'	=> 12,
		'style' => 'width: 100px;'
		),
) );

// Portfolio content type control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[portfolio_content_type]', array(
	'default'          	=> $options['portfolio_content_type'],
	'sanitize_callback' => 'myself_pro_sanitize_select',
) );

$wp_customize->add_control( 'myself_pro_theme_options[portfolio_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'myself-pro' ),
	'section'           => 'myself_pro_portfolio_section',
	'type'				=> 'select',
	'active_callback' 	=> 'myself_pro_is_portfolio_section_enable',
	'choices'			=> myself_pro_portfolio_content_type(),
) );

for ( $i = 1; $i <= $options['portfolio_count']; $i++ ) :
	// portfolio pages drop down chooser control and setting
	$wp_customize->add_setting( 'myself_pro_theme_options[portfolio_content_page_' . $i . ']', array(
		'sanitize_callback' => 'myself_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Myself_Pro_Dropdown_Chooser( $wp_customize, 'myself_pro_theme_options[portfolio_content_page_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Page %d', 'myself-pro' ), $i ),
		'section'           => 'myself_pro_portfolio_section',
		'choices'			=> myself_pro_page_choices(),
		'active_callback'	=> 'myself_pro_is_portfolio_section_content_page_enable',
	) ) );

	// portfolio posts drop down chooser control and setting
	$wp_customize->add_setting( 'myself_pro_theme_options[portfolio_content_post_' . $i . ']', array(
		'sanitize_callback' => 'myself_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Myself_Pro_Dropdown_Chooser( $wp_customize, 'myself_pro_theme_options[portfolio_content_post_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Post %d', 'myself-pro' ), $i ),
		'section'           => 'myself_pro_portfolio_section',
		'choices'			=> myself_pro_post_choices(),
		'active_callback'	=> 'myself_pro_is_portfolio_section_content_post_enable',
	) ) );

	// portfolio trips drop down chooser control and setting
	$wp_customize->add_setting( 'myself_pro_theme_options[portfolio_content_trip_' . $i . ']', array(
		'sanitize_callback' => 'myself_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Myself_Pro_Dropdown_Chooser( $wp_customize, 'myself_pro_theme_options[portfolio_content_trip_' . $i . ']', array(
		'label'             => sprintf ( esc_html__( 'Select Trip %d', 'myself-pro' ), $i ),
		'section'           => 'myself_pro_portfolio_section',
		'choices'			=> myself_pro_trip_choices(),
		'active_callback'	=> 'myself_pro_is_portfolio_section_content_trip_enable',
	) ) );

endfor;

// Add dropdown category setting and control.
$wp_customize->add_setting(  'myself_pro_theme_options[portfolio_content_category]', array(
	'sanitize_callback' => 'myself_pro_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Myself_Pro_Dropdown_Taxonomies_Control( $wp_customize,'myself_pro_theme_options[portfolio_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'myself-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'myself-pro' ),
	'section'           => 'myself_pro_portfolio_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'myself_pro_is_portfolio_section_content_category_enable'
) ) );


// Add dropdown category setting and control.
$wp_customize->add_setting(  'myself_pro_theme_options[portfolio_content_trip_types]', array(
	'sanitize_callback' => 'absint',
) ) ;

$wp_customize->add_control( new Myself_Pro_Dropdown_Taxonomies_Control( $wp_customize,'myself_pro_theme_options[portfolio_content_trip_types]', array(
	'label'             => esc_html__( 'Select Trip Types', 'myself-pro' ),
	'section'           => 'myself_pro_portfolio_section',
	'taxonomy'			=> 'itinerary_types',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'myself_pro_is_portfolio_section_content_trip_types_enable'
) ) );

// Add dropdown category setting and control.
$wp_customize->add_setting(  'myself_pro_theme_options[portfolio_content_activity]', array(
	'sanitize_callback' => 'absint',
) ) ;

$wp_customize->add_control( new Myself_Pro_Dropdown_Taxonomies_Control( $wp_customize,'myself_pro_theme_options[portfolio_content_activity]', array(
	'label'             => esc_html__( 'Select Activities', 'myself-pro' ),
	'section'           => 'myself_pro_portfolio_section',
	'taxonomy'			=> 'activity',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'myself_pro_is_portfolio_section_content_activity_enable'
) ) );

// Add dropdown category setting and control.
$wp_customize->add_setting(  'myself_pro_theme_options[portfolio_content_destination]', array(
	'sanitize_callback' => 'absint',
) ) ;

$wp_customize->add_control( new Myself_Pro_Dropdown_Taxonomies_Control( $wp_customize,'myself_pro_theme_options[portfolio_content_destination]', array(
	'label'             => esc_html__( 'Select Destinations', 'myself-pro' ),
	'section'           => 'myself_pro_portfolio_section',
	'taxonomy'			=> 'travel_locations',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'myself_pro_is_portfolio_section_content_destination_enable'
) ) );

// Portfolio alt btn label setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[portfolio_btn_label]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['portfolio_btn_label'],
) );

$wp_customize->add_control( 'myself_pro_theme_options[portfolio_btn_label]', array(
	'label'           	=> esc_html__( 'Portfolio Button Label', 'myself-pro' ),
	'section'        	=> 'myself_pro_portfolio_section',
	'active_callback' 	=> 'myself_pro_is_portfolio_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[portfolio_btn_label]', array(
		'selector'            => '#my-portfolio .read-more a.btn',
		'settings'            => 'myself_pro_theme_options[portfolio_btn_label]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'myself_pro_portfolio_btn_label_partial',
    ) );
}

// Portfolio alt btn url setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[portfolio_btn_url]', array(
	'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( 'myself_pro_theme_options[portfolio_btn_url]', array(
	'label'           	=> esc_html__( 'Portfolio Button Url', 'myself-pro' ),
	'section'        	=> 'myself_pro_portfolio_section',
	'active_callback' 	=> 'myself_pro_is_portfolio_section_enable',
	'type'				=> 'url',
) );