<?php
/**
 * Service Section options
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */

// Add Service section
$wp_customize->add_section( 'myself_pro_service_section', array(
	'title'             => esc_html__( 'Services','myself-pro' ),
	'description'       => esc_html__( 'Services Section options.', 'myself-pro' ),
	'panel'             => 'myself_pro_front_page_panel',
) );

// Service content enable control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[service_section_enable]', array(
	'default'			=> 	$options['service_section_enable'],
	'sanitize_callback' => 'myself_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Myself_Pro_Switch_Control( $wp_customize, 'myself_pro_theme_options[service_section_enable]', array(
	'label'             => esc_html__( 'Service Section Enable', 'myself-pro' ),
	'section'           => 'myself_pro_service_section',
	'on_off_label' 		=> myself_pro_switch_options(),
) ) );

// service title setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[service_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['service_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'myself_pro_theme_options[service_title]', array(
	'label'           	=> esc_html__( 'Title', 'myself-pro' ),
	'section'        	=> 'myself_pro_service_section',
	'active_callback' 	=> 'myself_pro_is_service_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[service_title]', array(
		'selector'            => '#my-services .section-header h2.section-title',
		'settings'            => 'myself_pro_theme_options[service_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'myself_pro_service_title_partial',
    ) );
}

// Event social icons number control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[service_count]', array(
	'default'          	=> $options['service_count'],
	'sanitize_callback' => 'myself_pro_sanitize_number_range',
	'validate_callback' => 'myself_pro_validate_service_count',
) );

$wp_customize->add_control( 'myself_pro_theme_options[service_count]', array(
	'label'             => esc_html__( 'Number of Services', 'myself-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 6. Please input the valid number and save. Then refresh the page to see the change.', 'myself-pro' ),
	'section'           => 'myself_pro_service_section',
	'active_callback'   => 'myself_pro_is_service_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'max'	=> 6,
		'style' => 'width: 100px;'
		),
) );

for ( $i = 1; $i <= $options['service_count']; $i++ ) :

	// Add dropdown category setting and control.
	$wp_customize->add_setting(  'myself_pro_theme_options[service_content_category_' . $i . ']', array(
		'sanitize_callback' => 'myself_pro_sanitize_single_category',
	) ) ;

	$wp_customize->add_control( new Myself_Pro_Dropdown_Taxonomies_Control( $wp_customize,'myself_pro_theme_options[service_content_category_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Category %d', 'myself-pro' ), $i ),
		'description'      	=> esc_html__( 'Note: Latest four posts will be shown from selected category.', 'myself-pro' ),
		'section'           => 'myself_pro_service_section',
		'type'              => 'dropdown-taxonomies',
		'active_callback'	=> 'myself_pro_is_service_section_enable'
	) ) );

	for ( $c = 1; $c <= 4; $c++ ) :
		// service note control and setting
		$wp_customize->add_setting( 'myself_pro_theme_options[service_content_icon_' . $i . '_' . $c . ']', array(
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( new Myself_Pro_Icon_Picker( $wp_customize, 'myself_pro_theme_options[service_content_icon_' . $i . '_' . $c . ']', array(
			'label'             => sprintf( esc_html__( 'Select Icon %d', 'myself-pro' ), $c ),
			'section'           => 'myself_pro_service_section',
			'active_callback'	=> 'myself_pro_is_service_section_enable',
		) ) );
	endfor;

	// service hr setting and control
	$wp_customize->add_setting( 'myself_pro_theme_options[service_hr_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new Myself_Pro_Customize_Horizontal_Line( $wp_customize, 'myself_pro_theme_options[service_hr_'. $i .']',
		array(
			'section'         => 'myself_pro_service_section',
			'active_callback' => 'myself_pro_is_service_section_enable',
			'type'			  => 'hr'
	) ) );
endfor;
