<?php
/**
 * Skills Section options
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */

// Add Skills section
$wp_customize->add_section( 'myself_pro_skills_section', array(
	'title'             => esc_html__( 'Skills','myself-pro' ),
	'description'       => esc_html__( 'Skills Section options.', 'myself-pro' ),
	'panel'             => 'myself_pro_front_page_panel',
) );

// Skills content enable control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[skills_section_enable]', array(
	'default'			=> 	$options['skills_section_enable'],
	'sanitize_callback' => 'myself_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Myself_Pro_Switch_Control( $wp_customize, 'myself_pro_theme_options[skills_section_enable]', array(
	'label'             => esc_html__( 'Skills Section Enable', 'myself-pro' ),
	'section'           => 'myself_pro_skills_section',
	'on_off_label' 		=> myself_pro_switch_options(),
) ) );

// skills image setting and control.
$wp_customize->add_setting( 'myself_pro_theme_options[skills_image]', array(
	'sanitize_callback' => 'myself_pro_sanitize_image'
) );

$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'myself_pro_theme_options[skills_image]',
		array(
		'label'       		=> esc_html__( 'Background Image', 'myself-pro' ),
		'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'myself-pro' ), 1920, 1200 ),
		'section'     		=> 'myself_pro_skills_section',
		'active_callback'	=> 'myself_pro_is_skills_section_enable',
) ) );

// Skills content type control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[skills_content_type]', array(
	'default'          	=> $options['skills_content_type'],
	'sanitize_callback' => 'myself_pro_sanitize_select',
) );

$wp_customize->add_control( 'myself_pro_theme_options[skills_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'myself-pro' ),
	'section'           => 'myself_pro_skills_section',
	'type'				=> 'select',
	'active_callback' 	=> 'myself_pro_is_skills_section_enable',
	'choices'			=> array( 
		'page' 		=> esc_html__( 'Page', 'myself-pro' ),
		'post' 		=> esc_html__( 'Post', 'myself-pro' ),
		'custom' 	=> esc_html__( 'Custom', 'myself-pro' ),
	),
) );

// skills pages drop down chooser control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[skills_content_page]', array(
	'sanitize_callback' => 'myself_pro_sanitize_page',
) );

$wp_customize->add_control( new Myself_Pro_Dropdown_Chooser( $wp_customize, 'myself_pro_theme_options[skills_content_page]', array(
	'label'             => esc_html__( 'Select Page', 'myself-pro' ),
	'section'           => 'myself_pro_skills_section',
	'choices'			=> myself_pro_page_choices(),
	'active_callback'	=> 'myself_pro_is_skills_section_content_page_enable',
) ) );

// skills posts drop down chooser control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[skills_content_post]', array(
	'sanitize_callback' => 'myself_pro_sanitize_page',
) );

$wp_customize->add_control( new Myself_Pro_Dropdown_Chooser( $wp_customize, 'myself_pro_theme_options[skills_content_post]', array(
	'label'             => esc_html__( 'Select Post', 'myself-pro' ),
	'section'           => 'myself_pro_skills_section',
	'choices'			=> myself_pro_post_choices(),
	'active_callback'	=> 'myself_pro_is_skills_section_content_post_enable',
) ) );

// skills title setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[skills_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['skills_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'myself_pro_theme_options[skills_title]', array(
	'label'           	=> esc_html__( 'Title', 'myself-pro' ),
	'section'        	=> 'myself_pro_skills_section',
	'active_callback' 	=> 'myself_pro_is_skills_section_content_custom_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[skills_title]', array(
		'selector'            => '#my-skills .hentry .section-header h2.section-title',
		'settings'            => 'myself_pro_theme_options[skills_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'myself_pro_skills_title_partial',
    ) );
}

// skills description setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[skills_description]', array(
	'sanitize_callback' => 'wp_kses_post',
	'default'			=> $options['skills_description'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'myself_pro_theme_options[skills_description]', array(
	'label'           	=> esc_html__( 'Description', 'myself-pro' ),
	'section'        	=> 'myself_pro_skills_section',
	'active_callback' 	=> 'myself_pro_is_skills_section_content_custom_enable',
	'type'				=> 'textarea',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[skills_description]', array(
		'selector'            => '#my-skills .hentry .section-content p',
		'settings'            => 'myself_pro_theme_options[skills_description]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'myself_pro_skills_description_partial',
    ) );
}

// skills btn title setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[skills_btn_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['skills_btn_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'myself_pro_theme_options[skills_btn_title]', array(
	'label'           	=> esc_html__( 'Button Label', 'myself-pro' ),
	'section'        	=> 'myself_pro_skills_section',
	'active_callback' 	=> 'myself_pro_is_skills_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[skills_btn_title]', array(
		'selector'            => '#my-skills .read-more a.btn',
		'settings'            => 'myself_pro_theme_options[skills_btn_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'myself_pro_skills_btn_title_partial',
    ) );
}

// skills btn link setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[skills_btn_link]', array(
	'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( 'myself_pro_theme_options[skills_btn_link]', array(
	'label'           	=> esc_html__( 'Button Link', 'myself-pro' ),
	'section'        	=> 'myself_pro_skills_section',
	'active_callback' 	=> 'myself_pro_is_skills_section_content_custom_enable',
	'type'				=> 'url',
) );

// skills bar shortcode setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[skills_shortcode]', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'myself_pro_theme_options[skills_shortcode]', array(
	'label'           	=> esc_html__( 'Shortcode', 'myself-pro' ),
	'description'       => esc_html__( 'Note: Please install TP PieBuilder and use the Horizontal Bar Graph shortcode.', 'myself-pro' ),
	'section'        	=> 'myself_pro_skills_section',
	'active_callback' 	=> 'myself_pro_is_skills_section_enable',
	'type'				=> 'text',
) );