<?php
/**
 * Subscription Section options
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */

// Add Subscription section
$wp_customize->add_section( 'myself_pro_subscription_section', array(
  'title'             => esc_html__( 'Subscription','myself-pro' ),
  'description'       => esc_html__( 'Note: To activate this section you need to install Jetpack Plugin and activate subscription module.', 'myself-pro' ),
  'panel'             => 'myself_pro_front_page_panel',
) );

// Subscription content enable control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[subscription_section_enable]', array(
  'default'     =>  $options['subscription_section_enable'],
  'sanitize_callback' => 'myself_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Myself_Pro_Switch_Control( $wp_customize, 'myself_pro_theme_options[subscription_section_enable]', array(
  'label'             => esc_html__( 'Subscription Section Enable', 'myself-pro' ),
  'section'           => 'myself_pro_subscription_section',
  'on_off_label'    => myself_pro_switch_options(),
) ) );

// subscription sub title setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[subscription_sub_title]', array(
  'sanitize_callback' => 'sanitize_text_field',
  'default'     => $options['subscription_sub_title'],
  'transport'     => 'postMessage',
) );

$wp_customize->add_control( 'myself_pro_theme_options[subscription_sub_title]', array(
  'label'             => esc_html__( 'Sub Title', 'myself-pro' ),
  'section'         => 'myself_pro_subscription_section',
  'active_callback'   => 'myself_pro_subscription_section_enable',
  'type'        => 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[subscription_sub_title]', array(
    'selector'            => '#business-subscribe-us .wrapper p.subtitle',
    'settings'            => 'myself_pro_theme_options[subscription_sub_title]',
    'container_inclusive' => false,
    'fallback_refresh'    => true,
    'render_callback'     => 'myself_pro_subscription_sub_title_partial',
    ) );
}

// subscription title setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[subscription_title]', array(
  'sanitize_callback' => 'sanitize_text_field',
  'default'     => $options['subscription_title'],
  'transport'     => 'postMessage',
) );

$wp_customize->add_control( 'myself_pro_theme_options[subscription_title]', array(
  'label'             => esc_html__( 'Title', 'myself-pro' ),
  'section'         => 'myself_pro_subscription_section',
  'active_callback'   => 'myself_pro_subscription_section_enable',
  'type'        => 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[subscription_title]', array(
    'selector'            => '#business-subscribe-us .wrapper h3.widget-title',
    'settings'            => 'myself_pro_theme_options[subscription_title]',
    'container_inclusive' => false,
    'fallback_refresh'    => true,
    'render_callback'     => 'myself_pro_subscription_title_partial',
    ) );
}
// subscription  background image setting and control.
$wp_customize->add_setting( 'myself_pro_theme_options[subscription_bg_image]', array(
  'sanitize_callback' => 'myself_pro_sanitize_image'
) );

$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'myself_pro_theme_options[subscription_bg_image]',
    array(
    'label'           => esc_html__( 'subscription Background Image', 'myself-pro'),
    'description'     => sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'myself-pro' ), 1920, 600 ),
    'section'         => 'myself_pro_subscription_section',
    'active_callback' => 'myself_pro_subscription_section_enable',
) ) );

// subscription description setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[subscription_description]', array(
  'sanitize_callback' => 'wp_kses_post',
) );

$wp_customize->add_control( 'myself_pro_theme_options[subscription_description]', array(
  'label'             => esc_html__( 'Description', 'myself-pro' ),
  'section'         => 'myself_pro_subscription_section',
  'active_callback'   => 'myself_pro_subscription_section_enable',
  'type'        => 'textarea',
) );

// subscription btn title setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[subscription_btn_title]', array(
  'sanitize_callback' => 'sanitize_text_field',
  'default'     => $options['subscription_btn_title'],
) );

$wp_customize->add_control( 'myself_pro_theme_options[subscription_btn_title]', array(
  'label'             => esc_html__( 'Button Label', 'myself-pro' ),
  'section'         => 'myself_pro_subscription_section',
  'active_callback'   => 'myself_pro_subscription_section_enable',
  'type'        => 'text',
) );

