<?php
/**
 * Team Section options
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */

// Add Team section
$wp_customize->add_section( 'myself_pro_team_section', array(
	'title'             => esc_html__( 'Team','myself-pro' ),
	'description'       => esc_html__( 'Team Section options.', 'myself-pro' ),
	'panel'             => 'myself_pro_front_page_panel',
) );

// Team content enable control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[team_section_enable]', array(
	'default'			=> 	$options['team_section_enable'],
	'sanitize_callback' => 'myself_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Myself_Pro_Switch_Control( $wp_customize, 'myself_pro_theme_options[team_section_enable]', array(
	'label'             => esc_html__( 'Team Section Enable', 'myself-pro' ),
	'section'           => 'myself_pro_team_section',
	'on_off_label' 		=> myself_pro_switch_options(),
) ) );

// team title setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[team_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['team_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'myself_pro_theme_options[team_title]', array(
	'label'           	=> esc_html__( 'Title', 'myself-pro' ),
	'section'        	=> 'myself_pro_team_section',
	'active_callback' 	=> 'myself_pro_is_team_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[team_title]', array(
		'selector'            => '#business-team h2.business-section-title',
		'settings'            => 'myself_pro_theme_options[team_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'myself_pro_team_title_partial',
    ) );
}

if($options['home_layout'] != 'eight-design'){

	// team sub title
	$wp_customize->add_setting( 'myself_pro_theme_options[team_sub_title]', array(
		'default'          	=> $options['team_sub_title'],
		'sanitize_callback' => 'sanitize_textarea_field',
		'transport'			=> 'postMessage',
	) );
	
	$wp_customize->add_control( 'myself_pro_theme_options[team_sub_title]', array(
		'label'             => esc_html__( 'Sub title', 'myself-pro' ),
		'section'           => 'myself_pro_team_section',
		'active_callback'	=> 'myself_pro_is_team_section_enable',
		'type'				=> 'textarea',
	) );
	
	// Abort if selective refresh is not available.
	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[team_sub_title]', array(
			'selector'            => '#business-team p.business-section-subtitle',
			'settings'            => 'myself_pro_theme_options[team_sub_title]',
			'container_inclusive' => false,
			'fallback_refresh'    => true,
			'render_callback'     => 'myself_pro_team_sub_title_partial',
		) );
	}
}

// Blog column layout control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[team_column]', array(
	'default'          	=> $options['team_column'],
	'sanitize_callback' => 'myself_pro_sanitize_select',
	) );

$wp_customize->add_control( 'myself_pro_theme_options[team_column]', array(
	'label'             => esc_html__( 'Column Layout', 'myself-pro' ),
	'section'           => 'myself_pro_team_section',
	'type'				=> 'select',
	'active_callback' 	=> 'myself_pro_is_team_section_enable',
	'choices'			=> array( 
		'col-3'		=> esc_html__( 'Three Column', 'myself-pro' ),
		'col-4'		=> esc_html__( 'Four Column', 'myself-pro' ),
		),
	) );

// Team content type control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[team_content_type]', array(
	'default'          	=> $options['team_content_type'],
	'sanitize_callback' => 'myself_pro_sanitize_select',
) );

$wp_customize->add_control( 'myself_pro_theme_options[team_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'myself-pro' ),
	'section'           => 'myself_pro_team_section',
	'type'				=> 'select',
	'active_callback' 	=> 'myself_pro_is_team_section_enable',
	'choices'			=> array( 
		'page' 		=> esc_html__( 'Page', 'myself-pro' ),
		'post' 		=> esc_html__( 'Post', 'myself-pro' ),
		'category' 	=> esc_html__( 'Category', 'myself-pro' ),
	),
) );

// Event social icons number control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[team_count]', array(
	'default'          	=> $options['team_count'],
	'sanitize_callback' => 'myself_pro_sanitize_number_range',
	'validate_callback' => 'myself_pro_validate_team_count',
) );

$wp_customize->add_control( 'myself_pro_theme_options[team_count]', array(
	'label'             => esc_html__( 'Number of Teams', 'myself-pro' ),
	'description'       => esc_html__( 'Note: Min 4 & Max 8. Please input the valid number and save. Then refresh the page to see the change.', 'myself-pro' ),
	'section'           => 'myself_pro_team_section',
	'active_callback'   => 'myself_pro_is_team_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 4,
		'max'	=> 8,
		'style' => 'width: 100px;'
		),
) );

for ( $i = 1; $i <= $options['team_count']; $i++ ) :

	// team pages drop down chooser control and setting
	$wp_customize->add_setting( 'myself_pro_theme_options[team_content_page_' . $i . ']', array(
		'sanitize_callback' => 'myself_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Myself_Pro_Dropdown_Chooser( $wp_customize, 'myself_pro_theme_options[team_content_page_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Page %d', 'myself-pro' ), $i ),
		'section'           => 'myself_pro_team_section',
		'choices'			=> myself_pro_page_choices(),
		'active_callback'	=> 'myself_pro_is_team_section_content_page_enable',
	) ) );

	// team posts drop down chooser control and setting
	$wp_customize->add_setting( 'myself_pro_theme_options[team_content_post_' . $i . ']', array(
		'sanitize_callback' => 'myself_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Myself_Pro_Dropdown_Chooser( $wp_customize, 'myself_pro_theme_options[team_content_post_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Post %d', 'myself-pro' ), $i ),
		'section'           => 'myself_pro_team_section',
		'choices'			=> myself_pro_post_choices(),
		'active_callback'	=> 'myself_pro_is_team_section_content_post_enable',
	) ) );

	// team custom content
	$wp_customize->add_setting( 'myself_pro_theme_options[team_content_custom_position_' . $i . ']', array(
		'sanitize_callback' => 'wp_kses_post',
	) );

	$wp_customize->add_control( 'myself_pro_theme_options[team_content_custom_position_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Position %d', 'myself-pro' ), $i ),
		'section'           => 'myself_pro_team_section',
		'active_callback'	=> 'myself_pro_is_team_section_enable',
	) );

	// team social
	$wp_customize->add_setting( 'myself_pro_theme_options[team_social_' . $i. ']', array(
		'sanitize_callback' => 'esc_url_raw',
	) );

	$wp_customize->add_control( new Myself_Pro_Multi_Input_Custom_Control( $wp_customize, 'myself_pro_theme_options[team_social_' . $i. ']', array(
		'label'             => esc_html__( 'Social ', 'myself-pro' ),
		'button_text'       => esc_html__( 'Add social.', 'myself-pro' ),
		'section'           => 'myself_pro_team_section',
		'active_callback' 	=> 'myself_pro_is_team_section_enable',
	) ) );
	
endfor;

// Add dropdown category setting and control.
$wp_customize->add_setting(  'myself_pro_theme_options[team_content_category]', array(
	'sanitize_callback' => 'myself_pro_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Myself_Pro_Dropdown_Taxonomies_Control( $wp_customize,'myself_pro_theme_options[team_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'myself-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'myself-pro' ),
	'section'           => 'myself_pro_team_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'myself_pro_is_team_section_content_category_enable'
) ) );
