<?php
/**
 * Testimonial Section options
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */

// Add Testimonial section
$wp_customize->add_section( 'myself_pro_testimonial_section', array(
	'title'             => esc_html__( 'Testimonial','myself-pro' ),
	'description'       => esc_html__( 'Testimonial Section options.', 'myself-pro' ),
	'panel'             => 'myself_pro_front_page_panel',
) );

// Testimonial content enable control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[testimonial_section_enable]', array(
	'default'			=> 	$options['testimonial_section_enable'],
	'sanitize_callback' => 'myself_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Myself_Pro_Switch_Control( $wp_customize, 'myself_pro_theme_options[testimonial_section_enable]', array(
	'label'             => esc_html__( 'Testimonial Section Enable', 'myself-pro' ),
	'section'           => 'myself_pro_testimonial_section',
	'on_off_label' 		=> myself_pro_switch_options(),
) ) );

// testimonial title setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[testimonial_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['testimonial_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'myself_pro_theme_options[testimonial_title]', array(
	'label'           	=> esc_html__( 'Title', 'myself-pro' ),
	'section'        	=> 'myself_pro_testimonial_section',
	'active_callback' 	=> 'myself_pro_is_testimonial_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[testimonial_title]', array(
		'selector'            => '#testimonial-slider-section .section-header h2.section-title',
		'settings'            => 'myself_pro_theme_options[testimonial_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'myself_pro_testimonial_title_partial',
    ) );
}

// Event social icons number control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[testimonial_count]', array(
	'default'          	=> $options['testimonial_count'],
	'sanitize_callback' => 'myself_pro_sanitize_number_range',
	'validate_callback' => 'myself_pro_validate_testimonial_count',
) );

$wp_customize->add_control( 'myself_pro_theme_options[testimonial_count]', array(
	'label'             => esc_html__( 'Number of Testimonials', 'myself-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 10. Please input the valid number and save. Then refresh the page to see the change.', 'myself-pro' ),
	'section'           => 'myself_pro_testimonial_section',
	'active_callback'   => 'myself_pro_is_testimonial_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'max'	=> 10,
		'style' => 'width: 100px;'
		),
) );

// Testimonial content type control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[testimonial_content_type]', array(
	'default'          	=> $options['testimonial_content_type'],
	'sanitize_callback' => 'myself_pro_sanitize_select',
) );

$wp_customize->add_control( 'myself_pro_theme_options[testimonial_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'myself-pro' ),
	'section'           => 'myself_pro_testimonial_section',
	'type'				=> 'select',
	'active_callback' 	=> 'myself_pro_is_testimonial_section_enable',
	'choices'			=> array( 
		'page' 		=> esc_html__( 'Page', 'myself-pro' ),
		'post' 		=> esc_html__( 'Post', 'myself-pro' ),
		'category' 	=> esc_html__( 'Category', 'myself-pro' ),
		'custom' 	=> esc_html__( 'Custom', 'myself-pro' ),
	),
) );

// Add dropdown category setting and control.
$wp_customize->add_setting(  'myself_pro_theme_options[testimonial_content_category]', array(
	'sanitize_callback' => 'myself_pro_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Myself_Pro_Dropdown_Taxonomies_Control( $wp_customize,'myself_pro_theme_options[testimonial_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'myself-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'myself-pro' ),
	'section'           => 'myself_pro_testimonial_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'myself_pro_is_testimonial_section_content_category_enable'
) ) );

for ( $i = 1; $i <= $options['testimonial_count']; $i++ ) :
	// testimonial pages drop down chooser control and setting
	$wp_customize->add_setting( 'myself_pro_theme_options[testimonial_content_page_' . $i . ']', array(
		'sanitize_callback' => 'myself_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Myself_Pro_Dropdown_Chooser( $wp_customize, 'myself_pro_theme_options[testimonial_content_page_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Page %d', 'myself-pro' ), $i ),
		'section'           => 'myself_pro_testimonial_section',
		'choices'			=> myself_pro_page_choices(),
		'active_callback'	=> 'myself_pro_is_testimonial_section_content_page_enable',
	) ) );

	// testimonial posts drop down chooser control and setting
	$wp_customize->add_setting( 'myself_pro_theme_options[testimonial_content_post_' . $i . ']', array(
		'sanitize_callback' => 'myself_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Myself_Pro_Dropdown_Chooser( $wp_customize, 'myself_pro_theme_options[testimonial_content_post_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Post %d', 'myself-pro' ), $i ),
		'section'           => 'myself_pro_testimonial_section',
		'choices'			=> myself_pro_post_choices(),
		'active_callback'	=> 'myself_pro_is_testimonial_section_content_post_enable',
	) ) );

	// testimonial title setting and control
	$wp_customize->add_setting( 'myself_pro_theme_options[testimonial_title_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'myself_pro_theme_options[testimonial_title_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Title %d', 'myself-pro' ), $i ),
		'section'        	=> 'myself_pro_testimonial_section',
		'active_callback' 	=> 'myself_pro_is_testimonial_section_content_custom_enable',
		'type'				=> 'text',
	) );

	// testimonial position setting and control
	$wp_customize->add_setting( 'myself_pro_theme_options[testimonial_position_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'myself_pro_theme_options[testimonial_position_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Position %d', 'myself-pro' ), $i ),
		'section'        	=> 'myself_pro_testimonial_section',
		'active_callback' 	=> 'myself_pro_is_testimonial_section_content_position_enable',
		'type'				=> 'text',
	) );

	// testimonial description setting and control
	$wp_customize->add_setting( 'myself_pro_theme_options[testimonial_description_' . $i . ']', array(
		'sanitize_callback' => 'wp_kses_post',
	) );

	$wp_customize->add_control( 'myself_pro_theme_options[testimonial_description_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Description %d', 'myself-pro' ), $i ),
		'section'        	=> 'myself_pro_testimonial_section',
		'active_callback' 	=> 'myself_pro_is_testimonial_section_content_custom_enable',
		'type'				=> 'textarea',
	) );

	// testimonial image setting and control.
	$wp_customize->add_setting( 'myself_pro_theme_options[testimonial_image_' . $i . ']', array(
		'sanitize_callback' => 'myself_pro_sanitize_image'
	) );

	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'myself_pro_theme_options[testimonial_image_' . $i . ']',
			array(
			'label'       		=> sprintf( esc_html__( 'Image %d', 'myself-pro' ), $i ),
			'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'myself-pro' ), 200, 200 ),
			'section'     		=> 'myself_pro_testimonial_section',
			'active_callback'	=> 'myself_pro_is_testimonial_section_content_custom_enable',
	) ) );

	// testimonial position setting and control
	$wp_customize->add_setting( 'myself_pro_theme_options[testimonial_link_' . $i . ']', array(
		'sanitize_callback' => 'esc_url_raw',
	) );

	$wp_customize->add_control( 'myself_pro_theme_options[testimonial_link_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'URL Link %d', 'myself-pro' ), $i ),
		'section'        	=> 'myself_pro_testimonial_section',
		'active_callback' 	=> 'myself_pro_is_testimonial_section_content_custom_enable',
		'type'				=> 'url',
	) );

	// testimonial hr setting and control
	$wp_customize->add_setting( 'myself_pro_theme_options[testimonial_hr_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new Myself_Pro_Customize_Horizontal_Line( $wp_customize, 'myself_pro_theme_options[testimonial_hr_'. $i .']',
		array(
			'section'         => 'myself_pro_testimonial_section',
			'active_callback' => 'myself_pro_is_testimonial_section_content_seperator_enable',
			'type'			  => 'hr'
	) ) );
endfor;

