<?php
/**
 * Topbar Section options
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */

// Add Topbar section
$wp_customize->add_section( 'myself_pro_topbar_section', array(
	'title'             => esc_html__( 'Header Meta','myself-pro' ),
	'description'       => esc_html__( 'Header Meta options.', 'myself-pro' ),
	'panel'             => 'myself_pro_front_page_panel',
) );

// top bar menu visible
$wp_customize->add_setting( 'myself_pro_theme_options[topbar_social_enable]',
	array(
		'default'       	=> $options['topbar_social_enable'],
		'sanitize_callback' => 'myself_pro_sanitize_switch_control',
	)
);
$wp_customize->add_control( new Myself_Pro_Switch_Control( $wp_customize, 'myself_pro_theme_options[topbar_social_enable]',
    array(
		'label'      		=> esc_html__( 'Display Social Menu', 'myself-pro' ),
		'description'       => sprintf( '%1$s <a class="topbar-menu-trigger" href="#"> %2$s </a> %3$s', esc_html__( 'Note: To show topbar menu.', 'myself-pro' ), esc_html__( 'Click Here', 'myself-pro' ), esc_html__( 'to create menu', 'myself-pro' ) ),
		'section'    		=> 'myself_pro_topbar_section',
		'on_off_label' 		=> myself_pro_switch_options(),
    )
) );
