<?php
/**
 * Video Section options
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */

// Add Video section
$wp_customize->add_section( 'myself_pro_video_section', array(
	'title'             => esc_html__( 'Video','myself-pro' ),
	'description'       => esc_html__( 'Video Section options.', 'myself-pro' ),
	'panel'             => 'myself_pro_front_page_panel',
) );

// Video content enable control and setting
$wp_customize->add_setting( 'myself_pro_theme_options[video_section_enable]', array(
	'default'			=> 	$options['video_section_enable'],
	'sanitize_callback' => 'myself_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Myself_Pro_Switch_Control( $wp_customize, 'myself_pro_theme_options[video_section_enable]', array(
	'label'             => esc_html__( 'Video Section Enable', 'myself-pro' ),
	'section'           => 'myself_pro_video_section',
	'on_off_label' 		=> myself_pro_switch_options(),
) ) );

// video title setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[video_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['video_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'myself_pro_theme_options[video_title]', array(
	'label'           	=> esc_html__( 'Title', 'myself-pro' ),
	'section'        	=> 'myself_pro_video_section',
	'active_callback' 	=> 'myself_pro_is_video_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[video_title]', array(
		'selector'            => '#my-video .section-header h2.section-title',
		'settings'            => 'myself_pro_theme_options[video_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'myself_pro_video_title_partial',
    ) );
}

// video description setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[video_description]', array(
	'sanitize_callback' => 'wp_kses_post',
	'default'			=> $options['video_description'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'myself_pro_theme_options[video_description]', array(
	'label'           	=> esc_html__( 'Description', 'myself-pro' ),
	'section'        	=> 'myself_pro_video_section',
	'active_callback' 	=> 'myself_pro_is_video_section_enable',
	'type'				=> 'textarea',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'myself_pro_theme_options[video_description]', array(
		'selector'            => '#my-video .section-content p',
		'settings'            => 'myself_pro_theme_options[video_description]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'myself_pro_video_description_partial',
    ) );
}

// video url setting and control
$wp_customize->add_setting( 'myself_pro_theme_options[video_url]', array(
	'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( 'myself_pro_theme_options[video_url]', array(
	'label'           	=> esc_html__( 'Video Url', 'myself-pro' ),
	'description'       => esc_html__( 'Note: Input video url from youtube or media library.', 'myself-pro' ),
	'section'        	=> 'myself_pro_video_section',
	'active_callback' 	=> 'myself_pro_is_video_section_enable',
	'type'				=> 'url',
) );
