<?php
/**
 * Layout options
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */

// Add sidebar section
$wp_customize->add_section( 'myself_pro_layout', array(
	'title'               => esc_html__('Layout','myself-pro'),
	'description'         => esc_html__( 'Layout section options.', 'myself-pro' ),
	'panel'               => 'myself_pro_theme_options_panel',
) );

// Site layout setting and control.
$wp_customize->add_setting( 'myself_pro_theme_options[site_layout]', array(
	'sanitize_callback'   => 'myself_pro_sanitize_select',
	'default'             => $options['site_layout'],
) );

$wp_customize->add_control(  new Myself_Pro_Custom_Radio_Image_Control ( $wp_customize, 'myself_pro_theme_options[site_layout]', array(
	'label'               => esc_html__( 'Site Layout', 'myself-pro' ),
	'section'             => 'myself_pro_layout',
	'choices'			  => myself_pro_site_layout(),
) ) );

// Sidebar position setting and control.
$wp_customize->add_setting( 'myself_pro_theme_options[sidebar_position]', array(
	'sanitize_callback'   => 'myself_pro_sanitize_select',
	'default'             => $options['sidebar_position'],
) );

$wp_customize->add_control(  new Myself_Pro_Custom_Radio_Image_Control ( $wp_customize, 'myself_pro_theme_options[sidebar_position]', array(
	'label'               => esc_html__( 'Global Sidebar Position', 'myself-pro' ),
	'section'             => 'myself_pro_layout',
	'choices'			  => myself_pro_global_sidebar_position(),
) ) );

// Post sidebar position setting and control.
$wp_customize->add_setting( 'myself_pro_theme_options[post_sidebar_position]', array(
	'sanitize_callback'   => 'myself_pro_sanitize_select',
	'default'             => $options['post_sidebar_position'],
) );

$wp_customize->add_control(  new Myself_Pro_Custom_Radio_Image_Control ( $wp_customize, 'myself_pro_theme_options[post_sidebar_position]', array(
	'label'               => esc_html__( 'Posts Sidebar Position', 'myself-pro' ),
	'section'             => 'myself_pro_layout',
	'choices'			  => myself_pro_sidebar_position(),
) ) );

// Post sidebar position setting and control.
$wp_customize->add_setting( 'myself_pro_theme_options[page_sidebar_position]', array(
	'sanitize_callback'   => 'myself_pro_sanitize_select',
	'default'             => $options['page_sidebar_position'],
) );

$wp_customize->add_control( new Myself_Pro_Custom_Radio_Image_Control( $wp_customize, 'myself_pro_theme_options[page_sidebar_position]', array(
	'label'               => esc_html__( 'Pages Sidebar Position', 'myself-pro' ),
	'section'             => 'myself_pro_layout',
	'choices'			  => myself_pro_sidebar_position(),
) ) );