<?php
/**
 * Loader options
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */

$wp_customize->add_section( 'myself_pro_loader', array(
	'title'            		=> esc_html__( 'Loader','myself-pro' ),
	'description'      		=> esc_html__( 'Loader section options.', 'myself-pro' ),
	'panel'            		=> 'myself_pro_theme_options_panel',
) );

// Loader enable setting and control.
$wp_customize->add_setting( 'myself_pro_theme_options[loader_enable]', array(
	'sanitize_callback' => 'myself_pro_sanitize_switch_control',
	'default'             	=> $options['loader_enable'],
) );

$wp_customize->add_control(  new Myself_Pro_Switch_Control( $wp_customize, 'myself_pro_theme_options[loader_enable]', array(
	'label'               	=> esc_html__( 'Enable loader', 'myself-pro' ),
	'section'             	=> 'myself_pro_loader',
	'on_off_label' 		=> myself_pro_switch_options(),
) ) );

// Loader icons setting and control.
$wp_customize->add_setting( 'myself_pro_theme_options[loader_icon]', array(
	'sanitize_callback' 	=> 'myself_pro_sanitize_select',
	'default'				=> $options['loader_icon'],
) );

$wp_customize->add_control( 'myself_pro_theme_options[loader_icon]', array(
	'label'           		=> esc_html__( 'Icon', 'myself-pro' ),
	'section'         		=> 'myself_pro_loader',
	'type'					=> 'select',
	'choices'				=> myself_pro_get_spinner_list(),
	'active_callback' 		=> 'myself_pro_is_loader_enable',
) );
