<?php
/**
 * Menu options
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */

// Add sidebar section
$wp_customize->add_section( 'myself_pro_menu', array(
	'title'             => esc_html__('Header Menu','myself-pro'),
	'description'       => esc_html__( 'Header Menu options.', 'myself-pro' ),
	'panel'             => 'nav_menus',
) );

// Menu sticky setting and control.
$wp_customize->add_setting( 'myself_pro_theme_options[menu_sticky]', array(
	'sanitize_callback' => 'myself_pro_sanitize_switch_control',
	'default'           => $options['menu_sticky'],
) );

$wp_customize->add_control( new Myself_Pro_Switch_Control( $wp_customize, 'myself_pro_theme_options[menu_sticky]', array(
	'label'             => esc_html__( 'Make Menu Sticky', 'myself-pro' ),
	'section'           => 'myself_pro_menu',
	'on_off_label' 		=> myself_pro_switch_options(),
) ) );
