<?php
/**
 * pagination options
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */

// Add sidebar section
$wp_customize->add_section( 'myself_pro_pagination', array(
	'title'               => esc_html__('Pagination','myself-pro'),
	'description'         => esc_html__( 'Pagination section options.', 'myself-pro' ),
	'panel'               => 'myself_pro_theme_options_panel',
) );

// Sidebar position setting and control.
$wp_customize->add_setting( 'myself_pro_theme_options[pagination_enable]', array(
	'sanitize_callback' => 'myself_pro_sanitize_switch_control',
	'default'             => $options['pagination_enable'],
) );

$wp_customize->add_control( new Myself_Pro_Switch_Control( $wp_customize, 'myself_pro_theme_options[pagination_enable]', array(
	'label'               => esc_html__( 'Pagination Enable', 'myself-pro' ),
	'section'             => 'myself_pro_pagination',
	'on_off_label' 		=> myself_pro_switch_options(),
) ) );

// Site layout setting and control.
$wp_customize->add_setting( 'myself_pro_theme_options[pagination_type]', array(
	'sanitize_callback'   => 'myself_pro_sanitize_select',
	'default'             => $options['pagination_type'],
) );

$wp_customize->add_control( 'myself_pro_theme_options[pagination_type]', array(
	'label'               => esc_html__( 'Pagination Type', 'myself-pro' ),
	'section'             => 'myself_pro_pagination',
	'type'                => 'select',
	'choices'			  => myself_pro_pagination_options(),
	'active_callback'	  => 'myself_pro_is_pagination_enable',
) );
