<?php
/**
 * Section Sortable options
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */

// Add sidebar section
$wp_customize->add_section( 'myself_pro_sortable', array(
	'title'               => esc_html__('Homepage Sortable','myself-pro'),
	'description'         => esc_html__( 'Homepage Sortable options.', 'myself-pro' ),
	'panel'               => 'myself_pro_theme_options_panel',
) );

// Site layout setting and control.
$wp_customize->add_setting( 'myself_pro_theme_options[sortable]', array(
	'default'			  => $options['sortable'],
	'sanitize_callback'   => 'myself_pro_sanitize_sortable',
) );

$wp_customize->add_control( new Myself_Pro_Customize_Sortable_Control ( $wp_customize, 'myself_pro_theme_options[sortable]', array(
	'label'               => esc_html__( 'Sortable Homepage', 'myself-pro' ),
	'description'         => esc_html__( 'Drag and Drop to sort the sections according to your preference.', 'myself-pro' ),
	'section'             => 'myself_pro_sortable',
	'type'                => 'sortable',
	'choices'			  => myself_pro_sortable_sections(),
) ) );