<?php
/**
 * Typography options
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */

// Typography Section
$wp_customize->add_section( 'myself_pro_section_typography',
	array(
		'title'      		=> esc_html__( 'Typography', 'myself-pro' ),
		'priority'   		=> 600,
		'panel'      		=> 'myself_pro_theme_options_panel',
	)
);

// Theme typography setting and control.
$wp_customize->add_setting( 'myself_pro_theme_options[theme_typography]',
	array(
		'default'    		=> $options['theme_typography'],
		'sanitize_callback'	=> 'myself_pro_sanitize_select',
	)
);
$wp_customize->add_control( 'myself_pro_theme_options[theme_typography]',
    array(
		'label'       		=> esc_html__( 'Choose Heading Typography', 'myself-pro' ),
		'section'     		=> 'myself_pro_section_typography',
		'settings'    		=> 'myself_pro_theme_options[theme_typography]',
		'type'		  		=> 'select',
		'choices'			=> myself_pro_typography_options(),
    )
);

//Body Theme typography setting and control.
$wp_customize->add_setting( 'myself_pro_theme_options[body_theme_typography]',
	array(
		'default'    		=> $options['body_theme_typography'],
		'sanitize_callback'	=> 'myself_pro_sanitize_select',
	)
);
$wp_customize->add_control( 'myself_pro_theme_options[body_theme_typography]',
    array(
		'label'       		=> esc_html__( 'Choose Body Typography', 'myself-pro' ),
		'section'     		=> 'myself_pro_section_typography',
		'settings'    		=> 'myself_pro_theme_options[body_theme_typography]',
		'type'		  		=> 'select',
		'choices'			=> myself_pro_body_typography_options(),
    )
);