<?php
/**
* Customizer validation functions
*
* @package Theme Palace
* @subpackage Myself Pro
* @since Myself Pro 1.0.0
*/

if ( ! function_exists( 'myself_pro_validate_long_excerpt' ) ) :
  function myself_pro_validate_long_excerpt( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'myself-pro' ) );
     } elseif ( $value < 5 ) {
         $validity->add( 'min_no_of_words', esc_html__( 'Minimum no of words is 5', 'myself-pro' ) );
     } elseif ( $value > 100 ) {
         $validity->add( 'max_no_of_words', esc_html__( 'Maximum no of words is 100', 'myself-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'myself_pro_validate_my_profile_count' ) ) :
  function myself_pro_validate_my_profile_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'myself-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'myself-pro' ) );
     } elseif ( $value > 10 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 10', 'myself-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'myself_pro_validate_service_count' ) ) :
  function myself_pro_validate_service_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'myself-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'myself-pro' ) );
     } elseif ( $value > 6 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 6', 'myself-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'myself_pro_validate_experience_count' ) ) :
  function myself_pro_validate_experience_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'myself-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'myself-pro' ) );
     } elseif ( $value > 10 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 10', 'myself-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'myself_pro_validate_portfolio_count' ) ) :
  function myself_pro_validate_portfolio_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'myself-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'myself-pro' ) );
     } elseif ( $value > 12 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 12', 'myself-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'myself_pro_validate_clients_count' ) ) :
  function myself_pro_validate_clients_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'myself-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'myself-pro' ) );
     } elseif ( $value > 8 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 8', 'myself-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'myself_pro_validate_testimonial_count' ) ) :
  function myself_pro_validate_testimonial_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'myself-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'myself-pro' ) );
     } elseif ( $value > 10 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 10', 'myself-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'myself_pro_validate_blog_count' ) ) :
  function myself_pro_validate_blog_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'myself-pro' ) );
     } elseif ( $value < 2 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 2', 'myself-pro' ) );
     } elseif ( $value > 12 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 12', 'myself-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'myself_pro_validate_business_service_count' ) ) :
  function myself_pro_validate_business_service_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'myself-pro' ) );
     } elseif ( $value < 3 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 3', 'myself-pro' ) );
     } elseif ( $value > 12 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 12', 'myself-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'myself_pro_validate_helpus_count' ) ) :
  function myself_pro_validate_helpus_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'myself-pro' ) );
     } elseif ( $value < 3 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 3', 'myself-pro' ) );
     } elseif ( $value > 12 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 12', 'myself-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'myself_pro_validate_team_count' ) ) :
  function myself_pro_validate_team_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'myself-pro' ) );
     } elseif ( $value < 4 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 4', 'myself-pro' ) );
     } elseif ( $value > 8 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 8', 'myself-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'myself_pro_validate_introduction_count' ) ) :
  function myself_pro_validate_introduction_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'myself-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'myself-pro' ) );
     } elseif ( $value > 6 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 6', 'myself-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'myself_pro_validate_course_count' ) ) :
  function myself_pro_validate_course_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'myself-pro' ) );
     } elseif ( $value < 3 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 3', 'myself-pro' ) );
     } elseif ( $value > 12 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 12', 'myself-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'myself_pro_validate_photography_count' ) ) :
  function myself_pro_validate_photography_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'myself-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'myself-pro' ) );
     } elseif ( $value > 6 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 6', 'myself-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'myself_pro_validate_most_viewed_count' ) ) :
  function myself_pro_validate_most_viewed_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'myself-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'myself-pro' ) );
     } elseif ( $value > 6 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 6', 'myself-pro' ) );
     }
     return $validity;
  }
endif;
