<?php
// /**
//  * Demo Import.
//  *
//  * This is the template that includes all the other files for core featured of Theme Palace
//  *
//  * @package Theme Palace
//  * @subpackage Myself Pro
//  * @since Myself Pro 1.0.0
//  */


function myself_pro_ctdi_plugin_page_setup( $default_settings ) {
    $default_settings['menu_title']  = esc_html__( 'Theme Palace Demo Import' , 'myself-pro' );

    return $default_settings;
}
add_filter( 'cp-ctdi/plugin_page_setup', 'myself_pro_ctdi_plugin_page_setup' );


function myself_pro_ctdi_import_files() {
    return array(
        array(
            'import_file_name'             => esc_html__( 'Pro Demo', 'myself-pro' ),
            'categories'                   => array( ),
            'local_import_file'            => get_template_directory() . '/assets/demo-data/myself-pro-all-content.xml',
            'local_import_widget_file'     => get_template_directory() . '/assets/demo-data/myself-pro-widgets.wie',
            'local_import_customizer_file' => get_template_directory() . '/assets/demo-data/myself-pro-customizer.dat',
            'import_preview_image_url'     => get_template_directory_uri() . '/assets/demo/pro/screenshot.png',
            'import_notice'                => esc_html__( 'Please wait for a few minutes, do not close the window or refresh the page until the data is imported.', 'myself-pro' ),
            'preview_url'                  => 'https://themepalacedemo.com/myself-pro/',
        ),

        // array(
        //     'import_file_name'             => esc_html__( 'Dark Demo', 'myself-pro' ),
        //     'categories'                   => array( ),
        //     'local_import_file'            => get_template_directory() . '/assets/demo/dark/content.xml',
        //     'local_import_widget_file'     => get_template_directory() . '/assets/demo/dark/widgets.wie',
        //     'local_import_customizer_file' => get_template_directory() . '/assets/demo/dark/customizer.dat',
        //     'import_preview_image_url'     => get_template_directory_uri() . '/assets/demo/dark/screenshot.png',
        //     'import_notice'                => esc_html__( 'Please wait for a few minutes, do not close the window or refresh the page until the data is imported.', 'myself-pro' ),
        //     'preview_url'                  => 'https://themepalacedemo.com/myself-pro-dark/',
        // ),

        // array(
        //     'import_file_name'             => esc_html__( 'Shop Demo', 'myself-pro' ),
        //     'categories'                   => array( ),
        //     'local_import_file'            => get_template_directory() . '/assets/demo/shop/content.xml',
        //     'local_import_widget_file'     => get_template_directory() . '/assets/demo/shop/widgets.wie',
        //     'local_import_customizer_file' => get_template_directory() . '/assets/demo/shop/customizer.dat',
        //     'import_preview_image_url'     => get_template_directory_uri() . '/assets/demo/shop/screenshot.png',
        //     'import_notice'                => esc_html__( 'Please wait for a few minutes, do not close the window or refresh the page until the data is imported.', 'myself-pro' ),
        //     'preview_url'                  => 'https://themepalacedemo.com/myself-shop/',
        // ),

        //   array(
        //     'import_file_name'             => esc_html__( 'Blog Demo', 'myself-pro' ),
        //     'categories'                   => array( ),
        //     'local_import_file'            => get_template_directory() . '/assets/demo/blog/content.xml',
        //     'local_import_widget_file'     => get_template_directory() . '/assets/demo/blog/widgets.wie',
        //     'local_import_customizer_file' => get_template_directory() . '/assets/demo/blog/customizer.dat',
        //     'import_preview_image_url'     => get_template_directory_uri() . '/assets/demo/blog/screenshot.png',
        //     'import_notice'                => esc_html__( 'Please wait for a few minutes, do not close the window or refresh the page until the data is imported.', 'myself-pro' ),
        //     'preview_url'                  => 'https://themepalacedemo.com/myself-blog/',
        // ),

        //    array(
        //     'import_file_name'             => esc_html__( 'Education Demo', 'myself-pro' ),
        //     'categories'                   => array( ),
        //     'local_import_file'            => get_template_directory() . '/assets/demo/education/content.xml',
        //     'local_import_widget_file'     => get_template_directory() . '/assets/demo/education/widgets.wie',
        //     'local_import_customizer_file' => get_template_directory() . '/assets/demo/education/customizer.dat',
        //     'import_preview_image_url'     => get_template_directory_uri() . '/assets/demo/education/screenshot.png',
        //     'import_notice'                => esc_html__( 'Please wait for a few minutes, do not close the window or refresh the page until the data is imported.', 'myself-pro' ),
        //     'preview_url'                  => 'https://themepalacedemo.com/myself-education/',
        // ),

        //    array(
        //     'import_file_name'             => esc_html__( 'Travel Demo', 'myself-pro' ),
        //     'categories'                   => array( ),
        //     'local_import_file'            => get_template_directory() . '/assets/demo/travel/content.xml',
        //     'local_import_widget_file'     => get_template_directory() . '/assets/demo/travel/widgets.wie',
        //     'local_import_customizer_file' => get_template_directory() . '/assets/demo/travel/customizer.dat',
        //     'import_preview_image_url'     => get_template_directory_uri() . '/assets/demo/travel/screenshot.png',
        //     'import_notice'                => esc_html__( 'Please wait for a few minutes, do not close the window or refresh the page until the data is imported.', 'myself-pro' ),
        //     'preview_url'                  => 'https://themepalacedemo.com/myself-travel/',
        // ),

        //    array(
        //     'import_file_name'             => esc_html__( 'Charity Demo', 'myself-pro' ),
        //     'categories'                   => array( ),
        //     'local_import_file'            => get_template_directory() . '/assets/demo/charity/content.xml',
        //     'local_import_widget_file'     => get_template_directory() . '/assets/demo/charity/widgets.wie',
        //     'local_import_customizer_file' => get_template_directory() . '/assets/demo/charity/customizer.dat',
        //     'import_preview_image_url'     => get_template_directory_uri() . '/assets/demo/charity/screenshot.png',
        //     'import_notice'                => esc_html__( 'Please wait for a few minutes, do not close the window or refresh the page until the data is imported.', 'myself-pro' ),
        //     'preview_url'                  => 'https://themepalacedemo.com/myself-charity/',
        // ),

        //     array(
        //     'import_file_name'             => esc_html__( 'Medical Demo', 'myself-pro' ),
        //     'categories'                   => array( ),
        //     'local_import_file'            => get_template_directory() . '/assets/demo/medical/content.xml',
        //     'local_import_widget_file'     => get_template_directory() . '/assets/demo/medical/widgets.wie',
        //     'local_import_customizer_file' => get_template_directory() . '/assets/demo/medical/customizer.dat',
        //     'import_preview_image_url'     => get_template_directory_uri() . '/assets/demo/medical/screenshot.png',
        //     'import_notice'                => esc_html__( 'Please wait for a few minutes, do not close the window or refresh the page until the data is imported.', 'myself-pro' ),
        //     'preview_url'                  => 'https://themepalacedemo.com/myself-medical/',
        // ),

        //      array(
        //     'import_file_name'             => esc_html__( 'Business Demo', 'myself-pro' ),
        //     'categories'                   => array( ),
        //     'local_import_file'            => get_template_directory() . '/assets/demo/business/content.xml',
        //     'local_import_widget_file'     => get_template_directory() . '/assets/demo/business/widgets.wie',
        //     'local_import_customizer_file' => get_template_directory() . '/assets/demo/business/customizer.dat',
        //     'import_preview_image_url'     => get_template_directory_uri() . '/assets/demo/business/screenshot.png',
        //     'import_notice'                => esc_html__( 'Please wait for a few minutes, do not close the window or refresh the page until the data is imported.', 'myself-pro' ),
        //     'preview_url'                  => 'https://themepalacedemo.com/myself-business/',
        // ),


    );
}
add_filter( 'cp-ctdi/import_files', 'myself_pro_ctdi_import_files' );



function myself_pro_ctdi_after_import_setup() {
    // Assign menus to their locations.
    $main_menu = get_term_by( 'name', 'Primary', 'nav_menu' );
    $social = get_term_by('name', 'Social', 'nav_menu');

    set_theme_mod( 'nav_menu_locations', array(
            'primary' => $main_menu->term_id,
            'social' => $social->term_id,
        )
    );

    // Assign front page and posts page (blog page).
    $front_page_id = get_page_by_title( 'Home' );
    $blog_page_id  = get_page_by_title( 'Blog' );

    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );
    update_option( 'page_for_posts', $blog_page_id->ID );

}
add_action( 'cp-ctdi/after_import', 'myself_pro_ctdi_after_import_setup' );