<?php
/**
 * Theme Palace options
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */

/**
 * List of pages for page choices.
 * @return Array Array of page ids and name.
 */
function myself_pro_page_choices() {
    $pages = get_pages();
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'myself-pro' );
    foreach ( $pages as $page ) {
        $choices[ $page->ID ] = $page->post_title;
    }
    return  $choices;
}

/**
 * List of posts for post choices.
 * @return Array Array of post ids and name.
 */
function myself_pro_post_choices() {
    $posts = get_posts( array( 'numberposts' => -1 ) );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'myself-pro' );
    foreach ( $posts as $post ) {
        $choices[ $post->ID ] = $post->post_title;
    }
    return  $choices;
}

/**
 * List of trips for post choices.
 * @return Array Array of post ids and name.
 */
function myself_pro_trip_choices() {
    $posts = get_posts( array( 'post_type' => 'itineraries', 'numberposts' => -1 ) );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'myself-pro' );
    foreach ( $posts as $post ) {
        $choices[ $post->ID ] = $post->post_title;
    }
    wp_reset_postdata();
    return  $choices;
}

if ( ! function_exists( 'myself_pro_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function myself_pro_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'myself-pro' ),
            'header-font-1'   => esc_html__( 'Rajdhani', 'myself-pro' ),
            'header-font-2'   => esc_html__( 'Cherry Swash', 'myself-pro' ),
            'header-font-3'   => esc_html__( 'Philosopher', 'myself-pro' ),
            'header-font-4'   => esc_html__( 'Slabo 27px', 'myself-pro' ),
            'header-font-5'   => esc_html__( 'Dosis', 'myself-pro' ),
        );

        $output = apply_filters( 'myself_pro_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;


if ( ! function_exists( 'myself_pro_body_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function myself_pro_body_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'myself-pro' ),
            'body-font-1'     => esc_html__( 'News Cycle', 'myself-pro' ),
            'body-font-2'     => esc_html__( 'Pontano Sans', 'myself-pro' ),
            'body-font-3'     => esc_html__( 'Gudea', 'myself-pro' ),
            'body-font-4'     => esc_html__( 'Quattrocento', 'myself-pro' ),
            'body-font-5'     => esc_html__( 'Khand', 'myself-pro' ),
        );

        $output = apply_filters( 'myself_pro_body_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;


if ( ! function_exists( 'myself_pro_site_layout' ) ) :
    /**
     * Site Layout
     * @return array site layout options
     */
    function myself_pro_site_layout() {
        $myself_pro_site_layout = array(
            'wide'  => get_template_directory_uri() . '/assets/images/full.png',
            'boxed-layout' => get_template_directory_uri() . '/assets/images/boxed.png',
        );

        $output = apply_filters( 'myself_pro_site_layout', $myself_pro_site_layout );
        return $output;
    }
endif;

if ( ! function_exists( 'myself_pro_selected_sidebar' ) ) :
    /**
     * Sidebars options
     * @return array Sidbar positions
     */
    function myself_pro_selected_sidebar() {
        $myself_pro_selected_sidebar = array(
            'sidebar-1'             => esc_html__( 'Default Sidebar', 'myself-pro' ),
            'optional-sidebar'      => esc_html__( 'Optional Sidebar 1', 'myself-pro' ),
            'optional-sidebar-2'    => esc_html__( 'Optional Sidebar 2', 'myself-pro' ),
            'optional-sidebar-3'    => esc_html__( 'Optional Sidebar 3', 'myself-pro' ),
            'optional-sidebar-4'    => esc_html__( 'Optional Sidebar 4', 'myself-pro' ),
        );

        $output = apply_filters( 'myself_pro_selected_sidebar', $myself_pro_selected_sidebar );

        return $output;
    }
endif;


if ( ! function_exists( 'myself_pro_global_sidebar_position' ) ) :
    /**
     * Global Sidebar position
     * @return array Global Sidebar positions
     */
    function myself_pro_global_sidebar_position() {
        $myself_pro_global_sidebar_position = array(
            'right-sidebar' => get_template_directory_uri() . '/assets/images/right.png',
            'left-sidebar'  => get_template_directory_uri() . '/assets/images/left.png',
            'no-sidebar'    => get_template_directory_uri() . '/assets/images/full.png',
        );

        $output = apply_filters( 'myself_pro_global_sidebar_position', $myself_pro_global_sidebar_position );

        return $output;
    }
endif;


if ( ! function_exists( 'myself_pro_sidebar_position' ) ) :
    /**
     * Sidebar position
     * @return array Sidbar positions
     */
    function myself_pro_sidebar_position() {
        $myself_pro_sidebar_position = array(
            'right-sidebar' => get_template_directory_uri() . '/assets/images/right.png',
            'left-sidebar'  => get_template_directory_uri() . '/assets/images/left.png',
            'no-sidebar'    => get_template_directory_uri() . '/assets/images/full.png',
            'no-sidebar-content'   => get_template_directory_uri() . '/assets/images/boxed.png',
        );

        $output = apply_filters( 'myself_pro_sidebar_position', $myself_pro_sidebar_position );

        return $output;
    }
endif;


if ( ! function_exists( 'myself_pro_pagination_options' ) ) :
    /**
     * Pagination
     * @return array site pagination options
     */
    function myself_pro_pagination_options() {
        $myself_pro_pagination_options = array(
            'numeric'   => esc_html__( 'Numeric', 'myself-pro' ),
            'default'   => esc_html__( 'Default(Older/Newer)', 'myself-pro' ),
            'infinite'  => esc_html__( 'Infinite', 'myself-pro' ),
        );

        $output = apply_filters( 'myself_pro_pagination_options', $myself_pro_pagination_options );

        return $output;
    }
endif;

if ( ! function_exists( 'myself_pro_get_spinner_list' ) ) :
    /**
     * List of spinner icons options.
     * @return array List of all spinner icon options.
     */
    function myself_pro_get_spinner_list() {
        $arr = array(
            'default'               => esc_html__( 'Default', 'myself-pro' ),
            'spinner-wheel'         => esc_html__( 'Wheel', 'myself-pro' ),
            'spinner-double-circle' => esc_html__( 'Double Circle', 'myself-pro' ),
            'spinner-two-way'       => esc_html__( 'Two Way', 'myself-pro' ),
            'spinner-umbrella'      => esc_html__( 'Umbrella', 'myself-pro' ),
            'spinner-circle'        => esc_html__( 'Circle', 'myself-pro' ),
            'spinner-dots'          => esc_html__( 'Dots', 'myself-pro' ),
            'spinner-one-way'       => esc_html__( 'One Way', 'myself-pro' ),
            'spinner-fidget'        => esc_html__( 'Fidget', 'myself-pro' ),
        );
        return apply_filters( 'myself_pro_spinner_list', $arr );
    }
endif;

if ( ! function_exists( 'myself_pro_switch_options' ) ) :
    /**
     * List of custom Switch Control options
     * @return array List of switch control options.
     */
    function myself_pro_switch_options() {
        $arr = array(
            'on'        => esc_html__( 'Enable', 'myself-pro' ),
            'off'       => esc_html__( 'Disable', 'myself-pro' )
        );
        return apply_filters( 'myself_pro_switch_options', $arr );
    }
endif;

if ( ! function_exists( 'myself_pro_hide_options' ) ) :
    /**
     * List of custom Switch Control options
     * @return array List of switch control options.
     */
    function myself_pro_hide_options() {
        $arr = array(
            'on'        => esc_html__( 'Yes', 'myself-pro' ),
            'off'       => esc_html__( 'No', 'myself-pro' )
        );
        return apply_filters( 'myself_pro_hide_options', $arr );
    }
endif;

if ( ! function_exists( 'myself_pro_sortable_sections' ) ) :
    /**
     * List of sections Control options
     * @return array List of Sections control options.
     */
    function myself_pro_sortable_sections() {
        $sections = array(
            'introduction'  => esc_html__( 'Introduction', 'myself-pro' ),
            'about'         => esc_html__( 'About Me', 'myself-pro' ),
            'my_profile'    => esc_html__( 'My Profile', 'myself-pro' ),
            'service'       => esc_html__( 'Services', 'myself-pro' ),
            'experience'    => esc_html__( 'Work Experience', 'myself-pro' ),
            'portfolio'     => esc_html__( 'Portfolio', 'myself-pro' ),
            'video'         => esc_html__( 'Video', 'myself-pro' ),
            'clients'       => esc_html__( 'Clients', 'myself-pro' ),
            'testimonial'   => esc_html__( 'Testimonial', 'myself-pro' ),
            'skills'        => esc_html__( 'Skills', 'myself-pro' ),
            'blog'          => esc_html__( 'Blog', 'myself-pro' ),
            'contact'       => esc_html__( 'Contact', 'myself-pro' ),
            'cta'           => esc_html__( 'Call to Action', 'myself-pro' ),
            'instagram'     => esc_html__( 'Instagram', 'myself-pro' ),
        );
        return apply_filters( 'myself_pro_sortable_sections', $sections );
    }
endif;


if ( ! function_exists( 'myself_pro_popular_destination_content_type' ) ) :
    /**
     * Destination Options
     * @return array site gallery options
     */
    function myself_pro_popular_destination_content_type() {
        $myself_pro_popular_destination_content_type = array(
            'page'      => esc_html__( 'Page', 'myself-pro' ),
            'post'      => esc_html__( 'Post', 'myself-pro' ),
            'category'  => esc_html__( 'Category', 'myself-pro' ),
        );

        if ( class_exists( 'WP_Travel' ) ) {
            $myself_pro_popular_destination_content_type = array_merge( $myself_pro_popular_destination_content_type, array(
                'trip'          => esc_html__( 'Trip', 'myself-pro' ),
                'trip-types'    => esc_html__( 'Trip Types', 'myself-pro' ),
                'destination'   => esc_html__( 'Destination', 'myself-pro' ),
                'activity'      => esc_html__( 'Activity', 'myself-pro' ),
                ) );
        }

        $output = apply_filters( 'myself_pro_popular_destination_content_type', $myself_pro_popular_destination_content_type );


        return $output;
    }
endif;


if ( ! function_exists( 'myself_pro_popular_tours_content_type' ) ) :
    /**
     * Tours Options
     * @return array site gallery options
     */
    function myself_pro_popular_tours_content_type() {
        $myself_pro_popular_tours_content_type = array(
            'page'      => esc_html__( 'Page', 'myself-pro' ),
            'post'      => esc_html__( 'Post', 'myself-pro' ),
            'category'  => esc_html__( 'Category', 'myself-pro' ),
        );

        if ( class_exists( 'WP_Travel' ) ) {
            $myself_pro_popular_tours_content_type = array_merge( $myself_pro_popular_tours_content_type, array(
                'trip'          => esc_html__( 'Trip', 'myself-pro' ),
                'trip-types'    => esc_html__( 'Trip Types', 'myself-pro' ),
                'tours'         => esc_html__( 'Tours', 'myself-pro' ),
                'activity'      => esc_html__( 'Activity', 'myself-pro' ),
                ) );
        }

        $output = apply_filters( 'myself_pro_popular_tours_content_type', $myself_pro_popular_tours_content_type );


        return $output;
    }
endif;


if ( ! function_exists( 'myself_pro_portfolio_content_type' ) ) :
    /**
     * Tours Options
     * @return array site gallery options
     */
    function myself_pro_portfolio_content_type() {
		$options  = myself_pro_get_theme_options();

        $myself_pro_portfolio_content_type = array(
            'page'      => esc_html__( 'Page', 'myself-pro' ),
            'post'      => esc_html__( 'Post', 'myself-pro' ),
            'category'  => esc_html__( 'Category', 'myself-pro' ),
        );

        if ( class_exists( 'WP_Travel' ) && $options['home_layout'] == 'third-design' ) {
            $myself_pro_portfolio_content_type = array_merge( $myself_pro_portfolio_content_type, array(
                'trip'          => esc_html__( 'Trip', 'myself-pro' ),
                'trip-types'    => esc_html__( 'Trip Types', 'myself-pro' ),
                'destination'   => esc_html__( 'Destination', 'myself-pro' ),
                'activity'      => esc_html__( 'Activity', 'myself-pro' ),
                ) );
        }

        $output = apply_filters( 'myself_pro_portfolio_content_type', $myself_pro_portfolio_content_type );

        return $output;
    }
endif;