<?php
/**
 * Blog section
 *
 * This is the template for the content of blog section
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */
if ( ! function_exists( 'myself_pro_add_blog_section' ) ) :
    /**
    * Add blog section
    *
    *@since Myself Pro 1.0.0
    */
    function myself_pro_add_blog_section() {
    	$options = myself_pro_get_theme_options();
        // Check if blog is enabled on frontpage
        $blog_enable = apply_filters( 'myself_pro_section_status', true, 'blog_section_enable' );

        if ( true !== $blog_enable ) {
            return false;
        }
        // Get blog section details
        $section_details = array();
        $section_details = apply_filters( 'myself_pro_filter_blog_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render blog section now.
        myself_pro_render_blog_section( $section_details );
    }
endif;

if ( ! function_exists( 'myself_pro_get_blog_section_details' ) ) :
    /**
    * blog section details.
    *
    * @since Myself Pro 1.0.0
    * @param array $input blog section details.
    */
    function myself_pro_get_blog_section_details( $input ) {
        $options = myself_pro_get_theme_options();

        // Content type.
        $blog_content_type  = $options['blog_content_type'];
        $blog_count = ! empty( $options['blog_count'] ) ? $options['blog_count'] : 4;
        
        $content = array();
        switch ( $blog_content_type ) {
        	
            case 'page':
                $page_ids = array();

                for ( $i = 1; $i <= $blog_count; $i++ ) {
                    if ( ! empty( $options['blog_content_page_' . $i] ) )
                        $page_ids[] = $options['blog_content_page_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'orderby'           => 'post__in',
                    'posts_per_page'    => absint( $blog_count ),
                    );                    
            break;

            case 'post':
                $post_ids = array();

                for ( $i = 1; $i <= $blog_count; $i++ ) {
                    if ( ! empty( $options['blog_content_post_' . $i] ) )
                        $post_ids[] = $options['blog_content_post_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $blog_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'category':
                $cat_id = ! empty( $options['blog_content_category'] ) ? $options['blog_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $blog_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'recent':
                $cat_ids = ! empty( $options['blog_category_exclude'] ) ? $options['blog_category_exclude'] : array();
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $blog_count ),
                    'category__not_in'  => ( array ) $cat_ids,
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            default:
            break;
        }


        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['image']  	= has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'medium_large' ) :get_template_directory_uri().'/assets/uploads/no-featured-image-590x650.jpg';
                $page_post['author']    = myself_pro_author();
                $page_post['excerpt']   = myself_pro_trim_content( 30 );


                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// blog section content details.
add_filter( 'myself_pro_filter_blog_section_details', 'myself_pro_get_blog_section_details' );


if ( ! function_exists( 'myself_pro_render_blog_section' ) ) :
  /**
   * Start blog section
   *
   * @return string blog content
   * @since Myself Pro 1.0.0
   *
   */
   function myself_pro_render_blog_section( $content_details = array() ) {
        $options = myself_pro_get_theme_options();
        $column = ! empty( $options['blog_column'] ) ? $options['blog_column'] : 'col-4';
        $blog_description = $options['blog_description'];

        if ( empty( $content_details ) ) {
            return;
        } 
        if( $options['home_layout'] == 'third-design' || $options['home_layout'] == 'fourth-design' || $options['home_layout'] == 'fifth-design' || $options['home_layout'] == 'sixth-design' || $options['home_layout'] == 'seventh-design' || $options['home_layout'] == 'eight-design') : ?>

            <div id="business-latest-posts" class="relative page-section">
                <div class="wrapper">
                    <div class="business-section-header">
                        <h2 class="business-section-title"><?php echo esc_html( $options['blog_title'] ); ?></h2>
                        <?php echo empty($blog_description && !in_array($options['home_layout'], array('eight-design','seventh-design'))  ) ? '' : '<p class="business-section-subtitle">'. wp_kses_post($blog_description) .'</p>' ;?>
                    </div><!-- .business-section-header -->

                    <div class="business-section-content clear <?php echo esc_attr( $column ); ?>">
                        <?php foreach ( $content_details as $content ) : ?>
                            <article class="<?php echo has_post_thumbnail( $content['id'] ) ? 'has' : 'no'; ?>-post-thumbnail">
                                <div class="business-post-item">
                                    <div class="featured-image">
                                        <a href="<?php echo esc_url( $content['url'] ); ?>"><img src="<?php echo esc_url( $content['image'] ); ?>" alt="<?php echo esc_attr( $content['title'] ); ?>"></a>
                                    </div><!-- .featured-image -->

                                    <div class="entry-container">
                                        <header class="entry-header">
                                            <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                        </header>

                                        <div class="entry-content">
                                            <p><?php echo wp_kses_post( $content['excerpt'] ); ?></p>
                                        </div><!-- .entry-content -->

                                        <div class="entry-meta clear">
                                            <?php   myself_pro_posted_on( $content['id'] );  ?>

                                            <?php if ( ! empty( $options['blog_btn_title'] ) && $options['home_layout'] != 'eight-design' ) : ?>
                                                <span class="more-link"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $options['blog_btn_title'] ); ?></a></span>
                                            <?php endif; ?>

                                        </div><!-- .entry-meta -->
                                    </div><!-- .entry-container -->
                                </div><!-- .business-post-item -->
                            </article>
                        <?php endforeach; ?>

                    </div><!-- .business-section-content -->
                </div><!-- .wrapper -->
            </div><!-- #business-latest-posts -->

        <?php else: ?>

            <div id="latest-posts" class="relative page-section">
                <div class="wrapper">
                    <?php if ( ! empty( $options['blog_title'] ) ) : ?>
                        <div class="section-header text-center">
                            <h2 class="section-title"><?php echo esc_html( $options['blog_title'] ); ?></h2>
                        </div>
                    <?php endif; ?>

                    <div class="archive-blog-wrapper clear <?php echo esc_attr( $column ); ?>">
                        <?php foreach ( $content_details as $content ) : ?>
                            <article class="<?php echo has_post_thumbnail( $content['id'] ) ? 'has' : 'no'; ?>-post-thumbnail">
                                <?php if ( ! empty( $content['image'] ) ) : ?>
                                    <div class="featured-image">
                                        <img src="<?php echo esc_url( $content['image'] ); ?>" alt="<?php echo esc_attr( $content['title'] ); ?>">
                                    </div><!-- .featured-image -->
                                <?php endif; ?>

                                <div class="entry-container">
                                    <div class="entry-meta">
                                        <span class="cat-links">
                                            <?php echo myself_pro_article_footer_meta( $content['id'] ); ?>
                                        </span><!-- .cat-links -->
                                    </div><!-- .entry-meta -->

                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                    </header>

                                    <div class="entry-meta">
                                        <?php 
                                            echo wp_kses_post( $content['author'] );
                                            myself_pro_posted_on( $content['id'] ); 
                                        ?>
                                    </div><!-- .entry-meta -->
                                </div><!-- .entry-container -->
                            </article>
                        <?php endforeach; ?>
                    </div><!-- .archive-blog-wrapper -->

                    <?php if ( ! empty( $options['blog_btn_title'] ) && ! empty( $options['blog_btn_url'] ) ) : ?>
                        <div class="read-more">
                            <a href="<?php echo esc_url( $options['blog_btn_url'] ); ?>" class="btn"><?php echo esc_html( $options['blog_btn_title'] ); ?></a>
                        </div><!-- .read-more -->
                    <?php endif; ?>
                </div><!-- .wrapper -->
            </div><!-- #latest-posts -->
        <?php endif; 
    }
endif;