<?php
/**
 * service section
 *
 * This is the template for the content of service section
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */
if ( ! function_exists( 'myself_pro_add_business_service_section' ) ) :
    /**
    * Add service section
    *
    *@since Myself Pro 1.0.0
    */
    function myself_pro_add_business_service_section() {
    	$options = myself_pro_get_theme_options();
        // Check if service is enabled on frontpage
        $business_service_enable = apply_filters( 'myself_pro_section_status', true, 'business_service_section_enable' );

        if ( true !== $business_service_enable ) {
            return false;
        }
        // Get service section details
        $section_details = array();
        $section_details = apply_filters( 'myself_pro_filter_business_service_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render service section now.
        myself_pro_render_business_service_section( $section_details );
    }
endif;

if ( ! function_exists( 'myself_pro_get_business_service_section_details' ) ) :
    /**
    * service section details.
    *
    * @since Myself Pro 1.0.0
    * @param array $input service section details.
    */
    function myself_pro_get_business_service_section_details( $input ) {
        $options = myself_pro_get_theme_options();

        // Content type.
        $business_service_content_type  = $options['business_service_content_type'];
        $business_service_count = ! empty( $options['business_service_count'] ) ? $options['business_service_count'] : 3;
        
        $content = array();
        switch ( $business_service_content_type ) {
        	
            case 'page':
                $page_ids = array();

                for ( $i = 1; $i <= $business_service_count; $i++ ) {
                    if ( ! empty( $options['business_service_content_page_' . $i] ) )
                        $page_ids[] = $options['business_service_content_page_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $business_service_count ),
                    'orderby'           => 'post__in',
                    );                    
            break;

            case 'post':
                $post_ids = array();

                for ( $i = 1; $i <= $business_service_count; $i++ ) {
                    if ( ! empty( $options['business_service_content_post_' . $i] ) )
                        $post_ids[] = $options['business_service_content_post_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $business_service_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'category':
                $cat_id = ! empty( $options['business_service_content_category'] ) ? $options['business_service_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $business_service_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            default:
            break;
        }


        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['excerpt']   = myself_pro_trim_content( 15 );
                $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'post-thumbnail' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();

            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// service section content details.
add_filter( 'myself_pro_filter_business_service_section_details', 'myself_pro_get_business_service_section_details' );


if ( ! function_exists( 'myself_pro_render_business_service_section' ) ) :
  /**
   * Start service section
   *
   * @return string service content
   * @since Myself Pro 1.0.0
   *
   */
   function myself_pro_render_business_service_section( $content_details = array() ) {
        $options = myself_pro_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        } 
        if($options['home_layout'] == 'fifth-design') : 

        $business_service_title             = ! empty( $options['business_service_title'] ) ? $options['business_service_title'] : '';
        $business_service_subtitle      = ! empty( $options['business_service_subtitle'] ) ? $options['business_service_subtitle'] : '';  ?>

            <div id="business-services-section" class="relative page-section">
                <div class="wrapper">
                    <div class="business-section-header">
                        <h2 class="business-section-title"><?php echo esc_html($business_service_title); ?></h2>
                        <p class="business-section-subtitle"><?php echo wp_kses_post($business_service_subtitle); ?></p>
                    </div><!-- .business-section-header -->

                    <div class="business-section-content col-<?php echo esc_attr( $options['business_service_posts_column'] ); ?> clear">
                        <?php   foreach ( $content_details as $i => $content ) : ?>

                            <article>
                                <div class="business-service-item">
                                    <div class="business-service-icon">
                                        <a href="<?php echo esc_url($content['url']); ?>"><i class="fa <?php echo ! empty( $options['business_service_content_icon_' . ($i+1) . ''] ) ? esc_attr( $options['business_service_content_icon_' . ($i+1) . ''] ) : 'fa-area-chart' ; ?>"></i></a>
                                    </div><!-- .business-service-icon -->

                                    <div class="entry-container">
                                        <header class="entry-header">
                                            <h2 class="entry-title"><a href="<?php echo esc_url($content['url']); ?>"><?php echo esc_html($content['title'])?></a></h2>
                                        </header>

                                        <div class="entry-content">
                                            <p><?php echo wp_kses_post($content['excerpt']); ?></p>                    
                                        </div><!-- .entry-content -->
                                    </div><!-- .entry-container -->
                                </div><!-- .business-service-item -->
                            </article>
                        <?php endforeach; ?>
                    </div><!-- .section-content -->
                </div><!-- .wrapper -->
            </div><!-- #business-services-section -->

        <?php else: ?>
            <div id="business-services-section" class="relative page-section">
                <div class="wrapper">
                    <div class="business-section-content col-<?php echo esc_attr( $options['business_service_posts_column'] ); ?> clear">
                        <?php   foreach ( $content_details as $i => $content ) : ?>
                            <article>
                                <div class="service-item">
                                    <div class="icon-container">
                                        <a href="<?php echo esc_url($content['url']); ?>"><i class="fa <?php echo ! empty( $options['business_service_content_icon_' . ($i+1) . ''] ) ? esc_attr( $options['business_service_content_icon_' . ($i+1) . ''] ) : 'fa-leaf' ; ?>"></i></a>
                                    </div><!-- .icon-container -->

                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_url($content['url']); ?>"><?php echo esc_html($content['title'])?></a></h2>
                                    </header>

                                    <div class="entry-content">
                                        <p><?php echo wp_kses_post($content['excerpt']); ?></p>                    
                                    </div><!-- .entry-content -->
                                </div><!-- .service-item -->
                            </article>
                        <?php endforeach; ?>

                    </div><!-- .section-content -->
                </div><!-- .wrapper -->
            </div><!-- #business-services-section -->

    <?php endif; }
endif;