<?php
/**
 * Contact section
 *
 * This is the template for the content of contact section
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */
if ( ! function_exists( 'myself_pro_add_contact_section' ) ) :
    /**
    * Add contact section
    *
    *@since Myself Pro 1.0.0
    */
    function myself_pro_add_contact_section() {
    	$options = myself_pro_get_theme_options();
        // Check if contact is enabled on frontpage
        $contact_enable = apply_filters( 'myself_pro_section_status', true, 'contact_section_enable' );

        if ( true !== $contact_enable ) {
            return false;
        }

        // Render contact section now.
        myself_pro_render_contact_section();
    }
endif;

if ( ! function_exists( 'myself_pro_render_contact_section' ) ) :
  /**
   * Start contact section
   *
   * @return string contact content
   * @since Myself Pro 1.0.0
   *
   */
   function myself_pro_render_contact_section() {
        $options = myself_pro_get_theme_options();
        $background = ! empty( $options['contact_image'] ) ? $options['contact_image'] : get_template_directory_uri() . '/assets/uploads/custom-header-image.jpg';
        ?>

        <div id="contact-me" class="relative page-section" style="background-image: url('<?php echo esc_url( $background ); ?>');">
            <div class="overlay"></div>
            <div class="wrapper">
                <div class="col-2 clear">
                    <div class="hentry">
                        <?php if ( ! empty( $options['contact_title'] ) ) : ?>
                            <div class="section-header">
                                <h2 class="section-title"><?php echo esc_html( $options['contact_title'] ); ?></h2>
                            </div><!-- .section-header -->
                        <?php endif; ?>

                        <ul class="contact-info">
                            <?php if ( ! empty( $options['contact_address'] ) ) : ?>
                                <li>
                                    <?php echo myself_pro_get_svg( array( 'icon' => 'location' ) ); ?>
                                    <span class="title"><?php esc_html_e( 'Address :', 'myself-pro' ); ?></span><span class="address"><?php echo wp_kses_post( $options['contact_address'] ); ?></span>
                                </li>
                            <?php endif; ?>

                            <?php if ( ! empty( $options['contact_phone'] ) ) : ?>
                                <li>
                                    <?php echo myself_pro_get_svg( array( 'icon' => 'phone' ) ); ?>
                                    <span class="title"><?php esc_html_e( 'Phone No :', 'myself-pro' ); ?></span>
                                    <span>
                                        <?php 
                                        $phones = explode( '|', $options['contact_phone'] ); 
                                        foreach ( $phones as $phone ) : ?>
                                            <a href="tel:<?php echo esc_attr( $phone ); ?>"><?php echo esc_html( $phone ); ?></a>
                                        <?php endforeach; ?>
                                    </span>
                                </li>
                            <?php endif; ?>

                            <?php if ( ! empty( $options['contact_email'] ) ) : ?>
                                <li>
                                    <?php echo myself_pro_get_svg( array( 'icon' => 'envelope' ) ); ?>
                                    <span class="title"><?php esc_html_e( 'E-mail :', 'myself-pro' ); ?></span>
                                    <span>
                                        <?php 
                                        $emails = explode( '|', $options['contact_email'] ); 
                                        foreach ( $emails as $email ) : ?>
                                            <a href="mailto:<?php echo esc_attr( $email ); ?>"><?php echo esc_html( $email ); ?></a>
                                        <?php endforeach; ?>
                                    </span>
                                </li>
                            <?php endif; ?>
                            
                        </ul>

                        <?php if ( ! empty( $options['contact_social'] ) ) : ?>
                            <div class="social-icons">
                                <ul>
                                    <?php 
                                    $socials = explode( '|', $options['contact_social'] ); 
                                    foreach ( $socials as $social ) : ?>
                                        <li><a href="<?php echo esc_url( $social ); ?>"><?php echo myself_pro_return_social_icon( $social ); ?></a></li>
                                    <?php endforeach; ?>
                                </ul>
                            </div><!-- .social-icons -->
                        <?php endif; ?>
                    </div><!-- .hentry -->

                    <?php if ( ! empty( $options['contact_shortcode'] ) ) : ?>
                        <div class="hentry">
                            <?php echo do_shortcode( wp_kses_post( $options['contact_shortcode'] ) ); ?>
                        </div><!-- .hentry -->
                    <?php endif; ?>
                </div><!-- .col-2 -->
            </div><!-- .wrapper -->
        </div><!-- #contact-me -->

    <?php }
endif;