<?php
/**
 * Counter section
 *
 * This is the template for the content of counter section
 *
 * @package Theme Palace
 * @subpackage yself Pro
 * @since Myself Pro 1.0.0
 */
if ( ! function_exists( 'myself_pro_add_counter_section' ) ) :
    /**
    * Add counter section
    *
    *@since Myself Pro 1.0.0
    */
    function myself_pro_add_counter_section() {
        $options = myself_pro_get_theme_options();
        // Check if counter is enabled on frontpage
        $counter_enable = apply_filters( 'myself_pro_section_status', true, 'counter_section_enable' );

        if ( true !== $counter_enable ) {
            return false;
        }

        // Render counter section now.
        myself_pro_render_counter_section();
    }
endif;

if ( ! function_exists( 'myself_pro_render_counter_section' ) ) :
  /**
   * Start counter section
   *
   * @return string counter content
   * @since Myself Pro 1.0.0
   *
   */
   function myself_pro_render_counter_section() {
        $options = myself_pro_get_theme_options();
        $image   = empty( $options['counter_image'] ) ? '' : $options['counter_image'] ;
        $counter_count = ! empty( $options['counter_count'] ) ? $options['counter_count'] : 4;
        $contents = array();
        for( $i= 1; $i <= absint( $counter_count ); $i++ ){
            $page_post['icon']      = empty( $options['counter_content_icon_'.$i] ) ? '' : $options['counter_content_icon_'.$i] ;
            $page_post['title']     = empty( $options['counter_title_'.$i] ) ? '' :$options['counter_title_'.$i];
            $page_post['number']    = empty( $options['counter_number_'.$i] ) ? '' :$options['counter_number_'.$i];

            if(!empty($page_post['icon']) && !empty($page_post['icon']) && !empty($page_post['icon'])){
                array_push( $contents, $page_post );
            }
        }
        
        if( empty($contents) ){
            return ;
        }
        ?>
            <div id="business-counter" class="relative page-section" style="background-image:url('<?php echo esc_url( $image ) ; ?>');">
                <div class="overlay"></div>
                <div class="wrapper">
                    <div class="business-section-content col-4">

                        <?php foreach ( $contents as $content ): ?>
                            <?php if ( ! empty( $content['title'] ) || ! empty( $content['icon'] ) || ! empty( $content['number'] ) ): ?>
                                <article>
                                    <header class="entry-header">
                                        <div class="counter-icon">
                                            <i class="fa <?php echo esc_attr( $content['icon'] ) ; ?>"></i>
                                        </div><!-- .counter-icon -->
                                        <h3 class="counter-value">
                                            <?php echo esc_html( $content['number'] ); ?>                                    
                                        </h3>
                                        <div class="separator-line"></div>
                                        <h2 class="entry-title">
                                            <?php echo esc_html( $content['title'] ); ?>    
                                        </h2>
                                    </header>
                                </article>
                            <?php endif; ?>                           
                        <?php endforeach; ?>
                        </div><!-- .col-4 -->
                </div><!-- .wrapper -->
            </div>
    <?php }
endif;
