<?php
/**
 * Course section
 *
 * This is the template for the content of Course section
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */
if ( ! function_exists( 'myself_pro_add_course_section' ) ) :
    /**
    * Add Course section
    *
    *@since Myself Pro 1.0.0
    */
    function myself_pro_add_course_section() {
    	$options = myself_pro_get_theme_options();
        // Check if Course is enabled on frontpage
        $course_enable = apply_filters( 'myself_pro_section_status', true, 'course_section_enable' );

        if ( true !== $course_enable ) {
            return false;
        }
        // Get Course section details
        $section_details = array();
        $section_details = apply_filters( 'myself_pro_filter_course_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render Course section now.
        myself_pro_render_course_section( $section_details );
    }
endif;

if ( ! function_exists( 'myself_pro_get_course_section_details' ) ) :
    /**
    * Course section details.
    *
    * @since Myself Pro 1.0.0
    * @param array $input Course section details.
    */
    function myself_pro_get_course_section_details( $input ) {
        $options = myself_pro_get_theme_options();

        // Content type.
        $course_content_type  = $options['course_content_type'];
        $course_count = ! empty( $options['course_count'] ) ? $options['course_count'] : 3;
        
        $content = array();
        switch ( $course_content_type ) {
            
            case 'page':
                $page_ids = array();

                for ( $i = 1; $i <= $course_count; $i++ ) {
                    if ( ! empty( $options['course_content_page_' . $i] ) )
                        $page_ids[] = $options['course_content_page_' . $i];
                }

                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $course_count ),
                    'orderby'           => 'post__in',
                    );                    
            break;

            case 'post':
                $post_ids = array();

                for ( $i = 1; $i <= $course_count; $i++ ) {
                    if ( ! empty( $options['course_content_post_' . $i] ) )
                        $post_ids[] = $options['course_content_post_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $course_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'category':
                $cat_id = ! empty( $options['course_content_category'] ) ? $options['course_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $course_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            default:
            break;
        }

        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['excerpt']   = myself_pro_trim_content( 20 );
                $page_post['url']       = get_the_permalink();
                $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'medium_large' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// Course section content details.
add_filter( 'myself_pro_filter_course_section_details', 'myself_pro_get_course_section_details' );


if ( ! function_exists( 'myself_pro_render_course_section' ) ) :
  /**
   * Start Course section
   *
   * @return string Course content
   * @since Myself Pro 1.0.0
   *
   */
   function myself_pro_render_course_section( $content_details = array() ) {
        $options = myself_pro_get_theme_options();
        $course_content_type  = $options['course_content_type'];
        $column = ! empty( $options['course_column'] ) ? $options['course_column'] : 'col-3';

        if ( empty( $content_details ) ) {
            return;
        }
        if($options['home_layout'] == 'sixth-design') : ?>
           <div id="magazine-must-read">
                <div class="wrapper">
                    <div class="section-header">
                        <h2 class="section-title"><?php echo esc_html( $options['course_title'] ); ?></h2>
                    </div><!-- .section-header -->

                    <div class="section-content magazine <?php echo esc_attr( $column ); ?> clear">
                        <?php foreach ( $content_details as $content ) : ?>

                            <article class="hentry">
                                <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ); ?>');">
                                    <a href="#" class="post-thumbnail-link"></a>
                                    <div class="entry-meta">
                                        <span class="cat-links">
                                            <?php the_category( '', '', $content['id'] ); ?>
                                        </span><!-- .cat-links -->      
                                    </div>
                                </div><!-- .featured-image -->

                                <div class="entry-container">
                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                    </header>

                                    <div class="footer-meta">
                                        <?php   myself_pro_posted_on( $content['id'] );  ?>
                                        
                                    </div><!-- .entry-meta -->
                                </div><!-- .entry-container -->
                            </article>
                    <?php endforeach; ?>

                    </div><!-- .section-content -->
                </div><!-- .wrapper -->
            </div><!-- #must-read -->

        <?php elseif($options['home_layout'] == 'seventh-design'): ?>
            <div id="blog-latest-posts" class="relative page-section">
                <div class="wrapper">
                    <div class="business-section-header">
                        <h2 class="business-section-title"><?php echo esc_html( $options['course_title'] ); ?></h2>
                    </div><!-- .business-section-header -->

                    <div class="section-content clear">
                        <?php foreach ( $content_details as $content ) : ?>

                            <article>
                                <div class="blog-post-wrapper">
                                    <span class="cat-links">
                                        <?php the_category( '', '', $content['id'] ); ?>
                                    </span><!-- .cat-links -->

                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                    </header>

                                    <?php   myself_pro_posted_on( $content['id'] );  ?>

                                    <div class="featured-image">
                                        <a href="<?php echo esc_url( $content['url'] ); ?>"><img src="<?php echo esc_url( $content['image'] ); ?>"></a>
                                    </div><!-- .featured-image -->

                                    <div class="entry-content">
                                        <p><?php echo esc_html( $content['excerpt'] ); ?></p>
                                    </div><!-- .entry-content -->

                                    <div class="read-more">
                                        <a href="<?php echo esc_url( $content['url'] ); ?>">Continue Reading</a>
                                    </div><!-- .read-more  -->
                                </div><!-- .blog-post-wrapper -->
                            </article>
                        <?php endforeach; ?>
                    </div><!-- .section-content -->
                </div><!-- .wrapper -->
            </div>
        <?php else:?>

            <div id="courses-section" class="relative page-section">
                <div class="wrapper">
                    <div class="business-section-header">
                    <?php if( !empty( $options['course_title'] ) ): ?>
                        <h2 class="business-section-title"><?php echo esc_html( $options['course_title'] ); ?></h2>
                    <?php endif;
                    if( !empty( $options['course_subtitle'] ) ): ?>
                        <p class="business-section-subtitle"><?php echo esc_html( $options['course_subtitle'] ); ?></p>
                    <?php endif; ?>
                    </div><!-- .business-section-header -->

                    <!-- .supports col-1, col-2 and col-3 -->
                    <div class="business-section-content clear col-3">
                        
                        <?php foreach ( $content_details as $content ) : ?>

                        <article class="hentry">
                            <div class="courses-wrapper">
                            <?php if( !empty( $content['image'] ) ): ?>
                                <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ); ?>');">
                                    <a href="<?php echo esc_url( $content['url'] ); ?>" class="featured-image-link"></a>
                                </div><!-- .featured-image -->
                            <?php endif; ?>

                                <div class="entry-container">
                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                    </header>
                                    <P><?php echo esc_html( $content['excerpt'] ); ?></P>
                                </div><!-- .entry-container -->
                            </div><!-- .courses-wrapper -->
                        </article>

                    <?php endforeach; ?>

                    </div><!-- .section-content -->
                </div><!-- .wrapper -->
            </div>

    <?php endif;
    }    
endif;