<?php
/**
 * Call to action section
 *
 * This is the template for the content of cta section
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */
if ( ! function_exists( 'myself_pro_add_cta_section' ) ) :
    /**
    * Add cta section
    *
    *@since Myself Pro 1.0.0
    */
    function myself_pro_add_cta_section() {
    	$options = myself_pro_get_theme_options();
        // Check if cta is enabled on frontpage
        $cta_enable = apply_filters( 'myself_pro_section_status', true, 'cta_section_enable' );

        if ( true !== $cta_enable ) {
            return false;
        }
        // Get cta section details
        $section_details = array();
        $section_details = apply_filters( 'myself_pro_filter_cta_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render cta section now.
        myself_pro_render_cta_section( $section_details );
    }
endif;

if ( ! function_exists( 'myself_pro_get_cta_section_details' ) ) :
    /**
    * cta section details.
    *
    * @since Myself Pro 1.0.0
    * @param array $input cta section details.
    */
    function myself_pro_get_cta_section_details( $input ) {
        $options = myself_pro_get_theme_options();

        // Content type.
        $cta_content_type  = $options['cta_content_type'];
        
        $content = array();
        switch ( $cta_content_type ) {
        	
            case 'custom':
                $custom['title']        = ! empty( $options['cta_title'] ) ? $options['cta_title'] : '';
                $custom['url']          = ! empty( $options['cta_btn_link'] ) ? $options['cta_btn_link'] : '';

                // Push to the main array.
                array_push( $content, $custom );
            break;

            case 'page':
                $page_id = ! empty( $options['cta_content_page'] ) ? $options['cta_content_page'] : '';
                $args = array(
                    'post_type'         => 'page',
                    'page_id'           => $page_id,
                    'posts_per_page'    => 1,
                    );                    
            break;

            case 'post':
                $post_id = ! empty( $options['cta_content_post'] ) ? $options['cta_content_post'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'p'                 => $post_id,
                    'posts_per_page'    => 1,
                    'ignore_sticky_posts' => true,
                    );
            break;

            default:
            break;
        }

        if ( 'custom' !== $cta_content_type ) :
            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['title']     = get_the_title();
                    $page_post['url']       = get_the_permalink();

                    // Push to the main array.
                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();
        endif;
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// cta section content details.
add_filter( 'myself_pro_filter_cta_section_details', 'myself_pro_get_cta_section_details' );


if ( ! function_exists( 'myself_pro_render_cta_section' ) ) :
  /**
   * Start cta section
   *
   * @return string cta content
   * @since Myself Pro 1.0.0
   *
   */
   function myself_pro_render_cta_section( $content_details = array() ) {
        $options = myself_pro_get_theme_options();
        $readmore = ! empty( $options['cta_btn_title'] ) ? $options['cta_btn_title'] : esc_html__( 'Get a free Estimate', 'myself-pro' );

        if ( empty( $content_details ) ) {
            return;
        } 

        foreach ( $content_details as $content ) : ?>

            <div id="call-to-action" class="relative page-section">
                <div class="wrapper">
                    <?php if ( ! empty( $content['title'] ) ) : ?>
                        <div class="section-header text-center">
                            <h2 class="section-title"><?php echo esc_html( $content['title'] ); ?></h2>
                        </div><!-- .section-header -->
                    <?php endif;

                    if ( ! empty( $content['url'] ) ) : ?>
                        <div class="read-more">
                            <a href="<?php echo esc_url( $content['url'] ); ?>" class="btn"><?php echo esc_html( $readmore ); ?></a>
                        </div><!-- .read-more -->
                    <?php endif; ?>
                </div><!-- .wrapper -->
            </div><!-- .call-to-action -->

        <?php endforeach;
    }
endif;