<?php
/**
 * Work Experience section
 *
 * This is the template for the content of experience section
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */
if ( ! function_exists( 'myself_pro_add_experience_section' ) ) :
    /**
    * Add experience section
    *
    *@since Myself Pro 1.0.0
    */
    function myself_pro_add_experience_section() {
        $options = myself_pro_get_theme_options();
        // Check if experience is enabled on frontpage
        $experience_enable = apply_filters( 'myself_pro_section_status', true, 'experience_section_enable' );

        if ( true !== $experience_enable ) {
            return false;
        }
        // Get experience section details
        $section_details = array();
        $section_details = apply_filters( 'myself_pro_filter_experience_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render experience section now.
        myself_pro_render_experience_section( $section_details );
    }
endif;

if ( ! function_exists( 'myself_pro_get_experience_section_details' ) ) :
    /**
    * experience section details.
    *
    * @since Myself Pro 1.0.0
    * @param array $input experience section details.
    */
    function myself_pro_get_experience_section_details( $input ) {
        $options = myself_pro_get_theme_options();

        // Content type.
        $experience_content_type  = $options['experience_content_type'];
        $experience_count = ! empty( $options['experience_count'] ) ? $options['experience_count'] : 5;
        
        $content = array();
        $duration = array();

        switch ( $experience_content_type ) {
            
            case 'page':
                $page_ids = array();

                for ( $i = 1; $i <= $experience_count; $i++ ) {
                    if ( ! empty( $options['experience_content_page_' . $i] ) ) :
                        $page_ids[] = $options['experience_content_page_' . $i];
                        $duration[] = ! empty( $options['experience_duration_' . $i] ) ? $options['experience_duration_' . $i] : '';
                    endif;
                }
                
                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $experience_count ),
                    'orderby'           => 'post__in',
                    );                    
            break;

            case 'post':
                $post_ids = array();

                for ( $i = 1; $i <= $experience_count; $i++ ) {
                    if ( ! empty( $options['experience_content_post_' . $i] ) ) :
                        $post_ids[] = $options['experience_content_post_' . $i];
                        $duration[] = ! empty( $options['experience_duration_' . $i] ) ? $options['experience_duration_' . $i] : '';
                    endif;
                }
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $experience_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'custom':
                for ( $i = 1; $i <= absint( $experience_count ); $i++ ) {
                    $custom['title']        = ! empty( $options['experience_title_' . $i] ) ? $options['experience_title_' . $i] : '';
                    $custom['excerpt']      = ! empty( $options['experience_description_' . $i] ) ? $options['experience_description_' . $i] : '';
                    $custom['image']        = ! empty( $options['experience_image_' . $i] ) ? $options['experience_image_' . $i] : '';
                    $custom['url']          = ! empty( $options['experience_url_' . $i] ) ? $options['experience_url_' . $i] : '#.';
                    $custom['duration']     = ! empty( $options['experience_duration_' . $i] ) ? $options['experience_duration_' . $i] : '';

                    if ( ! empty( $custom['title'] ) ) :
                        // Push to the main array.
                        array_push( $content, $custom );
                    endif;
                }                   
            break;

            default:
            break;
        }

            if ( 'custom' !== $experience_content_type ) :
                // Run The Loop.
                $query = new WP_Query( $args );
                $i = 0;
                if ( $query->have_posts() ) : 
                    while ( $query->have_posts() ) : $query->the_post();
                        $page_post['title']     = get_the_title();
                        $page_post['url']       = get_the_permalink();
                        $page_post['excerpt']   = myself_pro_trim_content( 15 );
                        $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'medium_large' ) : '';
                        $page_post['duration']  = ! empty( $duration[ $i ] ) ? $duration[ $i ] : '';

                        // Push to the main array.
                        array_push( $content, $page_post );
                        $i++;
                    endwhile;
                endif;
                wp_reset_postdata();
            endif;
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// experience section content details.
add_filter( 'myself_pro_filter_experience_section_details', 'myself_pro_get_experience_section_details' );


if ( ! function_exists( 'myself_pro_render_experience_section' ) ) :
  /**
   * Start experience section
   *
   * @return string experience content
   * @since Myself Pro 1.0.0
   *
   */
   function myself_pro_render_experience_section( $content_details = array() ) {
        $options = myself_pro_get_theme_options();
        $column = ! empty( $options['experience_column_type'] ) ? $options['experience_column_type'] : 4;

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="working-experience" class="relative page-section">
            <div class="wrapper">
                <?php if ( ! empty( $options['experience_title'] ) ) : ?>
                    <div class="section-header">
                        <h2 class="section-title"><?php echo esc_html( $options['experience_title'] ); ?></h2>
                    </div><!-- .section-header -->
                <?php endif; 

                if ( ! empty( $options['experience_description'] ) ) : ?>
                    <div class="section-content">
                        <p><?php echo wp_kses_post( $options['experience_description'] ); ?></p>
                    </div><!-- .section-content -->
                <?php endif; ?>

                <div class="clear"></div>

                <div class="working-experience-slider" data-slick='{"slidesToShow": <?php echo esc_attr( $column ); ?>, "slidesToScroll": 1, "infinite": false, "speed": 1000, "dots": false, "arrows":true, "autoplay": true, "draggable": true, "fade": false }'>
                    <?php foreach ( $content_details as $content ) : ?>
                        <article>
                            <?php if ( ! empty( $content['image'] ) ) : ?>
                                <div class="featured-image">
                                    <img src="<?php echo esc_url( $content['image'] ); ?>" alt="<?php echo esc_attr( $content['title'] ); ?>">
                                </div><!-- .featured-image -->
                            <?php endif; ?>

                            <div class="entry-container">
                                <?php if ( ! empty( $content['duration'] ) ) : ?>
                                    <div class="entry-meta">
                                        <span class="posted-on">
                                            <a href="<?php echo esc_url( $content['url'] ); ?>" rel="bookmark"><time>
                                                <?php echo esc_html( $content['duration'] ); ?>
                                            </time></a>
                                        </span><!-- .posted-on -->
                                    </div><!-- .entry-meta -->
                                <?php endif;

                                if ( ! empty( $content['title'] ) ) : ?>
                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                    </header>
                                <?php endif; 

                                if ( ! empty( $content['excerpt'] ) ) : ?>
                                    <div class="entry-content">
                                        <p><?php echo wp_kses_post( $content['excerpt'] ); ?></p>
                                    </div><!-- .entry-content -->
                                <?php endif; ?>
                            </div><!-- .entry-container -->
                        </article>
                    <?php endforeach; ?>
                </div><!-- .working-experience-slider -->
            </div><!-- .wrapper -->
        </div><!-- #working-experience -->
        
    <?php }
endif;