<?php
/**
 * Help Us section
 *
 * This is the template for the content of Help Us section
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */
if ( ! function_exists( 'myself_pro_add_helpus_section' ) ) :
    /**
    * Add Help Us section
    *
    *@since Myself Pro 1.0.0
    */
    function myself_pro_add_helpus_section() {
    	$options = myself_pro_get_theme_options();
        // Check if Help Us is enabled on frontpage
        $helpus_enable = apply_filters( 'myself_pro_section_status', true, 'helpus_section_enable' );

        if ( true !== $helpus_enable ) {
            return false;
        }
        // Get Help Us section details
        $section_details = array();
        $section_details = apply_filters( 'myself_pro_filter_helpus_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render Help Us section now.
        myself_pro_render_helpus_section( $section_details );
    }
endif;

if ( ! function_exists( 'myself_pro_get_helpus_section_details' ) ) :
    /**
    * Help Us section details.
    *
    * @since Myself Pro 1.0.0
    * @param array $input Help Us section details.
    */
    function myself_pro_get_helpus_section_details( $input ) {
        $options = myself_pro_get_theme_options();

        // Content type.
        $helpus_content_type  = $options['helpus_content_type'];
        $helpus_count = ! empty( $options['helpus_count'] ) ? $options['helpus_count'] : 4;
        
        $content = array();
        switch ( $helpus_content_type ) {
        	
            case 'page':
                $page_ids = array();

                for ( $i = 1; $i <= $helpus_count; $i++ ) {
                    if ( ! empty( $options['helpus_content_page_' . $i] ) )
                        $page_ids[] = $options['helpus_content_page_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $helpus_count ),
                    'orderby'           => 'post__in',
                    );                    
            break;

            case 'post':
                $post_ids = array();

                for ( $i = 1; $i <= $helpus_count; $i++ ) {
                    if ( ! empty( $options['helpus_content_post_' . $i] ) )
                        $post_ids[] = $options['helpus_content_post_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $helpus_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'category':
                $cat_id = ! empty( $options['helpus_content_category'] ) ? $options['helpus_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $helpus_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'recent':
                $cat_ids = ! empty( $options['helpus_category_exclude'] ) ? $options['helpus_category_exclude'] : array();
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $helpus_count ),
                    'category__not_in'  => ( array ) $cat_ids,
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            default:
            break;
        }


        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['image']  	= has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'medium_large' ) :get_template_directory_uri().'/assets/uploads/no-featured-image-590x650.jpg';
                $page_post['author']    = myself_pro_author();
                $page_post['excerpt']   = myself_pro_trim_content( 30 );


                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// Help Us section content details.
add_filter( 'myself_pro_filter_helpus_section_details', 'myself_pro_get_helpus_section_details' );


if ( ! function_exists( 'myself_pro_render_helpus_section' ) ) :
  /**
   * Start Help Us section
   *
   * @return string Help Us content
   * @since Myself Pro 1.0.0
   *
   */
   function myself_pro_render_helpus_section( $content_details = array() ) {
        $options = myself_pro_get_theme_options();
        $column = ! empty( $options['helpus_column'] ) ? $options['helpus_column'] : 'col-3';

        if ( empty( $content_details ) ) {
            return;
        }
        if($options['home_layout'] == 'sixth-design'): ?>
            
            <div id="magazine-thumbnail-post">
                <div class="wrapper">
                    <div class="thumbnail-wrapper magazine <?php echo esc_attr( $column ); ?> clear">
                        <div class="thumbnail-post-wrapper">
                        <?php foreach ( $content_details as $content ) : ?>

                            <article>
                                <div class="featured-image">
                                    <a href="<?php echo esc_url( $content['url'] ); ?>"><img src="<?php echo esc_url( $content['image'] ); ?>"></a>
                                </div><!-- .featured-image -->

                                <div class="entry-container">
                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                    </header>

                                    <div class="entry-meta">

                                        <?php  myself_pro_posted_on( $content['id'] );  ?>

                                    </div><!-- .entry-meta -->
                                </div><!-- .entry-container -->
                            </article>
                        <?php endforeach; ?>

                        </div>
                    </div><!-- .thumbnail --> 
                </div><!-- .wrapper -->
            </div><!-- #thumbnail-posts -->

        <?php elseif($options['home_layout'] == 'seventh-design'): ?>

            <div id="blog-featured-posts" class="relative page-section">
                <div class="wrapper"> 
                    <div class="blog-section-content col-3 clear">
                    <?php foreach ( $content_details as $content ) : ?>

                        <article>
                            <div class="blog-featured-item" style="background-image: url('<?php echo esc_url( $content['image'] ); ?>');">
                                <header class="entry-header">
                                    <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                </header>
                            </div><!-- .blog-featured-item -->
                        </article>
                        <?php endforeach; ?>

                    </div><!-- .blog-section-content -->
                </div><!-- .wrapper -->
            </div>
        <?php else: ?>

            <div id="help-us" class="page-section no-padding-bottom">
                <div class="wrapper">
                    <div class="business-section-header">
                        <h2 class="business-section-title"><?php echo esc_html( $options['helpus_title'] ); ?></h2>
                    </div>

                    <div class="section-content col-3">
                        <?php foreach ( $content_details as $content ) : ?>

                            <article class="hentry">
                                <div class="help-wrapper">
                                    <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ); ?>');">
                                    <a href="<?php echo esc_url( $content['url'] ); ?>" class="post-thumbnail-link"></a>
                                    </div><!-- .featured-image -->

                                    <div class="entry-container">
                                        <header class="entry-header">
                                            <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                        </header>

                                        <div class="entry-content">
                                            <p><?php echo wp_kses_post( $content['excerpt'] ); ?></p>
                                        </div>

                                        <?php if ( ! empty( $options['helpus_btn_title'] ) ) : ?>
                                            <div class="business-read-more">
                                                <a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $options['helpus_btn_title'] ); ?></a>
                                            </div>
                                        <?php endif; ?>

                                    </div><!-- .entry-container -->
                                </div><!-- .help-wrapper -->
                            </article>
                        <?php endforeach; ?>

                    </div><!-- .section-content -->
                </div><!-- .wrapper -->
            </div><!-- #help-us -->

<?php   endif;  }
endif;