<?php
/**
 * Instagram section
 *
 * This is the template for the content of instagram section
 *
 * @package Theme Palace
 * @subpackage Myself Pro
 * @since Myself Pro 1.0.0
 */
if ( ! function_exists( 'myself_pro_add_instagram_section' ) ) :
    /**
    * Add instagram section
    *
    *@since Myself Pro 1.0.0
    */
    function myself_pro_add_instagram_section() {
      $options = myself_pro_get_theme_options();
        // Check if instagram is enabled on frontpage
        $instagram_enable = apply_filters( 'myself_pro_section_status', true, 'instagram_section_enable' );

        if ( true !== $instagram_enable ) {
            return false;
        }

        // Render instagram section now.
        myself_pro_render_instagram_section();
    }
endif;

if ( ! function_exists( 'myself_pro_render_instagram_section' ) ) :
  /**
   * Start instagram section
   *
   * @return string instagram content
   * @since Myself Pro 1.0.0
   *
   */
   function myself_pro_render_instagram_section() {
        $options = myself_pro_get_theme_options();
        ?>    

          <?php 

          if (!empty( $options['instagram_shortcode'] )) {

            echo do_shortcode( $options['instagram_shortcode'] ); 
            
          }

          ?>    

    <?php }
endif;